/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tool.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.tool.bean.BorrowContentEntity;
import com.ejianc.business.tool.bean.BorrowEntity;
import com.ejianc.business.tool.bean.ReturnContentEntity;
import com.ejianc.business.tool.bean.ReturnEntity;
import com.ejianc.business.tool.service.IBorrowService;
import com.ejianc.business.tool.service.impl.BorrowContentServiceImpl;
import com.ejianc.business.tool.service.impl.ReturnContentServiceImpl;
import com.ejianc.business.tool.service.impl.ReturnServiceImpl;
import com.ejianc.business.tool.vo.BorrowRequestVO;
import com.ejianc.business.tool.vo.BorrowVO;
import com.ejianc.business.utils.PageUtils;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"borrow"})
public class BorrowController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "BORROW";
    @Autowired
    private IBorrowService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private BorrowContentServiceImpl borrowContentService;
    @Autowired
    private ReturnContentServiceImpl returnContentService;
    @Autowired
    private ReturnServiceImpl returnService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<BorrowVO> saveOrUpdate(@RequestBody BorrowVO saveOrUpdateVO) {
        BorrowEntity entity = (BorrowEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, BorrowEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        BorrowVO vo = (BorrowVO)BeanMapper.map((Object)((Object)entity), BorrowVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BorrowVO> queryDetail(Long id) {
        BorrowEntity entity = (BorrowEntity)((Object)this.service.selectById(id));
        BorrowVO vo = (BorrowVO)BeanMapper.map((Object)((Object)entity), BorrowVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BorrowVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (BorrowVO borrowVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<BorrowVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode", "projectName", "borrowName", "billName"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        Object orgVOList = null;
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), BorrowVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ResponseBody
    @RequestMapping(value={"/getHaveBorrowNum"}, method={RequestMethod.POST})
    public CommonResponse<Map<Long, Integer>> getHaveBorrowNum(@RequestBody BorrowRequestVO borrowVO) {
        Long projectId = borrowVO.getProjectId();
        Long storeId = borrowVO.getStoreId();
        List materialIds = borrowVO.getMaterialIds();
        Map<Long, Integer> map = null;
        if (storeId == null || projectId == null) {
            return CommonResponse.error((String)"\u9879\u76ee\u6216\u4ed3\u5e93Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        LambdaQueryWrapper query = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BorrowEntity::getProjectId, (Object)projectId)).eq(BorrowEntity::getStoreId, (Object)storeId)).in(BorrowEntity::getBillState, Arrays.asList(1, 3));
        List list = this.service.list((Wrapper)query);
        List collect1 = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(collect1)) {
            return CommonResponse.success(null);
        }
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(BorrowContentEntity::getToolId, (Collection)materialIds)).in(BorrowContentEntity::getBorrowId, collect1);
        if (queryWrapper == null) {
            return CommonResponse.success(null);
        }
        List borrowList = this.borrowContentService.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)borrowList)) {
            return CommonResponse.success(null);
        }
        map = borrowList.stream().collect(Collectors.groupingBy(BorrowContentEntity::getToolId, Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().mapToInt(BorrowContentEntity::getBorrowNum).sum())));
        LambdaQueryWrapper queryWrapper1 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ReturnEntity::getProjectId, (Object)projectId)).eq(ReturnEntity::getStoreId, (Object)storeId)).in(ReturnEntity::getBillState, Arrays.asList(1, 3));
        List list1 = this.returnService.list((Wrapper)queryWrapper1);
        List collect2 = list1.stream().map(BaseEntity::getId).collect(Collectors.toList());
        Map<Long, Integer> collect = null;
        if (CollectionUtils.isNotEmpty(collect2)) {
            LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(ReturnContentEntity::getToolId, (Collection)materialIds)).in(ReturnContentEntity::getReturnId, collect2);
            List returnList = this.returnContentService.list((Wrapper)wrapper);
            if (CollectionUtils.isEmpty((Collection)returnList)) {
                return CommonResponse.success(map);
            }
            collect = returnList.stream().collect(Collectors.groupingBy(ReturnContentEntity::getToolId, Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().mapToInt(ReturnContentEntity::getReturnNum).sum())));
        }
        for (Map.Entry<Long, Integer> longIntegerEntry : map.entrySet()) {
            Long key = longIntegerEntry.getKey();
            if (collect == null || !collect.containsKey(key)) continue;
            longIntegerEntry.setValue(map.get(key) - collect.get(key));
        }
        return CommonResponse.success(map);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode", "projectName", "borrowName", "billName"));
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List entityList = this.service.queryList(param);
        List list = BeanMapper.mapList((Iterable)entityList, BorrowVO.class);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            list.forEach(vo -> {
                BillStateEnum billStateEnum;
                Integer billState = vo.getBillState();
                if (billState != null && (billStateEnum = BillStateEnum.getEnumByStateCode((Integer)billState)) != null) {
                    vo.setBillStateName(billStateEnum.getDescription());
                }
            });
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Borrow-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refBorrowData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> refBorrowData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        Map<Long, Integer> map;
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (condition.contains("projectId")) {
                param.getParams().put("projectId", new Parameter("eq", (Object)_con.getString("projectId")));
            }
            if (condition.contains("storeId")) {
                param.getParams().put("storeId", new Parameter("eq", (Object)_con.getString("storeId")));
            }
        }
        param.getParams().put("billState", new Parameter("in", Arrays.asList(1, 3)));
        JSONObject pageData = new JSONObject();
        pageData.put("current", (Object)("" + param.getPageIndex()));
        pageData.put("size", (Object)("" + param.getPageSize()));
        pageData.put("records", new ArrayList());
        pageData.put("total", (Object)"0");
        pageData.put("pages", (Object)"0");
        ArrayList voList = new ArrayList();
        IPage borrowEntityIPage = this.service.queryPage(param, false);
        List borrowList = borrowEntityIPage.getRecords();
        List ids = borrowList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        Map borrowMap = borrowList.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity()));
        if (CollectionUtils.isEmpty(ids)) {
            return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
        }
        LambdaQueryWrapper in = (LambdaQueryWrapper)new LambdaQueryWrapper().in(BorrowContentEntity::getBorrowId, ids);
        List list = this.borrowContentService.list((Wrapper)in);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
        }
        List records = BeanMapper.mapList((Iterable)list, BorrowVO.class);
        IPage returnEntityIPage = this.returnService.queryPage(param, false);
        List records1 = returnEntityIPage.getRecords();
        List collect = records1.stream().map(BaseEntity::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(collect)) {
            LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().in(ReturnContentEntity::getReturnId, collect);
            List list1 = this.returnContentService.list((Wrapper)wrapper);
            map = list1.stream().filter(s -> s.getToolId() != null).collect(Collectors.groupingBy(ReturnContentEntity::getToolId, Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(ReturnContentEntity::getReturnNum).mapToInt(Integer::intValue).sum())));
        } else {
            map = null;
        }
        if (CollectionUtils.isNotEmpty((Collection)records)) {
            records.forEach(record -> {
                if (borrowMap.containsKey(record.getBorrowId())) {
                    record.setProjectName(((BorrowEntity)((Object)((Object)borrowMap.get(record.getBorrowId())))).getProjectName());
                    record.setStoreName(((BorrowEntity)((Object)((Object)borrowMap.get(record.getBorrowId())))).getStoreName());
                    record.setBillCode(((BorrowEntity)((Object)((Object)borrowMap.get(record.getBorrowId())))).getBillCode());
                    record.setBorrowDate(((BorrowEntity)((Object)((Object)borrowMap.get(record.getBorrowId())))).getBorrowDate());
                    record.setBorrowPart(((BorrowEntity)((Object)((Object)borrowMap.get(record.getBorrowId())))).getBorrowPart());
                    record.setBorrowName(((BorrowEntity)((Object)((Object)borrowMap.get(record.getBorrowId())))).getBorrowName());
                    record.setEmployeeName(((BorrowEntity)((Object)((Object)borrowMap.get(record.getBorrowId())))).getEmployeeName());
                    record.setBillName(((BorrowEntity)((Object)((Object)borrowMap.get(record.getBorrowId())))).getBillName());
                }
                Integer returnNum = 0;
                if (record.getBorrowNum() != null) {
                    Long toolId = record.getToolId();
                    if (map != null && map.containsKey(toolId)) {
                        returnNum = (Integer)map.get(toolId);
                    }
                    record.setHaveBorrowNum(Integer.valueOf(record.getHaveBorrowNum() + record.getBorrowNum() - returnNum));
                    if (record.getBorrowNum() - returnNum > 0) {
                        voList.add(record);
                    }
                }
            });
        }
        if (CollectionUtils.isNotEmpty(voList)) {
            int total = voList.size();
            JSONArray jsonArray = JSONArray.parseArray((String)JSONArray.toJSONString(voList));
            JSONArray recordss = PageUtils.listToPage(jsonArray, param.getPageIndex(), param.getPageSize());
            int pages = PageUtils.getPages(total, param.getPageSize());
            pageData.put("records", (Object)recordss);
            pageData.put("total", (Object)("" + total));
            pageData.put("pages", (Object)("" + pages));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

