/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tool.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.store.api.IStoreManageApi;
import com.ejianc.business.store.consts.InOutTypeEnum;
import com.ejianc.business.store.util.StoreManageUtil;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.business.store.vo.StoreManageVO;
import com.ejianc.business.tool.bean.ScrapEntity;
import com.ejianc.business.tool.service.IScrapService;
import com.ejianc.business.tool.service.impl.ScrapContentBpmServiceImpl;
import com.ejianc.business.tool.vo.ScrapVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"scrap"})
public class ScrapController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(ScrapController.class);
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "SCRAP";
    @Autowired
    private IScrapService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private IStoreManageApi storeManageApi;
    @Autowired
    private ScrapContentBpmServiceImpl impl;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ScrapVO> saveOrUpdate(@RequestBody ScrapVO saveOrUpdateVO) {
        ScrapEntity entity;
        OrgVO orgVO;
        CommonResponse orgResponse;
        if (CollectionUtils.isEmpty((Collection)saveOrUpdateVO.getDetailList())) {
            throw new BusinessException("\u5b50\u8868\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        ArrayList list = new ArrayList();
        saveOrUpdateVO.getDetailList().forEach(e -> {
            if (!"del".equals(e.getRowState())) {
                list.add(e);
            }
        });
        if (CollectionUtils.isEmpty(list)) {
            throw new BusinessException("\u5b50\u8868\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((CharSequence)saveOrUpdateVO.getParentOrgCode()) && saveOrUpdateVO.getParentOrgId() != null && (orgResponse = this.iOrgApi.getOneById(saveOrUpdateVO.getParentOrgId())).isSuccess()) {
            orgVO = (OrgVO)orgResponse.getData();
            saveOrUpdateVO.setParentOrgCode(orgVO.getCode());
        }
        if (StringUtils.isEmpty((CharSequence)saveOrUpdateVO.getOrgCode()) && saveOrUpdateVO.getOrgId() != null && (orgResponse = this.iOrgApi.getOneById(saveOrUpdateVO.getOrgId())).isSuccess()) {
            orgVO = (OrgVO)orgResponse.getData();
            saveOrUpdateVO.setOrgCode(orgVO.getCode());
        }
        if ((entity = (ScrapEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ScrapEntity.class))).getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        StoreManageVO storeManageVO = new StoreManageVO();
        storeManageVO.setStoreId(saveOrUpdateVO.getStoreId());
        storeManageVO.setSourceId(entity.getId());
        storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u9886\u6599\u51fa\u5e93);
        storeManageVO.setOutEffectiveON(Boolean.valueOf(false));
        ArrayList flowVOS = new ArrayList();
        saveOrUpdateVO.getDetailList().forEach(t -> {
            if ("del".equals(t.getRowState())) {
                FlowVO flowVO = StoreManageUtil.getFlowVO((InOutTypeEnum)InOutTypeEnum.\u9886\u6599\u51fa\u5e93, (Integer)0);
                flowVO.setStoreId(saveOrUpdateVO.getStoreId());
                flowVO.setStoreName(saveOrUpdateVO.getStoreName());
                flowVO.setProjectId(entity.getProjectId());
                flowVO.setProjectName(entity.getProjectName());
                flowVO.setOrgId(entity.getOrgId());
                flowVO.setOrgName(entity.getOrgName());
                flowVO.setParentOrgId(entity.getParentOrgId());
                flowVO.setParentOrgName(entity.getParentOrgName());
                flowVO.setEmployeeId(saveOrUpdateVO.getEmployeeId());
                flowVO.setEmployeeName(saveOrUpdateVO.getEmployeeName());
                flowVO.setMaterialCategoryId(t.getMaterialCategoryId());
                flowVO.setMaterialCategoryName(t.getMaterialCategoryName());
                flowVO.setMaterialId(t.getToolId());
                flowVO.setMaterialCode(t.getToolCode());
                flowVO.setMaterialName(t.getToolName());
                flowVO.setMaterialSpec(t.getSpecs());
                flowVO.setMaterialUnitId(t.getUnitId());
                flowVO.setMaterialUnitName(t.getUnit());
                flowVO.setSourceBillDetailRemark(t.getMemo());
                flowVO.setNum(t.getNum());
                flowVO.setSourceId(entity.getId());
                flowVO.setSourceDetailId(t.getId());
                flowVO.setSourceBillCode(entity.getBillCode());
                flowVO.setSourceBillDate(entity.getScrapDate());
                flowVO.setRowState(t.getRowState());
                flowVO.setSourceBillTypeCode("BT220215000000004");
                flowVO.setSourceBillTypeName("\u9886\u6599\u51fa\u5e93");
                flowVO.setSourceType(Integer.valueOf(1));
                flowVO.setSourceBillRemark(entity.getMemo());
                flowVOS.add(flowVO);
            }
        });
        entity.getDetailList().forEach(t -> {
            FlowVO flowVO = StoreManageUtil.getFlowVO((InOutTypeEnum)InOutTypeEnum.\u9886\u6599\u51fa\u5e93, (Integer)0);
            flowVO.setStoreId(saveOrUpdateVO.getStoreId());
            flowVO.setStoreName(saveOrUpdateVO.getStoreName());
            flowVO.setProjectId(entity.getProjectId());
            flowVO.setProjectName(entity.getProjectName());
            flowVO.setOrgId(entity.getOrgId());
            flowVO.setOrgName(entity.getOrgName());
            flowVO.setParentOrgId(entity.getParentOrgId());
            flowVO.setParentOrgName(entity.getParentOrgName());
            flowVO.setEmployeeId(saveOrUpdateVO.getEmployeeId());
            flowVO.setEmployeeName(saveOrUpdateVO.getEmployeeName());
            flowVO.setMaterialCategoryId(t.getMaterialCategoryId());
            flowVO.setMaterialCategoryName(t.getMaterialCategoryName());
            flowVO.setMaterialId(t.getToolId());
            flowVO.setMaterialCode(t.getToolName());
            flowVO.setMaterialName(t.getToolCode());
            flowVO.setMaterialSpec(t.getSpecs());
            flowVO.setMaterialUnitId(t.getUnitId());
            flowVO.setMaterialUnitName(t.getUnit());
            flowVO.setSourceBillDetailRemark(t.getMemo());
            flowVO.setNum(t.getNum());
            flowVO.setSourceId(entity.getId());
            flowVO.setSourceDetailId(t.getId());
            flowVO.setSourceBillCode(entity.getBillCode());
            flowVO.setSourceBillTypeCode("BT220215000000004");
            flowVO.setSourceBillTypeName("\u9886\u6599\u51fa\u5e93");
            flowVO.setSourceType(Integer.valueOf(1));
            flowVO.setSourceBillDate(entity.getScrapDate());
            flowVO.setRowState(t.getRowState());
            flowVO.setSourceBillRemark(entity.getMemo());
            flowVOS.add(flowVO);
        });
        storeManageVO.setFlowVOList(flowVOS);
        log.info("\u53c2\u6570\uff1a\u2014\u2014\u2014\u2014" + JSONObject.toJSONString((Object)storeManageVO));
        CommonResponse response = this.storeManageApi.inOutStore(storeManageVO);
        if (!response.isSuccess()) {
            throw new BusinessException("\u8c03\u7528\u5e93\u5b58\u7ba1\u7406\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\uff1a" + response.getMsg());
        }
        ScrapVO vo = (ScrapVO)BeanMapper.map((Object)((Object)entity), ScrapVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ScrapVO> queryDetail(Long id) {
        ScrapEntity entity = (ScrapEntity)((Object)this.service.selectById(id));
        ScrapVO vo = (ScrapVO)BeanMapper.map((Object)((Object)entity), ScrapVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ScrapVO> vos) {
        Collection list = this.service.listByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()));
        HashMap<Long, List> map = new HashMap<Long, List>();
        list.forEach(e -> {
            CommonResponse stringCommonResponse;
            if (map.containsKey(e.getStoreId())) {
                ((List)map.get(e.getStoreId())).add(e.getId());
            } else {
                ArrayList<Long> idList = new ArrayList<Long>();
                idList.add(e.getId());
                map.put(e.getStoreId(), idList);
            }
            if (e.getAttrFlag() != null && e.getAttrFlag() != 2 && !(stringCommonResponse = this.costDetailApi.deleteSubject(e.getId())).isSuccess()) {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        });
        map.forEach((key, value) -> {
            StoreManageVO storeManageVO = new StoreManageVO();
            storeManageVO.setStoreId(key);
            storeManageVO.setSourceIdsForRollBack(value);
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u9886\u6599\u51fa\u5e93);
            storeManageVO.setOutEffectiveON(Boolean.valueOf(false));
            CommonResponse response = this.storeManageApi.inOutStoreRollback(storeManageVO);
            if (!response.isSuccess()) {
                throw new BusinessException("\u8c03\u7528\u5e93\u5b58\u7ba1\u7406\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\uff1a" + response.getMsg());
            }
        });
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ScrapVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode", "projectName", "employeeName", "billName"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        Object orgVOList = null;
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ScrapVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode", "projectName", "employeeName", "billName"));
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List entityList = this.service.queryList(param);
        List list = BeanMapper.mapList((Iterable)entityList, ScrapVO.class);
        list.forEach(vo -> {
            BillStateEnum billStateEnum;
            Integer billState = vo.getBillState();
            if (billState != null && (billStateEnum = BillStateEnum.getEnumByStateCode((Integer)billState)) != null) {
                vo.setBillStateName(billStateEnum.getDescription());
            }
        });
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Scrap-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refScrapData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ScrapVO>> refScrapData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ScrapVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

