/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.rent.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.ac.enums.BillPushStatusEnum;
import com.ejianc.business.rent.bean.RentEquipmentStartEntity;
import com.ejianc.business.rent.bean.RentEquipmentStartSubEntity;
import com.ejianc.business.rent.bean.RentParameterDetailEntity;
import com.ejianc.business.rent.bean.RentParameterEntity;
import com.ejianc.business.rent.enums.EntranceRentFlagEnum;
import com.ejianc.business.rent.enums.RentEquipmentStateEnum;
import com.ejianc.business.rent.enums.RentParameterTypeEnum;
import com.ejianc.business.rent.service.IRentAcceptanceService;
import com.ejianc.business.rent.service.IRentEquipmentStartService;
import com.ejianc.business.rent.service.IRentParameterDetailService;
import com.ejianc.business.rent.service.IRentParameterService;
import com.ejianc.business.rent.service.IRentSettlementService;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IShareCooperateApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="rentEquipmentStart")
public class RentEquipmentStartBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IRentEquipmentStartService rentEquipmentStartService;
    @Autowired
    private IRentParameterService rentParameterService;
    @Autowired
    private IShareCooperateApi shareCooperateApi;
    @Autowired
    private IRentParameterDetailService rentParameterDetailService;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private IRentAcceptanceService rentAcceptanceService;
    @Autowired
    private IRentSettlementService rentSettlementService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_TYPE = "BT220221000000003";
    private static final String PUSH_SAVE_URL = "/ejc-supbusiness-web/openapi/equipmentStart/saveStart";
    private final String PUSH_DELETE_URL = "/ejc-supbusiness-web/openapi/equipmentStart/deleteStart";
    private final String OPERATE = "RENT-PROEQUIPMENT-START";

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        RentEquipmentStartEntity entity = (RentEquipmentStartEntity)((Object)this.rentEquipmentStartService.selectById(billId));
        if (BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus().equals(entity.getBillPushFlag())) {
            entity.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
            this.rentEquipmentStartService.saveOrUpdate((Object)entity, false);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        RentEquipmentStartEntity startEntity = (RentEquipmentStartEntity)((Object)this.rentEquipmentStartService.selectById(billId));
        Boolean entranceRentFlag = false;
        if (EntranceRentFlagEnum.\u662f.getCode().equals(startEntity.getEntranceRentFlag())) {
            entranceRentFlag = true;
        }
        List<RentEquipmentStartSubEntity> subEntityList = startEntity.getRentEquipmentStartSubList();
        ArrayList<RentParameterEntity> parameterList = new ArrayList<RentParameterEntity>();
        for (RentEquipmentStartSubEntity subEntity : subEntityList) {
            RentParameterEntity parameterEntity = new RentParameterEntity();
            parameterEntity.setId(subEntity.getSourceId());
            parameterEntity.setStartDate(subEntity.getTypeDate());
            parameterEntity.setOperationDate(new Date());
            parameterEntity.setEquipmentState(RentEquipmentStateEnum.\u542f\u7528.getCode());
            if (!entranceRentFlag.booleanValue()) {
                ArrayList<RentParameterDetailEntity> parameterDetailList = new ArrayList<RentParameterDetailEntity>();
                RentParameterDetailEntity detailEntity = new RentParameterDetailEntity();
                detailEntity.setSourceType(RentParameterTypeEnum.\u542f\u7528\u5355.getCode());
                detailEntity.setSourceId(startEntity.getId());
                detailEntity.setOperationDate(subEntity.getTypeDate());
                detailEntity.setEquipmentState(RentEquipmentStateEnum.\u542f\u7528.getCode());
                detailEntity.setParameterId(subEntity.getSourceId());
                parameterDetailList.add(detailEntity);
                parameterEntity.setRentParameterDetailList(parameterDetailList);
            } else {
                parameterEntity.setMeterRentDate(subEntity.getTypeDate());
                parameterEntity.setOperationDate(new Date());
                parameterEntity.setStartDate(new Date());
            }
            parameterList.add(parameterEntity);
        }
        if (entranceRentFlag.booleanValue()) {
            List parameterIdList = subEntityList.stream().map(RentEquipmentStartSubEntity::getSourceId).collect(Collectors.toList());
            Map<Long, Date> startSubDateMap = subEntityList.stream().collect(Collectors.toMap(RentEquipmentStartSubEntity::getSourceId, RentEquipmentStartSubEntity::getTypeDate, (key1, key2) -> key2));
            this.logger.info("\u83b7\u53d6\u8bbe\u5907\u5b50\u8868\u96c6\u5408\uff1a{}", (Object)JSONObject.toJSONString(startSubDateMap));
            this.logger.info("\u83b7\u53d6\u53f0\u8d26\u8bbe\u5907id\u96c6\u5408\uff1a{}", (Object)JSONObject.toJSONString(parameterIdList));
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("parameterId", new Parameter("in", parameterIdList));
            List detailEntityList = this.rentParameterDetailService.queryList(queryParam);
            this.logger.info("\u83b7\u53d6\u53f0\u8d26\u8bbe\u5907\u5b50\u8868\u96c6\u5408\uff1a{}", (Object)JSONObject.toJSONString((Object)detailEntityList));
            if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)detailEntityList)) {
                for (RentParameterDetailEntity detailEntity : detailEntityList) {
                    if (!startSubDateMap.containsKey(detailEntity.getParameterId())) continue;
                    detailEntity.setOperationDate(startSubDateMap.get(detailEntity.getParameterId()));
                }
            }
            this.rentParameterDetailService.saveOrUpdateBatch(detailEntityList, detailEntityList.size(), false);
        }
        this.logger.info("\u63a8\u9001\u53f0\u8d26\u6570\u636eparameterList\uff1a{}", (Object)JSONObject.toJSONString(parameterList));
        this.rentParameterService.changeParameter(parameterList, RentParameterTypeEnum.\u542f\u7528\u5355.getCode());
        this.rentEquipmentStartService.updateById((Object)startEntity);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        RentEquipmentStartEntity startEntity = (RentEquipmentStartEntity)((Object)this.rentEquipmentStartService.selectById(billId));
        if (startEntity.getRentType().equals("1")) {
            return CommonResponse.error((String)"\u5185\u79df\u5408\u540c\u4e0d\u652f\u6301\u64a4\u56de");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        RentEquipmentStartEntity startEntity = (RentEquipmentStartEntity)((Object)this.rentEquipmentStartService.selectById(billId));
        QueryParam settlementQueryParam = new QueryParam();
        settlementQueryParam.getParams().put("contract_id", new Parameter("eq", (Object)startEntity.getContractId()));
        settlementQueryParam.getParams().put("settlement_date", new Parameter("gt", (Object)startEntity.getTypeDate()));
        List outRentSettlementEntityList = this.rentSettlementService.queryList(settlementQueryParam);
        if (CollectionUtils.isNotEmpty((Collection)outRentSettlementEntityList)) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u7684\u8bbe\u5907\uff0c\u5df2\u88ab\u4e0b\u6e38\u7ed3\u7b97\u5355\u5f15\u7528\uff0c\u4e0d\u80fd\u64a4\u56de\uff01");
        }
        List<RentEquipmentStartSubEntity> outRentEquipmentStartSubEntityList = startEntity.getRentEquipmentStartSubList();
        List<Long> outRentParameterIds = outRentEquipmentStartSubEntityList.stream().map(RentEquipmentStartSubEntity::getSourceId).collect(Collectors.toList());
        this.logger.info("\u63a8\u9001\u53f0\u8d26\u6570\u636eparameterIdList\uff1a{}", (Object)JSONObject.toJSONString(outRentParameterIds));
        QueryParam param = new QueryParam();
        param.getParams().put("parameter_id", new Parameter("in", outRentParameterIds));
        param.getOrderMap().put("create_time", "desc");
        List outRentParameterDetailEntityList = this.rentParameterDetailService.queryList(param);
        this.logger.info("\u67e5\u8be2\u53f0\u8d26\u5b50\u8868\u6570\u636eoutRentParameterDetailEntityList\uff1a{}", (Object)JSONObject.toJSONString((Object)outRentParameterDetailEntityList));
        this.logger.info("entity.getId()\uff1a{}\uff0cbillId\uff1a{}\uff0csourceId\uff1a{}\uff0centity\uff1a{}", new Object[]{startEntity.getId(), billId, ((RentParameterDetailEntity)((Object)outRentParameterDetailEntityList.get(0))).getSourceId(), JSONObject.toJSONString((Object)((Object)startEntity))});
        if (EntranceRentFlagEnum.\u5426.getCode().equals(startEntity.getEntranceRentFlag()) ? CollectionUtils.isNotEmpty((Collection)outRentParameterDetailEntityList) && !startEntity.getId().equals(((RentParameterDetailEntity)((Object)outRentParameterDetailEntityList.get(0))).getSourceId()) : CollectionUtils.isNotEmpty((Collection)outRentParameterDetailEntityList) && !RentEquipmentStateEnum.\u542f\u7528.getCode().equals(((RentParameterDetailEntity)((Object)outRentParameterDetailEntityList.get(0))).getEquipmentState())) {
            return CommonResponse.error((String)("\u5f53\u524d\u5355\u636e\u7684\u8bbe\u5907\uff0c\u5df2\u88ab\u4e0b\u6e38\u5355\u636e" + RentParameterTypeEnum.getEnumByCode(((RentParameterDetailEntity)((Object)outRentParameterDetailEntityList.get(0))).getSourceType()).getDescription() + "\u5f15\u7528\uff0c\u4e0d\u80fd\u64a4\u56de\uff01"));
        }
        if (EntranceRentFlagEnum.\u662f.getCode().equals(startEntity.getEntranceRentFlag())) {
            UpdateWrapper updateWrapper = new UpdateWrapper();
            updateWrapper.in((Object)"id", outRentParameterIds);
            updateWrapper.set((Object)"meter_rent_date", null);
            updateWrapper.set((Object)"start_date", null);
            updateWrapper.set((Object)"operation_date", (Object)new Date());
            updateWrapper.set((Object)"equipment_state", (Object)RentEquipmentStateEnum.\u5f85\u542f\u7528.getCode());
            this.rentParameterService.update((Wrapper)updateWrapper);
            UpdateWrapper detailUpdateWrapper = new UpdateWrapper();
            detailUpdateWrapper.in((Object)"parameter_id", outRentParameterIds);
            detailUpdateWrapper.set((Object)"operation_date", null);
            this.rentParameterDetailService.update((Wrapper)detailUpdateWrapper);
        } else {
            this.rentParameterService.cancelParameter(outRentParameterIds, RentParameterTypeEnum.\u542f\u7528\u5355.getCode(), startEntity.getId());
        }
        startEntity.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
        this.rentEquipmentStartService.saveOrUpdate((Object)startEntity, false);
        return CommonResponse.success();
    }
}

