package com.ejianc.business.asset.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * 固定资产摊销设置
 * 
 * @author generator
 * 
 */
@ApiModel("固定资产摊销设置")
public class AmortizeSetVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("组织")
    private Long orgId;
    @ApiModelProperty("组织编码")
    private String orgCode;
    @ApiModelProperty("组织名称")
    private String orgName;
    @ApiModelProperty("材料分类id")
    private Long equipmentTypeId;
    @ApiModelProperty("材料分类编码")
    private String equipmentTypeCode;
    @ApiModelProperty("材料分类名称")
    private String equipmentTypeName;
    @ApiModelProperty("内码")
    private String innerCode;
    @ApiModelProperty("材料id")
    private Long equipmentId;
    @ApiModelProperty("材料编码")
    private String equipmentCode;
    @ApiModelProperty("材料名称")
    private String equipmentName;
    @ApiModelProperty("规格型号")
    private String spec;
    @ApiModelProperty("计量单位id")
    private Long unitId;
    @ApiModelProperty("计量单位")
    private String unit;
    @ApiModelProperty("类型标志1-分类，2-材料")
    private Integer typeFlag;
    @ApiModelProperty("使用年限（月）")
    private Integer usePeriod;
    @ApiModelProperty("残值率")
    private BigDecimal residualValueRate;
    @ApiModelProperty("管控范围,0-本下")
    private Integer controlScope;
    @ApiModelProperty("状态0-停用，1-启用")
    private Integer enabled;
    @ApiModelProperty("编制人")
    private Long employeeId;
    @ApiModelProperty("编制人名称")
    private String employeeName;
    

    /**
     * 组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织编码
     */
    public String getOrgCode() {
        return orgCode;
    }

    /**
     * 组织编码
     */
    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 材料分类id
     */
    public Long getEquipmentTypeId() {
        return equipmentTypeId;
    }

    /**
     * 材料分类id
     */
    public void setEquipmentTypeId(Long equipmentTypeId) {
        this.equipmentTypeId = equipmentTypeId;
    }
    /**
     * 材料分类编码
     */
    public String getEquipmentTypeCode() {
        return equipmentTypeCode;
    }

    /**
     * 材料分类编码
     */
    public void setEquipmentTypeCode(String equipmentTypeCode) {
        this.equipmentTypeCode = equipmentTypeCode;
    }
    /**
     * 材料分类名称
     */
    public String getEquipmentTypeName() {
        return equipmentTypeName;
    }

    /**
     * 材料分类名称
     */
    public void setEquipmentTypeName(String equipmentTypeName) {
        this.equipmentTypeName = equipmentTypeName;
    }
    /**
     * 内码
     */
    public String getInnerCode() {
        return innerCode;
    }

    /**
     * 内码
     */
    public void setInnerCode(String innerCode) {
        this.innerCode = innerCode;
    }
    /**
     * 材料id
     */
    public Long getEquipmentId() {
        return equipmentId;
    }

    /**
     * 材料id
     */
    public void setEquipmentId(Long equipmentId) {
        this.equipmentId = equipmentId;
    }
    /**
     * 材料编码
     */
    public String getEquipmentCode() {
        return equipmentCode;
    }

    /**
     * 材料编码
     */
    public void setEquipmentCode(String equipmentCode) {
        this.equipmentCode = equipmentCode;
    }
    /**
     * 材料名称
     */
    public String getEquipmentName() {
        return equipmentName;
    }

    /**
     * 材料名称
     */
    public void setEquipmentName(String equipmentName) {
        this.equipmentName = equipmentName;
    }
    /**
     * 规格型号
     */
    public String getSpec() {
        return spec;
    }

    /**
     * 规格型号
     */
    public void setSpec(String spec) {
        this.spec = spec;
    }
    /**
     * 计量单位id
     */
    public Long getUnitId() {
        return unitId;
    }

    /**
     * 计量单位id
     */
    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    /**
     * 计量单位
     */
    public String getUnit() {
        return unit;
    }

    /**
     * 计量单位
     */
    public void setUnit(String unit) {
        this.unit = unit;
    }
    /**
     * 类型标志1-分类，2-材料
     */
    public Integer getTypeFlag() {
        return typeFlag;
    }

    /**
     * 类型标志1-分类，2-材料
     */
    public void setTypeFlag(Integer typeFlag) {
        this.typeFlag = typeFlag;
    }
    /**
     * 使用年限（月）
     */
    public Integer getUsePeriod() {
        return usePeriod;
    }

    /**
     * 使用年限（月）
     */
    public void setUsePeriod(Integer usePeriod) {
        this.usePeriod = usePeriod;
    }
    /**
     * 残值率
     */
    public BigDecimal getResidualValueRate() {
        return residualValueRate;
    }

    /**
     * 残值率
     */
    public void setResidualValueRate(BigDecimal residualValueRate) {
        this.residualValueRate = residualValueRate;
    }
    /**
     * 管控范围,0-本下
     */
    public Integer getControlScope() {
        return controlScope;
    }

    /**
     * 管控范围,0-本下
     */
    public void setControlScope(Integer controlScope) {
        this.controlScope = controlScope;
    }
    /**
     * 状态0-停用，1-启用
     */
    public Integer getEnabled() {
        return enabled;
    }

    /**
     * 状态0-停用，1-启用
     */
    public void setEnabled(Integer enabled) {
        this.enabled = enabled;
    }
    /**
     * 编制人
     */
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 编制人
     */
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 编制人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 编制人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    
}
