package com.ejianc.business.asset.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.business.consts.AssetRecordTypeEnum;
import com.ejianc.business.decorator.IAssetRecord;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 *  固定资产
 * 
 * @author generator
 * 
 */
@ApiModel(" 固定资产")
public class AssetVO extends BaseVO implements IAssetRecord {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("单据编码")
    private String billCode;
    @ApiModelProperty("材料分类id")
    private Long equipmentTypeId;
    @ApiModelProperty("材料分类编码")
    private String equipmentTypeCode;
    @ApiModelProperty("材料分类名称")
    private String equipmentTypeName;
    @ApiModelProperty("材料id")
    private Long equipmentId;
    @ApiModelProperty("材料编码")
    private String equipmentCode;
    @ApiModelProperty("材料名称")
    private String equipmentName;
    @ApiModelProperty("是否推送财务1推送0不推送")
    private Integer financePushFlag;
    @ApiModelProperty("财务推送状态1已推送0未推送")
    private Integer financePushState;
    @ApiModelProperty("财务资产分类id")
    private String financeTypeId;
    @ApiModelProperty("财务资产id")
    private String financeAssetId;
    @ApiModelProperty("财务资产编码")
    private String financeAssetCode;
    @ApiModelProperty("设备状态 1:再用 2:处置")
    private Integer equipmentStatus;
    @ApiModelProperty("资产状态 1:报废 2:处置")
    private Integer assetStatus; // 资产状态 0：正常 1:报废 2:处置
    @ApiModelProperty("资产类型 1:固定资产 2:普通资产")
    private Integer assetType;
    @ApiModelProperty("验收日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date checkDate;
    @ApiModelProperty("项目id")
    private Long projectId;
    @ApiModelProperty("项目名称")
    private String projectName;
    @ApiModelProperty("所属项目部Id")
    private Long orgId;
    @ApiModelProperty("所属项目部名称")
    private String orgName;
    @ApiModelProperty("项目组织编码")
    private String orgCode;
    @ApiModelProperty("单据状态")
    private Integer billState;
    @ApiModelProperty("项目部上级组织id")
    private Long parentOrgId;
    @ApiModelProperty("项目部上级组织名称")
    private String parentOrgName;
    @ApiModelProperty("项目部上级组织编码")
    private String parentOrgCode;
    @ApiModelProperty("编制人id")
    private Long employeeId; // 编制人
    @ApiModelProperty("编制人名称")
    private String employeeName; // 编制人名称
    @ApiModelProperty("经办人部门id")
    private Long departmentId; // 经办人部门id
    @ApiModelProperty("经办人部门")
    private String departmentName; // 经办人部门
    @ApiModelProperty("规格型号")
    private String spec;
    @ApiModelProperty("计量单位id")
    private Long unitId;
    @ApiModelProperty("计量单位")
    private String unit;
    @ApiModelProperty("来源 1：验收 2：期初 3：调拨")
    private Integer sourceType;
    @ApiModelProperty("摊销方式")
    private Integer amortizeType;
    @ApiModelProperty("产权单位id")
    private Long propertyRightCompanyId;
    @ApiModelProperty("产权单位")
    private String propertyRightCompany;
    @ApiModelProperty("管理单位")
    private String manageCompany;
    @ApiModelProperty("管理单位id")
    private Long manageCompanyId;
    @ApiModelProperty("原值(无税)")
    private BigDecimal originalValue;
    @ApiModelProperty("原值(含税)")
    private BigDecimal originalValueTax;
    @ApiModelProperty("净值(无税)")
    private BigDecimal netWorth;
    @ApiModelProperty("净值(含税)")
    private BigDecimal netWorthTax;
    @ApiModelProperty("残值(含税)")
    private BigDecimal residualValueTax;
    @ApiModelProperty("残值(无税)")
    private BigDecimal residualValue;
    @ApiModelProperty("累计摊销金额(无税)")
    private BigDecimal lastAmortizeMny;
    @ApiModelProperty("累计摊销金额(含税)")
    private BigDecimal lastAmortizeTaxMny;
    @ApiModelProperty("处置金额(无税)")
    private BigDecimal handleMny;
    @ApiModelProperty("处置金额(含税)")
    private BigDecimal handleTaxMny;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("生产厂家")
    private String manufacturer;
    @ApiModelProperty("合格证号")
    private String certificateNum;
    @ApiModelProperty("生产日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date productionDate;
    @ApiModelProperty("出厂编号")
    private String leaveFactoryCode;
    @ApiModelProperty("随机工具")
    private String randomTool;
    @ApiModelProperty("能力")
    private String ability;
    @ApiModelProperty("重量（t）")
    private BigDecimal weight;
    @ApiModelProperty("动力（kw）")
    private BigDecimal power;
    @ApiModelProperty("自重（t）")
    private BigDecimal ownWeight;
    @ApiModelProperty("外形尺寸（毫米）")
    private BigDecimal appearanceSize;
    @ApiModelProperty("型号说明")
    private String modelExplain;
    @ApiModelProperty("供应商")
    private String supplierName;
    @ApiModelProperty("供应商id")
    private Long supplierId;
    @ApiModelProperty("上次摊销周期")
    @JsonFormat(pattern = "yyyy-MM", timezone = "GMT+8")
    private Date lastAmortizeDate; // 上次摊销周期
    @ApiModelProperty("残值率")
    private BigDecimal residualValueRate;
    @ApiModelProperty("税率")
    private BigDecimal taxRate; // 税率
    private BigDecimal estimateAmortizeMny; // 预估摊销金额


    @ApiModelProperty("设备流转记录")
    private List<AssetRecordVO> assetRecordList = new ArrayList<>();

    @ApiModelProperty("已生效摊销周期数")
    private Integer usedAmortizeNum;

    @ApiModelProperty("来源名称")
    private String sourceTypeName;
    @ApiModelProperty("资产类型名称")
    private String assetTypeName;
    @ApiModelProperty("设备状态名称")
    private String equipmentStatusName;
    @ApiModelProperty("推送状态名称")
    private String financePushStateName;
    @ApiModelProperty("资产状态名称")
    private String assetStatusName;
    @ApiModelProperty("验收id")
    private Long purchaseAcceptanceId;

    @ApiModelProperty("设备类型:0-计量测量设备,1-施工设备,2-运输设备,3-其他")
    private String equipType;
    @ApiModelProperty("计量单位")
    private String equipUnitName;
    @ApiModelProperty("物品品牌")
    private String itemBrand;
    @ApiModelProperty("排量")
    private String displacement;
    @ApiModelProperty("购货日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date purchaseDate;

    public String getEquipType() {
        return equipType;
    }

    public void setEquipType(String equipType) {
        this.equipType = equipType;
    }

    public String getEquipUnitName() {
        return equipUnitName;
    }

    public void setEquipUnitName(String equipUnitName) {
        this.equipUnitName = equipUnitName;
    }

    public String getItemBrand() {
        return itemBrand;
    }

    public void setItemBrand(String itemBrand) {
        this.itemBrand = itemBrand;
    }

    public String getDisplacement() {
        return displacement;
    }

    public void setDisplacement(String displacement) {
        this.displacement = displacement;
    }

    public Date getPurchaseDate() {
        return purchaseDate;
    }

    public void setPurchaseDate(Date purchaseDate) {
        this.purchaseDate = purchaseDate;
    }

    public Integer getUsedAmortizeNum() {
        return usedAmortizeNum;
    }

    public void setUsedAmortizeNum(Integer usedAmortizeNum) {
        this.usedAmortizeNum = usedAmortizeNum;
    }

    public BigDecimal getEstimateAmortizeMny() {
        return estimateAmortizeMny;
    }

    public void setEstimateAmortizeMny(BigDecimal estimateAmortizeMny) {
        this.estimateAmortizeMny = estimateAmortizeMny;
    }
    /**
     * 单据编码
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编码
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 材料分类id
     */
    public Long getEquipmentTypeId() {
        return equipmentTypeId;
    }

    /**
     * 材料分类id
     */
    public void setEquipmentTypeId(Long equipmentTypeId) {
        this.equipmentTypeId = equipmentTypeId;
    }
    /**
     * 材料分类编码
     */
    public String getEquipmentTypeCode() {
        return equipmentTypeCode;
    }

    /**
     * 材料分类编码
     */
    public void setEquipmentTypeCode(String equipmentTypeCode) {
        this.equipmentTypeCode = equipmentTypeCode;
    }
    /**
     * 材料分类名称
     */
    public String getEquipmentTypeName() {
        return equipmentTypeName;
    }

    /**
     * 材料分类名称
     */
    public void setEquipmentTypeName(String equipmentTypeName) {
        this.equipmentTypeName = equipmentTypeName;
    }
    /**
     * 材料id
     */
    @ReferSerialTransfer(referCode = "Material001")
    public Long getEquipmentId() {
        return equipmentId;
    }

    /**
     * 材料id
     */
    @ReferDeserialTransfer
    public void setEquipmentId(Long equipmentId) {
        this.equipmentId = equipmentId;
    }
    /**
     * 材料编码
     */
    public String getEquipmentCode() {
        return equipmentCode;
    }

    /**
     * 材料编码
     */
    public void setEquipmentCode(String equipmentCode) {
        this.equipmentCode = equipmentCode;
    }
    /**
     * 材料名称
     */
    public String getEquipmentName() {
        return equipmentName;
    }

    /**
     * 材料名称
     */
    public void setEquipmentName(String equipmentName) {
        this.equipmentName = equipmentName;
    }
    /**
     * 是否推送财务1推送0不推送
     */
    public Integer getFinancePushFlag() {
        return financePushFlag;
    }

    /**
     * 是否推送财务1推送0不推送
     */
    public void setFinancePushFlag(Integer financePushFlag) {
        this.financePushFlag = financePushFlag;
    }
    /**
     * 财务推送状态1已推送0未推送
     */
    public Integer getFinancePushState() {
        return financePushState;
    }

    /**
     * 财务推送状态1已推送0未推送
     */
    public void setFinancePushState(Integer financePushState) {
        this.financePushState = financePushState;
    }
    /**
     * 财务资产分类id
     */
    public String getFinanceTypeId() {
        return financeTypeId;
    }

    /**
     * 财务资产分类id
     */
    public void setFinanceTypeId(String financeTypeId) {
        this.financeTypeId = financeTypeId;
    }
    /**
     * 财务资产id
     */
    public String getFinanceAssetId() {
        return financeAssetId;
    }

    /**
     * 财务资产id
     */
    public void setFinanceAssetId(String financeAssetId) {
        this.financeAssetId = financeAssetId;
    }
    /**
     * 财务资产编码
     */
    public String getFinanceAssetCode() {
        return financeAssetCode;
    }

    /**
     * 财务资产编码
     */
    public void setFinanceAssetCode(String financeAssetCode) {
        this.financeAssetCode = financeAssetCode;
    }
    /**
     * 设备状态 1:再用 2:处置
     */
    public Integer getEquipmentStatus() {
        return equipmentStatus;
    }

    /**
     * 设备状态 1:再用 2:处置
     */
    public void setEquipmentStatus(Integer equipmentStatus) {
        this.equipmentStatus = equipmentStatus;
    }

    public Integer getAssetStatus() {
        return assetStatus;
    }

    public void setAssetStatus(Integer assetStatus) {
        this.assetStatus = assetStatus;
    }

    /**
     * 资产类型 1:固定资产 2:普通资产
     */
    public Integer getAssetType() {
        return assetType;
    }

    /**
     * 资产类型 1:固定资产 2:普通资产
     */
    public void setAssetType(Integer assetType) {
        this.assetType = assetType;
    }
    /**
     * 验收日期
     */
    public Date getCheckDate() {
        return checkDate;
    }

    /**
     * 验收日期
     */
    public void setCheckDate(Date checkDate) {
        this.checkDate = checkDate;
    }
    /**
     * 项目id
     */
    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目id
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 所属项目部Id
     */
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 所属项目部Id
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 所属项目部名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 所属项目部名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目组织编码
     */
    public String getOrgCode() {
        return orgCode;
    }

    /**
     * 项目组织编码
     */
    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 项目部上级组织id
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 项目部上级组织id
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 项目部上级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 项目部上级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 项目部上级组织编码
     */
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    /**
     * 项目部上级组织编码
     */
    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }

    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    /**
     * 规格型号
     */
    public String getSpec() {
        return spec;
    }

    /**
     * 规格型号
     */
    public void setSpec(String spec) {
        this.spec = spec;
    }
    /**
     * 计量单位id
     */
    public Long getUnitId() {
        return unitId;
    }

    /**
     * 计量单位id
     */
    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    /**
     * 计量单位
     */
    public String getUnit() {
        return unit;
    }

    /**
     * 计量单位
     */
    public void setUnit(String unit) {
        this.unit = unit;
    }
    /**
     * 来源 1：验收 2：期初 3：调拨
     */
    public Integer getSourceType() {
        return sourceType;
    }

    /**
     * 来源 1：验收 2：期初 3：调拨
     */
    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }
    /**
     * 摊销方式
     */
    public Integer getAmortizeType() {
        return amortizeType;
    }
    /**
     * 摊销方式
     */
    public void setAmortizeType(Integer amortizeType) {
        this.amortizeType = amortizeType;
    }

    /**
     * 产权单位id
     */
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getPropertyRightCompanyId() {
        return propertyRightCompanyId;
    }

    /**
     * 产权单位id
     */
    @ReferDeserialTransfer
    public void setPropertyRightCompanyId(Long propertyRightCompanyId) {
        this.propertyRightCompanyId = propertyRightCompanyId;
    }
    /**
     * 产权单位
     */
    public String getPropertyRightCompany() {
        return propertyRightCompany;
    }

    /**
     * 产权单位
     */
    public void setPropertyRightCompany(String propertyRightCompany) {
        this.propertyRightCompany = propertyRightCompany;
    }
    /**
     * 管理单位
     */
    public String getManageCompany() {
        return manageCompany;
    }

    /**
     * 管理单位
     */
    public void setManageCompany(String manageCompany) {
        this.manageCompany = manageCompany;
    }
    /**
     * 管理单位id
     */
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getManageCompanyId() {
        return manageCompanyId;
    }

    /**
     * 管理单位id
     */
    @ReferDeserialTransfer
    public void setManageCompanyId(Long manageCompanyId) {
        this.manageCompanyId = manageCompanyId;
    }
    /**
     * 原值(无税)
     */
    public BigDecimal getOriginalValue() {
        return originalValue;
    }

    /**
     * 原值(无税)
     */
    public void setOriginalValue(BigDecimal originalValue) {
        this.originalValue = originalValue;
    }
    /**
     * 原值(含税)
     */
    public BigDecimal getOriginalValueTax() {
        return originalValueTax;
    }

    /**
     * 原值(含税)
     */
    public void setOriginalValueTax(BigDecimal originalValueTax) {
        this.originalValueTax = originalValueTax;
    }
    /**
     * 净值(无税)
     */
    public BigDecimal getNetWorth() {
        return netWorth;
    }

    /**
     * 净值(无税)
     */
    public void setNetWorth(BigDecimal netWorth) {
        this.netWorth = netWorth;
    }
    /**
     * 净值(含税)
     */
    public BigDecimal getNetWorthTax() {
        return netWorthTax;
    }

    /**
     * 净值(含税)
     */
    public void setNetWorthTax(BigDecimal netWorthTax) {
        this.netWorthTax = netWorthTax;
    }
    /**
     * 残值(含税)
     */
    public BigDecimal getResidualValueTax() {
        return residualValueTax;
    }

    /**
     * 残值(含税)
     */
    public void setResidualValueTax(BigDecimal residualValueTax) {
        this.residualValueTax = residualValueTax;
    }
    /**
     * 残值(无税)
     */
    public BigDecimal getResidualValue() {
        return residualValue;
    }

    /**
     * 残值(无税)
     */
    public void setResidualValue(BigDecimal residualValue) {
        this.residualValue = residualValue;
    }
    /**
     * 累计摊销金额(无税)
     */
    public BigDecimal getLastAmortizeMny() {
        return lastAmortizeMny;
    }

    /**
     * 累计摊销金额(无税)
     */
    public void setLastAmortizeMny(BigDecimal lastAmortizeMny) {
        this.lastAmortizeMny = lastAmortizeMny;
    }
    /**
     * 累计摊销金额(含税)
     */
    public BigDecimal getLastAmortizeTaxMny() {
        return lastAmortizeTaxMny;
    }

    /**
     * 累计摊销金额(含税)
     */
    public void setLastAmortizeTaxMny(BigDecimal lastAmortizeTaxMny) {
        this.lastAmortizeTaxMny = lastAmortizeTaxMny;
    }
    /**
     * 处置金额(无税)
     */
    public BigDecimal getHandleMny() {
        return handleMny;
    }

    /**
     * 处置金额(无税)
     */
    public void setHandleMny(BigDecimal handleMny) {
        this.handleMny = handleMny;
    }
    /**
     * 处置金额(含税)
     */
    public BigDecimal getHandleTaxMny() {
        return handleTaxMny;
    }

    /**
     * 处置金额(含税)
     */
    public void setHandleTaxMny(BigDecimal handleTaxMny) {
        this.handleTaxMny = handleTaxMny;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 生产厂家
     */
    public String getManufacturer() {
        return manufacturer;
    }

    /**
     * 生产厂家
     */
    public void setManufacturer(String manufacturer) {
        this.manufacturer = manufacturer;
    }
    /**
     * 合格证号
     */
    public String getCertificateNum() {
        return certificateNum;
    }

    /**
     * 合格证号
     */
    public void setCertificateNum(String certificateNum) {
        this.certificateNum = certificateNum;
    }
    /**
     * 生产日期
     */
    public Date getProductionDate() {
        return productionDate;
    }

    /**
     * 生产日期
     */
    public void setProductionDate(Date productionDate) {
        this.productionDate = productionDate;
    }
    /**
     * 出厂编号
     */
    public String getLeaveFactoryCode() {
        return leaveFactoryCode;
    }

    /**
     * 出厂编号
     */
    public void setLeaveFactoryCode(String leaveFactoryCode) {
        this.leaveFactoryCode = leaveFactoryCode;
    }
    /**
     * 随机工具
     */
    public String getRandomTool() {
        return randomTool;
    }

    /**
     * 随机工具
     */
    public void setRandomTool(String randomTool) {
        this.randomTool = randomTool;
    }
    /**
     * 能力
     */
    public String getAbility() {
        return ability;
    }

    /**
     * 能力
     */
    public void setAbility(String ability) {
        this.ability = ability;
    }
    /**
     * 重量（t）
     */
    public BigDecimal getWeight() {
        return weight;
    }

    /**
     * 重量（t）
     */
    public void setWeight(BigDecimal weight) {
        this.weight = weight;
    }
    /**
     * 动力（kw）
     */
    public BigDecimal getPower() {
        return power;
    }

    /**
     * 动力（kw）
     */
    public void setPower(BigDecimal power) {
        this.power = power;
    }
    /**
     * 自重（t）
     */
    public BigDecimal getOwnWeight() {
        return ownWeight;
    }

    /**
     * 自重（t）
     */
    public void setOwnWeight(BigDecimal ownWeight) {
        this.ownWeight = ownWeight;
    }
    /**
     * 外形尺寸（毫米）
     */
    public BigDecimal getAppearanceSize() {
        return appearanceSize;
    }

    /**
     * 外形尺寸（毫米）
     */
    public void setAppearanceSize(BigDecimal appearanceSize) {
        this.appearanceSize = appearanceSize;
    }
    /**
     * 型号说明
     */
    public String getModelExplain() {
        return modelExplain;
    }

    /**
     * 型号说明
     */
    public void setModelExplain(String modelExplain) {
        this.modelExplain = modelExplain;
    }
    /**
     * 供应商
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 供应商
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 供应商id
     */
    @ReferSerialTransfer(referCode = "support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }

    /**
     * 供应商id
     */
    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }


    /**
     * 残值率
     */
    public BigDecimal getResidualValueRate() {
        return residualValueRate;
    }

    /**
     * 残值率
     */
    public void setResidualValueRate(BigDecimal residualValueRate) {
        this.residualValueRate = residualValueRate;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public Date getLastAmortizeDate() {
        return lastAmortizeDate;
    }

    public void setLastAmortizeDate(Date lastAmortizeDate) {
        this.lastAmortizeDate = lastAmortizeDate;
    }

    public List<AssetRecordVO> getAssetRecordList() {
        return assetRecordList;
    }

    public void setAssetRecordList(List<AssetRecordVO> assetRecordList) {
        this.assetRecordList = assetRecordList;
    }

    public String getSourceTypeName() {
        return sourceTypeName;
    }

    public void setSourceTypeName(String sourceTypeName) {
        this.sourceTypeName = sourceTypeName;
    }

    public String getAssetTypeName() {
        return assetTypeName;
    }

    public void setAssetTypeName(String assetTypeName) {
        this.assetTypeName = assetTypeName;
    }

    public String getEquipmentStatusName() {
        return equipmentStatusName;
    }

    public void setEquipmentStatusName(String equipmentStatusName) {
        this.equipmentStatusName = equipmentStatusName;
    }

    public String getFinancePushStateName() {
        return financePushStateName;
    }

    public void setFinancePushStateName(String financePushStateName) {
        this.financePushStateName = financePushStateName;
    }

    public String getAssetStatusName() {
        return assetStatusName;
    }

    public void setAssetStatusName(String assetStatusName) {
        this.assetStatusName = assetStatusName;
    }

    @ReferSerialTransfer(referCode = "equipmentp-accept")
    public Long getPurchaseAcceptanceId() {
        return purchaseAcceptanceId;
    }

    @ReferDeserialTransfer
    public void setPurchaseAcceptanceId(Long purchaseAcceptanceId) {
        this.purchaseAcceptanceId = purchaseAcceptanceId;
    }

    @Override
    public List<AssetRecordVO> toRecordList() {
        ArrayList<AssetRecordVO> assetRecordVOS = new ArrayList<>();
        AssetRecordVO recordVO = BeanMapper.map(this, AssetRecordVO.class);
        recordVO.setId(null);
        recordVO.setVersion(null);
        recordVO.setBillDate(new Date());
        recordVO.setSourceBillCode(this.getBillCode());
        recordVO.setAssetId(this.getId());
        recordVO.setAssetCode(this.getBillCode());
        //没有子表设置 子表id 设置为空
        recordVO.setSourceDetailId(null);
        if (this.getSourceType().equals(1)){
            recordVO.setSourceId(this.getPurchaseAcceptanceId());
            recordVO.setSourceType(AssetRecordTypeEnum.验收.getCode());
            recordVO.setSourceTypeName(AssetRecordTypeEnum.验收.getName());
        }
        if (this.getSourceType().equals(2)){
            recordVO.setSourceId(this.getId());
            recordVO.setSourceType(AssetRecordTypeEnum.新增.getCode());
            recordVO.setSourceTypeName(AssetRecordTypeEnum.新增.getName());
        }
        assetRecordVOS.add(recordVO);
        return assetRecordVOS;
    }
}
