package com.ejianc.business.asset.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * 固定资产报废明细表
 * 
 * @author generator
 * 
 */
@ApiModel("固定资产报废明细表")
public class AssetScrapDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("主表id")
    private Long scrapId;
    @ApiModelProperty("设备分类id")
    private Long equipmentTypeId;
    @ApiModelProperty("设备分类编码")
    private String equipmentTypeCode;
    @ApiModelProperty("设备分类名称")
    private String equipmentTypeName;
    @ApiModelProperty("设备id")
    private Long equipmentId;
    @ApiModelProperty("设备编码")
    private String equipmentCode;
    @ApiModelProperty("设备名称")
    private String equipmentName;
    @ApiModelProperty("资产id")
    private Long assetId;
    @ApiModelProperty("资产编码")
    private String assetCode;
    @ApiModelProperty("资产名称")
    private String assetName;
    @ApiModelProperty("财务资产id")
    private Long financeAssetId;
    @ApiModelProperty("财务资产编码")
    private String financeAssetCode;
    @ApiModelProperty("规格型号")
    private String spec;
    @ApiModelProperty("计量单位 Id")
    private Long unitId;
    @ApiModelProperty("计量单位")
    private String unit;
    @ApiModelProperty("使用单位id")
    private Long useUnitId;
    @ApiModelProperty("使用单位")
    private String useUnit;
    @ApiModelProperty("设备出厂日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date leaveFactoryDate;
    @ApiModelProperty("原值(无税)")
    private BigDecimal originalValue;
    @ApiModelProperty("原值(含税)")
    private BigDecimal originalValueTax;
    @ApiModelProperty("净值(无税)")
    private BigDecimal netWorth;
    @ApiModelProperty("净值(含税)")
    private BigDecimal netWorthTax;
    @ApiModelProperty("原值单价(无税)")
    private BigDecimal originalValuePrice;
    @ApiModelProperty("原值单价(含税)")
    private BigDecimal originalValuePriceTax;
    @ApiModelProperty("残值(含税)")
    private BigDecimal residualValueTax;
    @ApiModelProperty("残值(无税)")
    private BigDecimal residualValue;
    @ApiModelProperty("累计折旧金额")
    private BigDecimal lastDepreciationMny;
    @ApiModelProperty("累计折旧金额（含税）")
    private BigDecimal lastDepreciationTaxMny;
    @ApiModelProperty("备注")
    private String memo;
    

    /**
     * 主表id
     */
    public Long getScrapId() {
        return scrapId;
    }

    /**
     * 主表id
     */
    public void setScrapId(Long scrapId) {
        this.scrapId = scrapId;
    }
    /**
     * 设备分类id
     */
    public Long getEquipmentTypeId() {
        return equipmentTypeId;
    }

    /**
     * 设备分类id
     */
    public void setEquipmentTypeId(Long equipmentTypeId) {
        this.equipmentTypeId = equipmentTypeId;
    }
    /**
     * 设备分类编码
     */
    public String getEquipmentTypeCode() {
        return equipmentTypeCode;
    }

    /**
     * 设备分类编码
     */
    public void setEquipmentTypeCode(String equipmentTypeCode) {
        this.equipmentTypeCode = equipmentTypeCode;
    }
    /**
     * 设备分类名称
     */
    public String getEquipmentTypeName() {
        return equipmentTypeName;
    }

    /**
     * 设备分类名称
     */
    public void setEquipmentTypeName(String equipmentTypeName) {
        this.equipmentTypeName = equipmentTypeName;
    }
    /**
     * 设备id
     */
    public Long getEquipmentId() {
        return equipmentId;
    }

    /**
     * 设备id
     */
    public void setEquipmentId(Long equipmentId) {
        this.equipmentId = equipmentId;
    }
    /**
     * 设备编码
     */
    public String getEquipmentCode() {
        return equipmentCode;
    }

    /**
     * 设备编码
     */
    public void setEquipmentCode(String equipmentCode) {
        this.equipmentCode = equipmentCode;
    }
    /**
     * 设备名称
     */
    public String getEquipmentName() {
        return equipmentName;
    }

    /**
     * 设备名称
     */
    public void setEquipmentName(String equipmentName) {
        this.equipmentName = equipmentName;
    }
    /**
     * 资产id
     */
    public Long getAssetId() {
        return assetId;
    }

    /**
     * 资产id
     */
    public void setAssetId(Long assetId) {
        this.assetId = assetId;
    }
    /**
     * 资产编码
     */
    public String getAssetCode() {
        return assetCode;
    }

    /**
     * 资产编码
     */
    public void setAssetCode(String assetCode) {
        this.assetCode = assetCode;
    }
    /**
     * 资产名称
     */
    public String getAssetName() {
        return assetName;
    }

    /**
     * 资产名称
     */
    public void setAssetName(String assetName) {
        this.assetName = assetName;
    }
    /**
     * 财务资产id
     */
    public Long getFinanceAssetId() {
        return financeAssetId;
    }

    /**
     * 财务资产id
     */
    public void setFinanceAssetId(Long financeAssetId) {
        this.financeAssetId = financeAssetId;
    }
    /**
     * 财务资产编码
     */
    public String getFinanceAssetCode() {
        return financeAssetCode;
    }

    /**
     * 财务资产编码
     */
    public void setFinanceAssetCode(String financeAssetCode) {
        this.financeAssetCode = financeAssetCode;
    }
    /**
     * 规格型号
     */
    public String getSpec() {
        return spec;
    }

    /**
     * 规格型号
     */
    public void setSpec(String spec) {
        this.spec = spec;
    }
    /**
     * 计量单位 Id
     */
    public Long getUnitId() {
        return unitId;
    }

    /**
     * 计量单位 Id
     */
    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    /**
     * 计量单位
     */
    public String getUnit() {
        return unit;
    }

    /**
     * 计量单位
     */
    public void setUnit(String unit) {
        this.unit = unit;
    }
    /**
     * 使用单位id
     */
    public Long getUseUnitId() {
        return useUnitId;
    }

    /**
     * 使用单位id
     */
    public void setUseUnitId(Long useUnitId) {
        this.useUnitId = useUnitId;
    }
    /**
     * 使用单位
     */
    public String getUseUnit() {
        return useUnit;
    }

    /**
     * 使用单位
     */
    public void setUseUnit(String useUnit) {
        this.useUnit = useUnit;
    }
    /**
     * 设备出厂日期
     */
    public Date getLeaveFactoryDate() {
        return leaveFactoryDate;
    }

    /**
     * 设备出厂日期
     */
    public void setLeaveFactoryDate(Date leaveFactoryDate) {
        this.leaveFactoryDate = leaveFactoryDate;
    }
    /**
     * 原值(无税)
     */
    public BigDecimal getOriginalValue() {
        return originalValue;
    }

    /**
     * 原值(无税)
     */
    public void setOriginalValue(BigDecimal originalValue) {
        this.originalValue = originalValue;
    }
    /**
     * 原值(含税)
     */
    public BigDecimal getOriginalValueTax() {
        return originalValueTax;
    }

    /**
     * 原值(含税)
     */
    public void setOriginalValueTax(BigDecimal originalValueTax) {
        this.originalValueTax = originalValueTax;
    }
    /**
     * 净值(无税)
     */
    public BigDecimal getNetWorth() {
        return netWorth;
    }

    /**
     * 净值(无税)
     */
    public void setNetWorth(BigDecimal netWorth) {
        this.netWorth = netWorth;
    }
    /**
     * 净值(含税)
     */
    public BigDecimal getNetWorthTax() {
        return netWorthTax;
    }

    /**
     * 净值(含税)
     */
    public void setNetWorthTax(BigDecimal netWorthTax) {
        this.netWorthTax = netWorthTax;
    }
    /**
     * 原值单价(无税)
     */
    public BigDecimal getOriginalValuePrice() {
        return originalValuePrice;
    }

    /**
     * 原值单价(无税)
     */
    public void setOriginalValuePrice(BigDecimal originalValuePrice) {
        this.originalValuePrice = originalValuePrice;
    }
    /**
     * 原值单价(含税)
     */
    public BigDecimal getOriginalValuePriceTax() {
        return originalValuePriceTax;
    }

    /**
     * 原值单价(含税)
     */
    public void setOriginalValuePriceTax(BigDecimal originalValuePriceTax) {
        this.originalValuePriceTax = originalValuePriceTax;
    }
    /**
     * 残值(含税)
     */
    public BigDecimal getResidualValueTax() {
        return residualValueTax;
    }

    /**
     * 残值(含税)
     */
    public void setResidualValueTax(BigDecimal residualValueTax) {
        this.residualValueTax = residualValueTax;
    }
    /**
     * 残值(无税)
     */
    public BigDecimal getResidualValue() {
        return residualValue;
    }

    /**
     * 残值(无税)
     */
    public void setResidualValue(BigDecimal residualValue) {
        this.residualValue = residualValue;
    }
    /**
     * 累计折旧金额
     */
    public BigDecimal getLastDepreciationMny() {
        return lastDepreciationMny;
    }

    /**
     * 累计折旧金额
     */
    public void setLastDepreciationMny(BigDecimal lastDepreciationMny) {
        this.lastDepreciationMny = lastDepreciationMny;
    }
    /**
     * 累计折旧金额（含税）
     */
    public BigDecimal getLastDepreciationTaxMny() {
        return lastDepreciationTaxMny;
    }

    /**
     * 累计折旧金额（含税）
     */
    public void setLastDepreciationTaxMny(BigDecimal lastDepreciationTaxMny) {
        this.lastDepreciationTaxMny = lastDepreciationTaxMny;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    
}
