package com.ejianc.business.asset.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * 设备处置子表
 * 
 * @author generator
 * 
 */
@ApiModel("设备处置子表")
public class HandleDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("主表d")
    private Long handleId;
    @ApiModelProperty("固定资产id")
    private Long assetId;
    @ApiModelProperty("固定资产编码")
    private String assetCode;
    @ApiModelProperty("材料分类id")
    private Long equipmentTypeId;
    @ApiModelProperty("材料分类编码")
    private String equipmentTypeCode;
    @ApiModelProperty("材料分类名称")
    private String equipmentTypeName;
    @ApiModelProperty("材料id")
    private Long equipmentId;
    @ApiModelProperty("材料编码")
    private String equipmentCode;
    @ApiModelProperty("材料名称")
    private String equipmentName;
    @ApiModelProperty("规格型号")
    private String spec;
    @ApiModelProperty("计量单位id")
    private Long unitId; // 计量单位id
    @ApiModelProperty("计量单位")
    private String unit; // 计量单位
    @ApiModelProperty("使用单位id")
    private Long projectId;
    @ApiModelProperty("使用单位")
    private String projectName;
    @ApiModelProperty("出厂日期")
    private Date leaveFactoryDate;
    @ApiModelProperty("原值(无税)")
    private BigDecimal originalValue;
    @ApiModelProperty("原值(含税)")
    private BigDecimal originalValueTax;
    @ApiModelProperty("净值(无税)")
    private BigDecimal netWorth;
    @ApiModelProperty("净值(含税)")
    private BigDecimal netWorthTax;
    @ApiModelProperty("残值(含税)")
    private BigDecimal residualValueTax;
    @ApiModelProperty("残值(无税)")
    private BigDecimal residualValue;
    @ApiModelProperty("累计摊销金额(无税)")
    private BigDecimal lastAmortizeMny;
    @ApiModelProperty("累计摊销金额(含税)")
    private BigDecimal lastAmortizeTaxMny;
    @ApiModelProperty("处置金额(无税)")
    private BigDecimal handleMny;
    @ApiModelProperty("处置金额(含税)")
    private BigDecimal handleTaxMny;
    @ApiModelProperty("处置差额（无税）")
    private BigDecimal handleDiffMny;
    @ApiModelProperty("处置差额（含税）")
    private BigDecimal handleDiffTaxMny;
    @ApiModelProperty("核算对象id")
    private Long wbsId; // 核算对象id
    @ApiModelProperty("核算对象code")
    private String wbsCode; // 核算对象code
    @ApiModelProperty("核算对象name")
    private String wbsName; // 核算对象name
    @ApiModelProperty("成本科目id")
    private Long subjectId; // 成本科目id
    @ApiModelProperty("成本科目code")
    private String subjectCode; // 成本科目code
    @ApiModelProperty("成本科目name")
    private String subjectName; // 成本科目name

    /**
     * 主表d
     */
    public Long getHandleId() {
        return handleId;
    }

    /**
     * 主表d
     */
    public void setHandleId(Long handleId) {
        this.handleId = handleId;
    }

    public Long getAssetId() {
        return assetId;
    }

    public void setAssetId(Long assetId) {
        this.assetId = assetId;
    }

    public String getAssetCode() {
        return assetCode;
    }

    public void setAssetCode(String assetCode) {
        this.assetCode = assetCode;
    }

    /**
     * 材料分类id
     */
    public Long getEquipmentTypeId() {
        return equipmentTypeId;
    }

    /**
     * 材料分类id
     */
    public void setEquipmentTypeId(Long equipmentTypeId) {
        this.equipmentTypeId = equipmentTypeId;
    }
    /**
     * 材料分类编码
     */
    public String getEquipmentTypeCode() {
        return equipmentTypeCode;
    }

    /**
     * 材料分类编码
     */
    public void setEquipmentTypeCode(String equipmentTypeCode) {
        this.equipmentTypeCode = equipmentTypeCode;
    }
    /**
     * 材料分类名称
     */
    public String getEquipmentTypeName() {
        return equipmentTypeName;
    }

    /**
     * 材料分类名称
     */
    public void setEquipmentTypeName(String equipmentTypeName) {
        this.equipmentTypeName = equipmentTypeName;
    }
    /**
     * 材料id
     */
    public Long getEquipmentId() {
        return equipmentId;
    }

    /**
     * 材料id
     */
    public void setEquipmentId(Long equipmentId) {
        this.equipmentId = equipmentId;
    }
    /**
     * 材料编码
     */
    public String getEquipmentCode() {
        return equipmentCode;
    }

    /**
     * 材料编码
     */
    public void setEquipmentCode(String equipmentCode) {
        this.equipmentCode = equipmentCode;
    }
    /**
     * 材料名称
     */
    public String getEquipmentName() {
        return equipmentName;
    }

    /**
     * 材料名称
     */
    public void setEquipmentName(String equipmentName) {
        this.equipmentName = equipmentName;
    }
    /**
     * 规格型号
     */
    public String getSpec() {
        return spec;
    }

    /**
     * 规格型号
     */
    public void setSpec(String spec) {
        this.spec = spec;
    }
    /**
     * 使用单位
     */
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    /**
     * 使用单位
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }


    /**
     * 出厂日期
     */
    public Date getLeaveFactoryDate() {
        return leaveFactoryDate;
    }

    /**
     * 出厂日期
     */
    public void setLeaveFactoryDate(Date leaveFactoryDate) {
        this.leaveFactoryDate = leaveFactoryDate;
    }
    /**
     * 原值(无税)
     */
    public BigDecimal getOriginalValue() {
        return originalValue;
    }

    /**
     * 原值(无税)
     */
    public void setOriginalValue(BigDecimal originalValue) {
        this.originalValue = originalValue;
    }
    /**
     * 原值(含税)
     */
    public BigDecimal getOriginalValueTax() {
        return originalValueTax;
    }

    /**
     * 原值(含税)
     */
    public void setOriginalValueTax(BigDecimal originalValueTax) {
        this.originalValueTax = originalValueTax;
    }
    /**
     * 净值(无税)
     */
    public BigDecimal getNetWorth() {
        return netWorth;
    }

    /**
     * 净值(无税)
     */
    public void setNetWorth(BigDecimal netWorth) {
        this.netWorth = netWorth;
    }
    /**
     * 净值(含税)
     */
    public BigDecimal getNetWorthTax() {
        return netWorthTax;
    }

    /**
     * 净值(含税)
     */
    public void setNetWorthTax(BigDecimal netWorthTax) {
        this.netWorthTax = netWorthTax;
    }
    /**
     * 残值(含税)
     */
    public BigDecimal getResidualValueTax() {
        return residualValueTax;
    }

    /**
     * 残值(含税)
     */
    public void setResidualValueTax(BigDecimal residualValueTax) {
        this.residualValueTax = residualValueTax;
    }
    /**
     * 残值(无税)
     */
    public BigDecimal getResidualValue() {
        return residualValue;
    }

    /**
     * 残值(无税)
     */
    public void setResidualValue(BigDecimal residualValue) {
        this.residualValue = residualValue;
    }

    public BigDecimal getLastAmortizeMny() {
        return lastAmortizeMny;
    }

    public void setLastAmortizeMny(BigDecimal lastAmortizeMny) {
        this.lastAmortizeMny = lastAmortizeMny;
    }

    public BigDecimal getLastAmortizeTaxMny() {
        return lastAmortizeTaxMny;
    }

    public void setLastAmortizeTaxMny(BigDecimal lastAmortizeTaxMny) {
        this.lastAmortizeTaxMny = lastAmortizeTaxMny;
    }

    /**
     * 处置金额(无税)
     */
    public BigDecimal getHandleMny() {
        return handleMny;
    }

    /**
     * 处置金额(无税)
     */
    public void setHandleMny(BigDecimal handleMny) {
        this.handleMny = handleMny;
    }
    /**
     * 处置金额(含税)
     */
    public BigDecimal getHandleTaxMny() {
        return handleTaxMny;
    }

    /**
     * 处置金额(含税)
     */
    public void setHandleTaxMny(BigDecimal handleTaxMny) {
        this.handleTaxMny = handleTaxMny;
    }
    /**
     * 处置差额（无税）
     */
    public BigDecimal getHandleDiffMny() {
        return handleDiffMny;
    }

    /**
     * 处置差额（无税）
     */
    public void setHandleDiffMny(BigDecimal handleDiffMny) {
        this.handleDiffMny = handleDiffMny;
    }
    /**
     * 处置差额（含税）
     */
    public BigDecimal getHandleDiffTaxMny() {
        return handleDiffTaxMny;
    }

    /**
     * 处置差额（含税）
     */
    public void setHandleDiffTaxMny(BigDecimal handleDiffTaxMny) {
        this.handleDiffTaxMny = handleDiffTaxMny;
    }

    public Long getUnitId() {
        return unitId;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }
    @ReferSerialTransfer(referCode = "subject-project-wbs-ref")
    public Long getWbsId() {
        return wbsId;
    }
    @ReferDeserialTransfer
    public void setWbsId(Long wbsId) {
        this.wbsId = wbsId;
    }

    public String getWbsCode() {
        return wbsCode;
    }

    public void setWbsCode(String wbsCode) {
        this.wbsCode = wbsCode;
    }

    public String getWbsName() {
        return wbsName;
    }

    public void setWbsName(String wbsName) {
        this.wbsName = wbsName;
    }
    @ReferSerialTransfer(referCode = "subject-project-org-ref")
    public Long getSubjectId() {
        return subjectId;
    }
    @ReferDeserialTransfer
    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    public String getSubjectCode() {
        return subjectCode;
    }

    public void setSubjectCode(String subjectCode) {
        this.subjectCode = subjectCode;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }
}
