package com.ejianc.business.consts;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author songlx
 * @version 1.0
 * @description: 资产摊销来源枚举
 * @date 2022/7/22
 */
public enum AssetAmortizeEnum {


    自制(1, "自制"),
    财务推送(2, "财务推送"),
    系统自动摊销(3, "系统自动摊销"),
    ;

    private Integer code;

    private String description;

    private static Map<Integer, String> enumMap = new HashMap();

    static {
        enumMap = EnumSet.allOf(AssetAmortizeEnum.class).stream().collect(Collectors.toMap(AssetAmortizeEnum::getCode, AssetAmortizeEnum::getDescription));
    }

    public static String getNameByCode(Integer code) {
        return enumMap.get(code);
    }


    AssetAmortizeEnum(Integer code, String description) {
        this.code = code;
        this.description = description;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }


}
