package com.ejianc.business.pricelib.api;

import com.ejianc.business.pricelib.hystrix.PurchasePriceContractCollectHystrix;
import com.ejianc.business.pricelib.vo.PriceContractCollectVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 设备购置价格库API
 */
@FeignClient(
        name = "ejc-proequipmentp-web",
        url = "${common.env.feign-client-url}",
        path = "ejc-proequipmentp-web",
        fallback = PurchasePriceContractCollectHystrix.class
)
public interface IPurchasePriceContractCollectApi {

    // 查询多个档案清单历史价格
    @PostMapping(value = "/api/priceContractCollectApi/getPriceContractByDocIds")
    CommonResponse<List<PriceContractCollectVO>> getPriceContractByDocIds(@RequestBody List<Long> docIds);
}
