package com.ejianc.business.settlement.api;

import com.ejianc.business.settlement.hystrix.PurchaseSettleHystrix;
import com.ejianc.business.settlement.vo.SourceBliVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 *设备采购结算API
 */
@FeignClient(name = "ejc-proequipmentp-web", url = "${common.env.feign-client-url}", path = "ejc-proequipmentp-web", fallback = PurchaseSettleHystrix.class)
public interface IPurchaseSettleApi {
    /**
     * 设备管理：
     * 1、累计单据数量：查该供应商在本下项目生效的  设备采购结算；
     * 2、协同单据数量：查该供应商在本下项目生效的  设备采购结算（已签字）；
     * 3、比例：协同单据数量/累计单据数量；
     * @param supplierId
     * @param dateIn
     * @return
     */
    @GetMapping(value = "/api/purchaseSettle/getSourceBliVO")
    CommonResponse<SourceBliVO> getSourceBliVO(@RequestParam(value = "supplierId") Long supplierId, @RequestParam(value = "dateIn",required = false) String dateIn);
}
