package com.ejianc.business.asset.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.business.consts.AssetRecordTypeEnum;
import com.ejianc.business.decorator.IAssetRecord;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.collections.CollectionUtils;


/**
 *  设备处置
 * 
 * @author generator
 * 
 */
@ApiModel(" 设备处置")
public class HandleVO extends BaseVO implements IAssetRecord {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("单据编码")
    private String billCode;
    @ApiModelProperty("单据状态")
    private Integer billState;
    @ApiModelProperty("处置日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date handleDate;
    @ApiModelProperty("处置人")
    private String handlePersonName;
    @ApiModelProperty("处置人id")
    private Long handlePerson;
    @ApiModelProperty("处置项目id")
    private Long projectId;
    @ApiModelProperty("处置项目名称")
    private String projectName;
    @ApiModelProperty("所属项目部Id")
    private Long orgId;
    @ApiModelProperty("所属项目部名称")
    private String orgName;
    @ApiModelProperty("项目组织编码")
    private String orgCode;
    @ApiModelProperty("项目部上级组织id")
    private Long parentOrgId;
    @ApiModelProperty("项目部上级组织名称")
    private String parentOrgName;
    @ApiModelProperty("项目部上级组织编码")
    private String parentOrgCode;
    @ApiModelProperty("处置金额(含税)")
    private BigDecimal handleTaxMny;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("处置金额")
    private BigDecimal handleMny;
    @ApiModelProperty("处置类型 1：正常处置 2：非正常处置")
    private Integer handleType;
    @ApiModelProperty("处置原因id")
    private Long handleReason;
    @ApiModelProperty("处置原因")
    private String handleReasonName;
    @ApiModelProperty("经办人id")
    private Long employeeId;
    @ApiModelProperty("经办人")
    private String employeeName;
    @ApiModelProperty("经办人部门id")
    private Long departmentId;
    @ApiModelProperty(" 经办人部门")
    private String departmentName;
    @ApiModelProperty("来源 1：自制 2:财务推送")
    private Integer source;
    @ApiModelProperty("关联状态")
    private String relationFlag; // 关联状态
    @ApiModelProperty("分摊状态")
    private String proportionFlag; // 分摊状态
    @ApiModelProperty("调拨差额(无税)合计")
    private BigDecimal  sumHandleDiffMny;//调拨差额(无税)
    @ApiModelProperty("调拨差额合计")
    private BigDecimal  sumHandleDiffTaxMny;//调拨差额
    private List<HandleDetailVO> handleDetailList = new ArrayList<>(); // 设备处置子表
    @ApiModelProperty("来源名称")
    private String sourceName;
    @ApiModelProperty("单据状态名称")
    private String billStateName;
    @ApiModelProperty("处置类型名称")
    private String handleTypeName;
    /**
     * 单据编码
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编码
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 处置日期
     */
    public Date getHandleDate() {
        return handleDate;
    }

    /**
     * 处置日期
     */
    public void setHandleDate(Date handleDate) {
        this.handleDate = handleDate;
    }

    public String getHandlePersonName() {
        return handlePersonName;
    }

    public void setHandlePersonName(String handlePersonName) {
        this.handlePersonName = handlePersonName;
    }
    @ReferSerialTransfer(referCode = "idm-user")
    public Long getHandlePerson() {
        return handlePerson;
    }
    @ReferDeserialTransfer
    public void setHandlePerson(Long handlePerson) {
        this.handlePerson = handlePerson;
    }
    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    /**
     * 所属项目部Id
     */
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 所属项目部Id
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 所属项目部名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 所属项目部名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目组织编码
     */
    public String getOrgCode() {
        return orgCode;
    }

    /**
     * 项目组织编码
     */
    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }
    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    /**
     * 处置金额(含税)
     */
    public BigDecimal getHandleTaxMny() {
        return handleTaxMny;
    }

    /**
     * 处置金额(含税)
     */
    public void setHandleTaxMny(BigDecimal handleTaxMny) {
        this.handleTaxMny = handleTaxMny;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 处置金额
     */
    public BigDecimal getHandleMny() {
        return handleMny;
    }

    /**
     * 处置金额
     */
    public void setHandleMny(BigDecimal handleMny) {
        this.handleMny = handleMny;
    }
    /**
     * 处置类型 1：正常处置 2：非正常处置
     */
    public Integer getHandleType() {
        return handleType;
    }

    /**
     * 处置类型 1：正常处置 2：非正常处置
     */
    public void setHandleType(Integer handleType) {
        this.handleType = handleType;
    }
    /**
     * 处置原因id
     */
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getHandleReason() {
        return handleReason;
    }

    /**
     * 处置原因id
     */
    @ReferDeserialTransfer
    public void setHandleReason(Long handleReason) {
        this.handleReason = handleReason;
    }
    /**
     * 处置原因
     */
    public String getHandleReasonName() {
        return handleReasonName;
    }

    /**
     * 处置原因
     */
    public void setHandleReasonName(String handleReasonName) {
        this.handleReasonName = handleReasonName;
    }
    /**
     * 经办人id
     */
    @ReferSerialTransfer(referCode = "idm-user")
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人id
     */
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 经办人部门id
     */
    public Long getDepartmentId() {
        return departmentId;
    }

    /**
     * 经办人部门id
     */
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    /**
     *  经办人部门
     */
    public String getDepartmentName() {
        return departmentName;
    }

    /**
     *  经办人部门
     */
    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    /**
     * 来源 1：自制 2:财务推送
     */
    public Integer getSource() {
        return source;
    }

    /**
     * 来源 1：自制 2:财务推送
     */
    public void setSource(Integer source) {
        this.source = source;
    }

    public String getRelationFlag() {
        return relationFlag;
    }

    public void setRelationFlag(String relationFlag) {
        this.relationFlag = relationFlag;
    }

    public String getProportionFlag() {
        return proportionFlag;
    }

    public void setProportionFlag(String proportionFlag) {
        this.proportionFlag = proportionFlag;
    }

    public BigDecimal getSumHandleDiffMny() {
        return sumHandleDiffMny;
    }

    public void setSumHandleDiffMny(BigDecimal sumHandleDiffMny) {
        this.sumHandleDiffMny = sumHandleDiffMny;
    }

    public BigDecimal getSumHandleDiffTaxMny() {
        return sumHandleDiffTaxMny;
    }

    public void setSumHandleDiffTaxMny(BigDecimal sumHandleDiffTaxMny) {
        this.sumHandleDiffTaxMny = sumHandleDiffTaxMny;
    }

    public String getSourceName() {
        return sourceName;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getHandleTypeName() {
        return handleTypeName;
    }

    public void setHandleTypeName(String handleTypeName) {
        this.handleTypeName = handleTypeName;
    }

    public List<HandleDetailVO> getHandleDetailList() {
        return handleDetailList;
    }

    public void setHandleDetailList(List<HandleDetailVO> handleDetailList) {
        this.handleDetailList = handleDetailList;
    }

    @Override
    public List<AssetRecordVO> toRecordList() {
        List<HandleDetailVO> handleDetailList = this.getHandleDetailList();
        ArrayList<AssetRecordVO> assetRecordVOS = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(handleDetailList)) {
            for (HandleDetailVO handleDetailVO : handleDetailList) {
                AssetRecordVO recordVO = BeanMapper.map(handleDetailVO, AssetRecordVO.class);
                recordVO.setId(null);
                recordVO.setVersion(null);
                recordVO.setBillDate(new Date());
                recordVO.setSourceId(this.getId());
                recordVO.setSourceBillCode(this.getBillCode());
                recordVO.setSourceDetailId(handleDetailVO.getId());
                recordVO.setSourceType(AssetRecordTypeEnum.处置.getCode());
                recordVO.setSourceTypeName(AssetRecordTypeEnum.处置.getName());
                recordVO.setOrgId(this.getOrgId());
                recordVO.setOrgName(this.getOrgName());
                recordVO.setOrgCode(this.getOrgCode());
                recordVO.setProjectId(this.getProjectId());
                recordVO.setProjectName(this.getProjectName());
                recordVO.setParentOrgId(this.getParentOrgId());
                recordVO.setParentOrgName(this.getParentOrgName());
                recordVO.setParentOrgCode(this.getParentOrgCode());
                assetRecordVOS.add(recordVO);
            }
        }
        return assetRecordVOS;
    }
}
