package com.ejianc.business.settlement.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.business.contractpub.util.ConvertField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 设备采购结算表
 * 
 * @author generator
 * 
 */
@ApiModel("设备采购结算表")
public class SupPurchaseSettlementVO{
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("单据编号")
    @ConvertField(targetField = "billCode")
    private String billCode;
    @ApiModelProperty("单据状态（审批必须字段）")
    @ConvertField(targetField = "billState")
    private Integer billState;
    @ApiModelProperty("项目")
    @ConvertField(targetField = "projectId")
    private Long projectId;
    @ApiModelProperty("项目编码")
    @ConvertField(targetField = "projectCode")
    private String projectCode;
    @ApiModelProperty("项目名称")
    @ConvertField(targetField = "projectName")
    private String projectName;
    @ApiModelProperty("组织")
    @ConvertField(targetField = "orgId")
    private Long orgId;
    @ApiModelProperty("组织名称")
    @ConvertField(targetField = "orgName")
    private String orgName;
    @ApiModelProperty("项目部上级组织Id")
    @ConvertField(targetField = "parentOrgId")
    private Long parentOrgId;
    @ApiModelProperty("项目部上级组织名称")
    @ConvertField(targetField = "parentOrgName")
    private String parentOrgName;
    @ApiModelProperty("合同主键")
    @ConvertField(targetField = "contractId")
    private Long contractId;
    @ApiModelProperty("合同名称")
    @ConvertField(targetField = "contractName")
    private String contractName;
    @ApiModelProperty("合同编号")
    @ConvertField(targetField = "contractCode")
    private String contractCode;
    @ApiModelProperty("供应商")
    @ConvertField(targetField = "partybId")
    private Long supplierId;
    @ApiModelProperty("供应商名称")
    @ConvertField(targetField = "partybName")
    private String supplierName;
    @ApiModelProperty("经办人")
    @ConvertField(targetField = "employeeId")
    private Long employeeId;
    @ConvertField(targetField = "employeeName")
    @ApiModelProperty("经办人名称")
    private String employeeName;
    @ApiModelProperty("结算日期")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @ConvertField(targetField = "settleDate")
    private Date settlementDate;
    @ApiModelProperty("经办部门")
    private Long departmentId;
    @ApiModelProperty("经办部门名称")
    private String departmentName;
    @ApiModelProperty("合同采购编码")
    private String contractPropertyCode;
    @ApiModelProperty("合同采购（属性）名称")
    private String contractPropertyName;
    @ApiModelProperty("备注")
    @ConvertField(targetField = "memo")
    private String memo;
    @ApiModelProperty("签章状态：1、未签章；2、待乙方签章；3、待甲方签章；4、已签章；  单据新增后默认为未签章")
    private Integer signatureStatus;
    @ApiModelProperty("签字状态，0-未签字,1-已签字")
    private Integer signStatus;
    @ApiModelProperty("结算类型，0-过程,1-最终")
    @ConvertField(targetField = "ultimateFlag")
    private Integer signatureType;
    @ApiModelProperty("结算金额(无税)")
    @ConvertField(targetField = "curMny")
    private BigDecimal settlementMny;
    @ApiModelProperty("结算金额")
    @ConvertField(targetField = "curTaxMny")
    private BigDecimal settlementTaxMny;
    @ApiModelProperty("结算税额")
    @ConvertField(targetField = "curTax")
    private BigDecimal settlementTax;
    @ApiModelProperty("采购金额(无税)")
    private BigDecimal materialMny;
    @ApiModelProperty("采购金额")
    private BigDecimal materialTaxMny;
    @ApiModelProperty("采购税额")
    private BigDecimal materialTax;
    @ApiModelProperty("其他金额(无税)")
    private BigDecimal feeMny;
    @ApiModelProperty("其他金额")
    private BigDecimal feeTaxMny;
    @ApiModelProperty("其他税额")
    private BigDecimal feeTax;
    @ApiModelProperty("合同金额")
    private BigDecimal contractTaxMny;
    @ApiModelProperty("合同金额（无税）")
    private BigDecimal contractMny;
    @ApiModelProperty("合同税额")
    private BigDecimal contractTax;
    @ApiModelProperty("合同收票金额")
    private BigDecimal contractInvoiceTaxMny;
    @ApiModelProperty("合同收票金额(不含税)")
    private BigDecimal contractInvoiceMny;
    @ApiModelProperty("合同已付金额")
    private BigDecimal contractPayMny;
    @ApiModelProperty("合同支付比例")
    private BigDecimal contractPayScale;
    @ApiModelProperty("含本期结算金额")
    private BigDecimal currentSettlementTaxMny;
    @ApiModelProperty("含本期结算金额（无税）")
    private BigDecimal currentSettlementMny;
    @ApiModelProperty("对账单类型（0-物资采购结算单，1-混凝土结算单）")
    private Integer settlementType;
    @ApiModelProperty("")
    private String supOperatorUserCode;
    @ApiModelProperty("")
    private String supOperatorPhone;
    @ApiModelProperty("")
    private String supOperatorName;
    @ApiModelProperty("")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date supOperateTime;
    @ApiModelProperty("单据推送标识：unSucPush-未成功推送供方，sucPushed-已成功推送供方")
    private String billPushFlag;
    private String billStateName;
    private String signStatusName;
    private String signatureStatusName;
    private String systemId;//来源业务系统id
    private Long id; // 主键
    private Integer settlementNum;//生效结算次数
    private String orgCode; // 项目部编码

    @ApiModelProperty("设备采购结算明细表")
    private List<SupPurchaseSettlementDetailVO> purchaseSettlementDetailList = new ArrayList<>();
    @ApiModelProperty("设备采购结算其他费用表")
    private List<SupPurchaseSettlementFeeVO> purchaseSettlementFeeList = new ArrayList<>();

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public Integer getSettlementNum() {
        return settlementNum;
    }

    public void setSettlementNum(Integer settlementNum) {
        this.settlementNum = settlementNum;
    }

    public String getSystemId() {
        return systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getSignStatusName() {
        return signStatusName;
    }

    public void setSignStatusName(String signStatusName) {
        this.signStatusName = signStatusName;
    }

    public String getSignatureStatusName() {
        return signatureStatusName;
    }

    public void setSignatureStatusName(String signatureStatusName) {
        this.signatureStatusName = signatureStatusName;
    }

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 项目
     */
    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目编码
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编码
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 组织
     */
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目部上级组织Id
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 项目部上级组织Id
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 项目部上级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 项目部上级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 合同主键
     */
    @ReferSerialTransfer(referCode = "purchaseContract")
    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同主键
     */
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 合同编号
     */
    public String getContractCode() {
        return contractCode;
    }

    /**
     * 合同编号
     */
    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    /**
     * 供应商
     */
    public Long getSupplierId() {
        return supplierId;
    }

    /**
     * 供应商
     */
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 供应商名称
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 供应商名称
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 经办人
     */
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 结算日期
     */
    public Date getSettlementDate() {
        return settlementDate;
    }

    /**
     * 结算日期
     */
    public void setSettlementDate(Date settlementDate) {
        this.settlementDate = settlementDate;
    }
    /**
     * 经办部门
     */
    public Long getDepartmentId() {
        return departmentId;
    }

    /**
     * 经办部门
     */
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    /**
     * 经办部门名称
     */
    public String getDepartmentName() {
        return departmentName;
    }

    /**
     * 经办部门名称
     */
    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    /**
     * 合同采购编码
     */
    public String getContractPropertyCode() {
        return contractPropertyCode;
    }

    /**
     * 合同采购编码
     */
    public void setContractPropertyCode(String contractPropertyCode) {
        this.contractPropertyCode = contractPropertyCode;
    }
    /**
     * 合同采购（属性）名称
     */
    public String getContractPropertyName() {
        return contractPropertyName;
    }

    /**
     * 合同采购（属性）名称
     */
    public void setContractPropertyName(String contractPropertyName) {
        this.contractPropertyName = contractPropertyName;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 签章状态：1、未签章；2、待乙方签章；3、待甲方签章；4、已签章；  单据新增后默认为未签章
     */
    public Integer getSignatureStatus() {
        return signatureStatus;
    }

    /**
     * 签章状态：1、未签章；2、待乙方签章；3、待甲方签章；4、已签章；  单据新增后默认为未签章
     */
    public void setSignatureStatus(Integer signatureStatus) {
        this.signatureStatus = signatureStatus;
    }
    /**
     * 签字状态，0-未签字,1-已签字
     */
    public Integer getSignStatus() {
        return signStatus;
    }

    /**
     * 签字状态，0-未签字,1-已签字
     */
    public void setSignStatus(Integer signStatus) {
        this.signStatus = signStatus;
    }
    /**
     * 结算类型，0-过程,1-最终
     */
    public Integer getSignatureType() {
        return signatureType;
    }

    /**
     * 结算类型，0-过程,1-最终
     */
    public void setSignatureType(Integer signatureType) {
        this.signatureType = signatureType;
    }
    /**
     * 结算金额(无税)
     */
    public BigDecimal getSettlementMny() {
        return settlementMny;
    }

    /**
     * 结算金额(无税)
     */
    public void setSettlementMny(BigDecimal settlementMny) {
        this.settlementMny = settlementMny;
    }
    /**
     * 结算金额
     */
    public BigDecimal getSettlementTaxMny() {
        return settlementTaxMny;
    }

    /**
     * 结算金额
     */
    public void setSettlementTaxMny(BigDecimal settlementTaxMny) {
        this.settlementTaxMny = settlementTaxMny;
    }
    /**
     * 结算税额
     */
    public BigDecimal getSettlementTax() {
        return settlementTax;
    }

    /**
     * 结算税额
     */
    public void setSettlementTax(BigDecimal settlementTax) {
        this.settlementTax = settlementTax;
    }
    /**
     * 采购金额(无税)
     */
    public BigDecimal getMaterialMny() {
        return materialMny;
    }

    /**
     * 采购金额(无税)
     */
    public void setMaterialMny(BigDecimal materialMny) {
        this.materialMny = materialMny;
    }
    /**
     * 采购金额
     */
    public BigDecimal getMaterialTaxMny() {
        return materialTaxMny;
    }

    /**
     * 采购金额
     */
    public void setMaterialTaxMny(BigDecimal materialTaxMny) {
        this.materialTaxMny = materialTaxMny;
    }
    /**
     * 采购税额
     */
    public BigDecimal getMaterialTax() {
        return materialTax;
    }

    /**
     * 采购税额
     */
    public void setMaterialTax(BigDecimal materialTax) {
        this.materialTax = materialTax;
    }
    /**
     * 其他金额(无税)
     */
    public BigDecimal getFeeMny() {
        return feeMny;
    }

    /**
     * 其他金额(无税)
     */
    public void setFeeMny(BigDecimal feeMny) {
        this.feeMny = feeMny;
    }
    /**
     * 其他金额
     */
    public BigDecimal getFeeTaxMny() {
        return feeTaxMny;
    }

    /**
     * 其他金额
     */
    public void setFeeTaxMny(BigDecimal feeTaxMny) {
        this.feeTaxMny = feeTaxMny;
    }
    /**
     * 其他税额
     */
    public BigDecimal getFeeTax() {
        return feeTax;
    }

    /**
     * 其他税额
     */
    public void setFeeTax(BigDecimal feeTax) {
        this.feeTax = feeTax;
    }
    /**
     * 合同金额
     */
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    /**
     * 合同金额
     */
    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    /**
     * 合同金额（无税）
     */
    public BigDecimal getContractMny() {
        return contractMny;
    }

    /**
     * 合同金额（无税）
     */
    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    /**
     * 合同税额
     */
    public BigDecimal getContractTax() {
        return contractTax;
    }

    /**
     * 合同税额
     */
    public void setContractTax(BigDecimal contractTax) {
        this.contractTax = contractTax;
    }
    /**
     * 合同收票金额
     */
    public BigDecimal getContractInvoiceTaxMny() {
        return contractInvoiceTaxMny;
    }

    /**
     * 合同收票金额
     */
    public void setContractInvoiceTaxMny(BigDecimal contractInvoiceTaxMny) {
        this.contractInvoiceTaxMny = contractInvoiceTaxMny;
    }
    /**
     * 合同收票金额(不含税)
     */
    public BigDecimal getContractInvoiceMny() {
        return contractInvoiceMny;
    }

    /**
     * 合同收票金额(不含税)
     */
    public void setContractInvoiceMny(BigDecimal contractInvoiceMny) {
        this.contractInvoiceMny = contractInvoiceMny;
    }
    /**
     * 合同已付金额
     */
    public BigDecimal getContractPayMny() {
        return contractPayMny;
    }

    /**
     * 合同已付金额
     */
    public void setContractPayMny(BigDecimal contractPayMny) {
        this.contractPayMny = contractPayMny;
    }
    /**
     * 合同支付比例
     */
    public BigDecimal getContractPayScale() {
        return contractPayScale;
    }

    /**
     * 合同支付比例
     */
    public void setContractPayScale(BigDecimal contractPayScale) {
        this.contractPayScale = contractPayScale;
    }
    /**
     * 含本期结算金额
     */
    public BigDecimal getCurrentSettlementTaxMny() {
        return currentSettlementTaxMny;
    }

    /**
     * 含本期结算金额
     */
    public void setCurrentSettlementTaxMny(BigDecimal currentSettlementTaxMny) {
        this.currentSettlementTaxMny = currentSettlementTaxMny;
    }
    /**
     * 含本期结算金额（无税）
     */
    public BigDecimal getCurrentSettlementMny() {
        return currentSettlementMny;
    }

    /**
     * 含本期结算金额（无税）
     */
    public void setCurrentSettlementMny(BigDecimal currentSettlementMny) {
        this.currentSettlementMny = currentSettlementMny;
    }
    /**
     * 对账单类型（0-物资采购结算单，1-混凝土结算单）
     */
    public Integer getSettlementType() {
        return settlementType;
    }

    /**
     * 对账单类型（0-物资采购结算单，1-混凝土结算单）
     */
    public void setSettlementType(Integer settlementType) {
        this.settlementType = settlementType;
    }
    /**
     * 
     */
    public String getSupOperatorUserCode() {
        return supOperatorUserCode;
    }

    /**
     * 
     */
    public void setSupOperatorUserCode(String supOperatorUserCode) {
        this.supOperatorUserCode = supOperatorUserCode;
    }
    /**
     * 
     */
    public String getSupOperatorPhone() {
        return supOperatorPhone;
    }

    /**
     * 
     */
    public void setSupOperatorPhone(String supOperatorPhone) {
        this.supOperatorPhone = supOperatorPhone;
    }
    /**
     * 
     */
    public String getSupOperatorName() {
        return supOperatorName;
    }

    /**
     * 
     */
    public void setSupOperatorName(String supOperatorName) {
        this.supOperatorName = supOperatorName;
    }
    /**
     * 
     */
    public Date getSupOperateTime() {
        return supOperateTime;
    }

    /**
     * 
     */
    public void setSupOperateTime(Date supOperateTime) {
        this.supOperateTime = supOperateTime;
    }
    /**
     * 单据推送标识：unSucPush-未成功推送供方，sucPushed-已成功推送供方
     */
    public String getBillPushFlag() {
        return billPushFlag;
    }

    /**
     * 单据推送标识：unSucPush-未成功推送供方，sucPushed-已成功推送供方
     */
    public void setBillPushFlag(String billPushFlag) {
        this.billPushFlag = billPushFlag;
    }
    
     /**
      * 设备采购结算明细表
      */
      public List<SupPurchaseSettlementDetailVO> getPurchaseSettlementDetailList() {
         return purchaseSettlementDetailList;
      }
     /**
      * 设备采购结算明细表
      */
     public void setPurchaseSettlementDetailList(List<SupPurchaseSettlementDetailVO> purchaseSettlementDetailList) {
         this.purchaseSettlementDetailList = purchaseSettlementDetailList;
     }
     /**
      * 设备采购结算其他费用表
      */
      public List<SupPurchaseSettlementFeeVO> getPurchaseSettlementFeeList() {
         return purchaseSettlementFeeList;
      }
     /**
      * 设备采购结算其他费用表
      */
     public void setPurchaseSettlementFeeList(List<SupPurchaseSettlementFeeVO> purchaseSettlementFeeList) {
         this.purchaseSettlementFeeList = purchaseSettlementFeeList;
     }
}
