package com.ejianc.business.purchaseplan.vo.api;



import com.ejianc.business.purchaseplan.vo.hystrix.PurchasePlanHystrix;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(
        name = "ejc-proequipmentp-web",
        url = "${common.env.feign-client-url}",
        path = "ejc-proequipmentp-web",
        fallback = PurchasePlanHystrix.class
)
public interface IPurchasePlanApi {

    /**
     * 批量修改采购计划引用状态
     * 枚举类：BatPlanEnum
     *
     * @param idList    idList
     * @param planState 计划状态（0-待采购；1-采购中；2-采购完成）
     * @return 修改结果
     */
    @RequestMapping(
            value = {"/api/purchasePlanApi/updateBatPlanQuote"},
            method = {RequestMethod.GET}
    )
    CommonResponse<String> updateBatPlanQuote(@RequestParam("idList") List<String> idList,
                                              @RequestParam("planState") Integer planState);
}
