package com.ejianc.business.asset.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;

import com.ejianc.business.consts.AssetRecordTypeEnum;
import com.ejianc.business.decorator.IAssetRecord;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import org.apache.commons.collections.CollectionUtils;

/**
 * 固定资产摊销
 *
 * @author generator
 */
@ApiModel("固定资产摊销")
public class AssetAmortizeVO extends BaseVO implements IAssetRecord {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("单据编号")
    private String billCode;
    @ApiModelProperty("办理日期")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date billDate;
    @ApiModelProperty("单据状态")
    private Integer billState;
    @ApiModelProperty("单据来源1自制2财务系统,3系统自动摊销")
    private Integer sourceType;
    @ApiModelProperty("项目")
    private Long projectId;
    @ApiModelProperty("项目编号")
    private String projectCode;
    @ApiModelProperty("项目名称")
    private String projectName;
    @ApiModelProperty("所属组织")
    private Long parentOrgId;
    @ApiModelProperty("所属组织编码")
    private String parentOrgCode;
    @ApiModelProperty("所属组织名称")
    private String parentOrgName;
    @ApiModelProperty("摊销单位")
    private Long orgId;
    @ApiModelProperty("摊销单位编码")
    private String orgCode;
    @ApiModelProperty("摊销单位名称")
    private String orgName;
    @ApiModelProperty("单据生效时间")
    private Date effectTime;
    @ApiModelProperty("摊销周期")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM", timezone = "GMT+8")
    private Date amortizeDate;
    @ApiModelProperty("上次摊销周期")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM", timezone = "GMT+8")
    private Date lastAmortizeDate;
    @ApiModelProperty("摊销金额(含税)")
    private BigDecimal amortizeTaxMny;
    @ApiModelProperty("摊销金额(无税)")
    private BigDecimal amortizeMny;
    @ApiModelProperty("经办人")
    private Long employeeId;
    @ApiModelProperty("经办人名称")
    private String employeeName;
    @ApiModelProperty("经办部门")
    private Long deptId;
    @ApiModelProperty("经办部门名称")
    private String deptName;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("材料分类名称")
    private String categoryName;
    @ApiModelProperty("摊销方法,1-年限平均法")
    private Integer amortizeMethod;
    @ApiModelProperty("财务推送状态1已推送0未推送")
    private Integer financePushState;
    @ApiModelProperty("关联状态")
    private String relationFlag;
    @ApiModelProperty("分摊状态")
    private String proportionFlag;

    @ApiModelProperty("固定资产摊销明细表")
    private List<AssetAmortizeDetailVO> detailList = new ArrayList<>();

    @ApiModelProperty("单据来源1自制2财务系统")
    private String sourceTypeName;

    @ApiModelProperty("单据状态名称")
    private String billStateName;

    private List<Long> idList;


    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public List<Long> getIdList() {
        return idList;
    }

    public void setIdList(List<Long> idList) {
        this.idList = idList;
    }

    public String getRelationFlag() {
        return relationFlag;
    }

    public void setRelationFlag(String relationFlag) {
        this.relationFlag = relationFlag;
    }

    public String getProportionFlag() {
        return proportionFlag;
    }

    public void setProportionFlag(String proportionFlag) {
        this.proportionFlag = proportionFlag;
    }

    public Integer getFinancePushState() {
        return financePushState;
    }

    public void setFinancePushState(Integer financePushState) {
        this.financePushState = financePushState;
    }

    public String getSourceTypeName() {
        return sourceTypeName;
    }

    public void setSourceTypeName(String sourceTypeName) {
        this.sourceTypeName = sourceTypeName;
    }

    public Date getLastAmortizeDate() {
        return lastAmortizeDate;
    }

    public void setLastAmortizeDate(Date lastAmortizeDate) {
        this.lastAmortizeDate = lastAmortizeDate;
    }

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    /**
     * 办理日期
     */
    public Date getBillDate() {
        return billDate;
    }

    /**
     * 办理日期
     */
    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }


    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    /**
     * 项目
     */
    @ReferSerialTransfer(referCode="project-set")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    /**
     * 项目编号
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编号
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    /**
     * 所属组织
     */
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 所属组织
     */
    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    /**
     * 所属组织编码
     */
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    /**
     * 所属组织编码
     */
    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    /**
     * 所属组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 所属组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    /**
     * 摊销单位
     */
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 摊销单位
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    /**
     * 摊销单位编码
     */
    public String getOrgCode() {
        return orgCode;
    }

    /**
     * 摊销单位编码
     */
    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    /**
     * 摊销单位名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 摊销单位名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    /**
     * 单据生效时间
     */
    public Date getEffectTime() {
        return effectTime;
    }

    /**
     * 单据生效时间
     */
    public void setEffectTime(Date effectTime) {
        this.effectTime = effectTime;
    }

    /**
     * 摊销周期
     */
    public Date getAmortizeDate() {
        return amortizeDate;
    }

    /**
     * 摊销周期
     */
    public void setAmortizeDate(Date amortizeDate) {
        this.amortizeDate = amortizeDate;
    }

    /**
     * 摊销金额(含税)
     */
    public BigDecimal getAmortizeTaxMny() {
        return amortizeTaxMny;
    }

    /**
     * 摊销金额(含税)
     */
    public void setAmortizeTaxMny(BigDecimal amortizeTaxMny) {
        this.amortizeTaxMny = amortizeTaxMny;
    }

    /**
     * 摊销金额(无税)
     */
    public BigDecimal getAmortizeMny() {
        return amortizeMny;
    }

    /**
     * 摊销金额(无税)
     */
    public void setAmortizeMny(BigDecimal amortizeMny) {
        this.amortizeMny = amortizeMny;
    }

    /**
     * 经办人
     */
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    /**
     * 经办部门
     */
    @ReferSerialTransfer(referCode = "idm-dept")
    public Long getDeptId() {
        return deptId;
    }

    /**
     * 经办部门
     */
    @ReferDeserialTransfer
    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }

    /**
     * 经办部门名称
     */
    public String getDeptName() {
        return deptName;
    }

    /**
     * 经办部门名称
     */
    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }

    /**
     * 材料分类名称
     */
    public String getCategoryName() {
        return categoryName;
    }

    /**
     * 材料分类名称
     */
    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    /**
     * 摊销方法,1-年限平均法
     */
    public Integer getAmortizeMethod() {
        return amortizeMethod;
    }

    /**
     * 摊销方法,1-年限平均法
     */
    public void setAmortizeMethod(Integer amortizeMethod) {
        this.amortizeMethod = amortizeMethod;
    }

    /**
     * 固定资产摊销明细表
     */
    public List<AssetAmortizeDetailVO> getDetailList() {
        return detailList;
    }

    /**
     * 固定资产摊销明细表
     */
    public void setDetailList(List<AssetAmortizeDetailVO> detailList) {
        this.detailList = detailList;
    }

    /**
     * @description: 将业务VO转化成记录List
     * @return: java.util.List<com.ejianc.business.asset.vo.AssetRecordVO>
     * @author songlx
     * @date: 2022/6/25
     */
    @Override
    public List<AssetRecordVO> toRecordList() {
        List<AssetAmortizeDetailVO> assetAmortizeDetailList = this.getDetailList();
        ArrayList<AssetRecordVO> assetRecordVOS = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(assetAmortizeDetailList)) {
            for (AssetAmortizeDetailVO assetAmortizeDetailVO : assetAmortizeDetailList) {
                AssetRecordVO recordVO = BeanMapper.map(assetAmortizeDetailVO, AssetRecordVO.class);
                recordVO.setId(null);
                recordVO.setVersion(null);
                recordVO.setBillDate(new Date());
                recordVO.setSourceId(this.getId());
                recordVO.setSourceBillCode(this.getBillCode());
                recordVO.setSourceDetailId(assetAmortizeDetailVO.getId());
                recordVO.setSourceType(AssetRecordTypeEnum.新增.getCode());
                recordVO.setSourceTypeName(AssetRecordTypeEnum.新增.getName());
                assetRecordVOS.add(recordVO);
            }
        }
        return assetRecordVOS;
    }


}
