package com.ejianc.business.settlement.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;


/**
 * 设备采购结算明细表
 * 
 * @author generator
 * 
 */
@ApiModel("设备采购结算明细表")
public class SupPurchaseSettlementDetailVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("结算主键ID")
    private Long settlementId;
    @ApiModelProperty("来源主键ID")
    private Long sourceId;
    @ApiModelProperty("来源明细主键ID")
    private Long sourceDetailId;
    @ApiModelProperty("来源类型名称(对账—100231)")
    private String sourceName;
    @ApiModelProperty("来源编码")
    private String sourceCode;
    @ApiModelProperty("物资类别")
    private Long materialTypeId;
    @ApiModelProperty("物资类别名称")
    private String materialTypeName;
    @ApiModelProperty("物资主键")
    private Long materialId;
    @ApiModelProperty("物资名称")
    private String materialName;
    @ApiModelProperty("物资编码")
    private String materialCode;
    @ApiModelProperty("规格型号")
    private String spec;
    @ApiModelProperty("单位")
    private String unit;
    @ApiModelProperty("单位id")
    private Long unitId;
    @ApiModelProperty("可结算金额")
    private BigDecimal overageSettleTaxMny;
    @ApiModelProperty("结算单价(无税)")
    private BigDecimal price;
    @ApiModelProperty("结算单价)")
    private BigDecimal taxPrice;
    @ApiModelProperty("结算金额(无税)")
    private BigDecimal mny;
    @ApiModelProperty("结算金额")
    private BigDecimal taxMny;
    @ApiModelProperty("税率")
    private BigDecimal taxRate;
    @ApiModelProperty("税额")
    private BigDecimal tax;
    @ApiModelProperty("备注")
    private String memo;
    private Long id; // 主键

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 结算主键ID
     */
    public Long getSettlementId() {
        return settlementId;
    }

    /**
     * 结算主键ID
     */
    public void setSettlementId(Long settlementId) {
        this.settlementId = settlementId;
    }
    /**
     * 来源主键ID
     */
    public Long getSourceId() {
        return sourceId;
    }

    /**
     * 来源主键ID
     */
    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    /**
     * 来源明细主键ID
     */
    public Long getSourceDetailId() {
        return sourceDetailId;
    }

    /**
     * 来源明细主键ID
     */
    public void setSourceDetailId(Long sourceDetailId) {
        this.sourceDetailId = sourceDetailId;
    }
    /**
     * 来源类型名称(对账—100231)
     */
    public String getSourceName() {
        return sourceName;
    }

    /**
     * 来源类型名称(对账—100231)
     */
    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }
    /**
     * 来源编码
     */
    public String getSourceCode() {
        return sourceCode;
    }

    /**
     * 来源编码
     */
    public void setSourceCode(String sourceCode) {
        this.sourceCode = sourceCode;
    }
    /**
     * 物资类别
     */
    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    /**
     * 物资类别
     */
    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }
    /**
     * 物资类别名称
     */
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    /**
     * 物资类别名称
     */
    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    /**
     * 物资主键
     */
    public Long getMaterialId() {
        return materialId;
    }

    /**
     * 物资主键
     */
    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    /**
     * 物资名称
     */
    public String getMaterialName() {
        return materialName;
    }

    /**
     * 物资名称
     */
    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    /**
     * 物资编码
     */
    public String getMaterialCode() {
        return materialCode;
    }

    /**
     * 物资编码
     */
    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    /**
     * 规格型号
     */
    public String getSpec() {
        return spec;
    }

    /**
     * 规格型号
     */
    public void setSpec(String spec) {
        this.spec = spec;
    }
    /**
     * 单位
     */
    public String getUnit() {
        return unit;
    }

    /**
     * 单位
     */
    public void setUnit(String unit) {
        this.unit = unit;
    }
    /**
     * 单位id
     */
    public Long getUnitId() {
        return unitId;
    }

    /**
     * 单位id
     */
    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }

    public BigDecimal getOverageSettleTaxMny() {
        return overageSettleTaxMny;
    }

    public void setOverageSettleTaxMny(BigDecimal overageSettleTaxMny) {
        this.overageSettleTaxMny = overageSettleTaxMny;
    }

    /**
     * 结算单价(无税)
     */
    public BigDecimal getPrice() {
        return price;
    }

    /**
     * 结算单价(无税)
     */
    public void setPrice(BigDecimal price) {
        this.price = price;
    }
    /**
     * 结算单价)
     */
    public BigDecimal getTaxPrice() {
        return taxPrice;
    }

    /**
     * 结算单价)
     */
    public void setTaxPrice(BigDecimal taxPrice) {
        this.taxPrice = taxPrice;
    }
    /**
     * 结算金额(无税)
     */
    public BigDecimal getMny() {
        return mny;
    }

    /**
     * 结算金额(无税)
     */
    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }
    /**
     * 结算金额
     */
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    /**
     * 结算金额
     */
    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    /**
     * 税率
     */
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    /**
     * 税率
     */
    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    /**
     * 税额
     */
    public BigDecimal getTax() {
        return tax;
    }

    /**
     * 税额
     */
    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    
}
