package com.ejianc.business.consts;

import java.util.HashMap;
import java.util.Map;

/**
 * @author jiangyikai
 * @version 1.0
 * @description: 固定资产跳转连接
 * @date 2022/7/19
 */
public enum SourceQueryTypeUrlEnum {




    设备验收("0", "/purchaseAcceptance/purchaseAcceptanceCard","设备验收"),
    固定资产("1", "/asset/assetCard","固定资产"),
    设备调出("2", "/assetAllotOut/assetAllotOutCard","设备调出"),
    设备调入("3", "/assetAllotIn/assetAllotInCard","设备调入"),
    设备报废("4", "/assetScrap/card","设备报废"),
    设备处置("5", "/handle/handleCard","设备处置");




    private String type;
    private String name;
    private String url;


    private static Map<String, SourceQueryTypeUrlEnum> enumMap = new HashMap();

    static {
        for (SourceQueryTypeUrlEnum urlEnum : SourceQueryTypeUrlEnum.values()) {
            enumMap.put(urlEnum.getType(), urlEnum);
        }
    }

    public static String getUrl(String type) {
        SourceQueryTypeUrlEnum supplyQueryTypeUrlEnum = enumMap.get(type);
        return supplyQueryTypeUrlEnum != null ? supplyQueryTypeUrlEnum.getUrl() : null;
    }
    public static String getName(String type) {
        SourceQueryTypeUrlEnum supplyQueryTypeUrlEnum = enumMap.get(type);
        return supplyQueryTypeUrlEnum != null ? supplyQueryTypeUrlEnum.getName() : null;
    }

    SourceQueryTypeUrlEnum(String type, String url,String name) {
        this.type = type;
        this.url = url;
        this.name = name;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }


    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
