package com.ejianc.business.asset.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.business.consts.AssetRecordTypeEnum;
import com.ejianc.business.decorator.IAssetRecord;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.ejianc.business.asset.vo.AssetAllotOutDetailVO;

/**
 * 固定资产调出表
 * 
 * @author generator
 * 
 */
@ApiModel("固定资产调出表")
public class AssetAllotOutVO extends BaseVO implements IAssetRecord {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("单据编码")
    private String billCode;
    @ApiModelProperty("单据状态")
    private Integer billState;
    @ApiModelProperty("调出范围 1-项目，2-组织")
    private Integer allocatRange;
    @ApiModelProperty("调出项目id")
    private Long projectId;
    @ApiModelProperty("调出项目名称")
    private String projectName;
    @ApiModelProperty("调出组织id")
    private Long orgId;
    @ApiModelProperty("调出组织编码")
    private String orgCode;
    @ApiModelProperty("调出组织名称")
    private String orgName;
    @ApiModelProperty("项目部上级组织Id")
    private Long parentOrgId;
    @ApiModelProperty("项目部上级组织名称")
    private String parentOrgName;
    @ApiModelProperty("项目部上级组织编码")
    private String parentOrgCode;
    @ApiModelProperty("调出的时间")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date outDate;
    @ApiModelProperty("调出金额")
    private BigDecimal outMny;
    @ApiModelProperty("调出金额(有税)")
    private BigDecimal outTaxMny;
    @ApiModelProperty("调拨方式 1 资产盘活 2 自制")
    private Integer allocatType;
    @ApiModelProperty("经办人id")
    private Long employeeId;
    @ApiModelProperty("经办人")
    private String employeeName;
    @ApiModelProperty("经办人部门id")
    private Long departmentId;
    @ApiModelProperty("经办人部门")
    private String departmentName;
    @ApiModelProperty("调入范围 1-项目，2-组织")
    private Integer inAllocatRange;
    @ApiModelProperty("调入项目id")
    private Long inProjectId;
    @ApiModelProperty("调入项目名称")
    private String inProjectName;
    @ApiModelProperty("调入组织id")
    private Long inOrgId;
    @ApiModelProperty("调入组织编码")
    private String inOrgCode;
    @ApiModelProperty("调入组织名称")
    private String inOrgName;
    @ApiModelProperty("调入项目部上级组织Id")
    private Long inParentOrgId;
    @ApiModelProperty("调入项目部上级组织名称")
    private String inParentOrgName;
    @ApiModelProperty("调入项目部上级组织编码")
    private String inParentOrgCode;
    @ApiModelProperty("出库物资名称集合")
    private String equipmentNames;
    @ApiModelProperty("通知收料状人id")
    private Long receiverId;
    @ApiModelProperty("通知收料状人")
    private String receiverName;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("调入组织退回原因")
    private String returnReason;
    @ApiModelProperty("收料状态 1、待收；2、已收；3、退回")
    private Integer receiveState;
    @ApiModelProperty("收料人id")
    private Long receiverPersonId;
    @ApiModelProperty("收料人")
    private String receiverPerson;
    @ApiModelProperty("收料时间")
    private Date receiveDate;
    @ApiModelProperty("关联状态")
    private String relationFlag;
    @ApiModelProperty("分摊状态")
    private String proportionFlag;
    @ApiModelProperty("调拨差额合计")
    private BigDecimal sumAllocatDiffMny;
    @ApiModelProperty("调拨差额合计(无税)")
    private BigDecimal sumAllocatDiffTaxMny;

    @ApiModelProperty("固定资产调出明细表")
    private List<AssetAllotOutDetailVO> assetAllotOutDetailList = new ArrayList<>();

    //单据状态名称
    private String billStateName;
    //收料状态名称
    private String receiveStateName;
    //调拨方式名称
    private String allocatTypeName;

    /**
     * 单据编码
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编码
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 调出范围 1-项目，2-组织
     */
    public Integer getAllocatRange() {
        return allocatRange;
    }

    /**
     * 调出范围 1-项目，2-组织
     */
    public void setAllocatRange(Integer allocatRange) {
        this.allocatRange = allocatRange;
    }
    /**
     * 调出项目id
     */
    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 调出项目id
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 调出项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 调出项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 调出组织id
     */
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 调出组织id
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 调出组织编码
     */
    public String getOrgCode() {
        return orgCode;
    }

    /**
     * 调出组织编码
     */
    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    /**
     * 调出组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 调出组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目部上级组织Id
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 项目部上级组织Id
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 项目部上级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 项目部上级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 项目部上级组织编码
     */
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    /**
     * 项目部上级组织编码
     */
    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    /**
     * 调出的时间
     */
    public Date getOutDate() {
        return outDate;
    }

    /**
     * 调出的时间
     */
    public void setOutDate(Date outDate) {
        this.outDate = outDate;
    }
    /**
     * 调出金额
     */
    public BigDecimal getOutMny() {
        return outMny;
    }

    /**
     * 调出金额
     */
    public void setOutMny(BigDecimal outMny) {
        this.outMny = outMny;
    }
    /**
     * 调出金额(有税)
     */
    public BigDecimal getOutTaxMny() {
        return outTaxMny;
    }

    /**
     * 调出金额(有税)
     */
    public void setOutTaxMny(BigDecimal outTaxMny) {
        this.outTaxMny = outTaxMny;
    }
    /**
     * 调拨方式 1 资产盘活 2 自制
     */
    public Integer getAllocatType() {
        return allocatType;
    }

    /**
     * 调拨方式 1 资产盘活 2 自制
     */
    public void setAllocatType(Integer allocatType) {
        this.allocatType = allocatType;
    }
    /**
     * 经办人id
     */
    @ReferSerialTransfer(referCode="idm-user")
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人id
     */
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 经办人部门id
     */
    public Long getDepartmentId() {
        return departmentId;
    }

    /**
     * 经办人部门id
     */
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    /**
     * 经办人部门
     */
    public String getDepartmentName() {
        return departmentName;
    }

    /**
     * 经办人部门
     */
    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    /**
     * 调入范围 1-项目，2-组织
     */
    public Integer getInAllocatRange() {
        return inAllocatRange;
    }

    /**
     * 调入范围 1-项目，2-组织
     */
    public void setInAllocatRange(Integer inAllocatRange) {
        this.inAllocatRange = inAllocatRange;
    }
    /**
     * 调入项目id
     */
    @ReferSerialTransfer(referCode = "project-set")
    public Long getInProjectId() {
        return inProjectId;
    }

    /**
     * 调入项目id
     */
    @ReferDeserialTransfer
    public void setInProjectId(Long inProjectId) {
        this.inProjectId = inProjectId;
    }
    /**
     * 调入项目名称
     */
    public String getInProjectName() {
        return inProjectName;
    }

    /**
     * 调入项目名称
     */
    public void setInProjectName(String inProjectName) {
        this.inProjectName = inProjectName;
    }
    /**
     * 调入组织id
     */
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getInOrgId() {
        return inOrgId;
    }

    /**
     * 调入组织id
     */
    @ReferDeserialTransfer
    public void setInOrgId(Long inOrgId) {
        this.inOrgId = inOrgId;
    }
    /**
     * 调入组织编码
     */
    public String getInOrgCode() {
        return inOrgCode;
    }

    /**
     * 调入组织编码
     */
    public void setInOrgCode(String inOrgCode) {
        this.inOrgCode = inOrgCode;
    }
    /**
     * 调入组织名称
     */
    public String getInOrgName() {
        return inOrgName;
    }

    /**
     * 调入组织名称
     */
    public void setInOrgName(String inOrgName) {
        this.inOrgName = inOrgName;
    }
    /**
     * 调入项目部上级组织Id
     */
    public Long getInParentOrgId() {
        return inParentOrgId;
    }

    /**
     * 调入项目部上级组织Id
     */
    public void setInParentOrgId(Long inParentOrgId) {
        this.inParentOrgId = inParentOrgId;
    }
    /**
     * 调入项目部上级组织名称
     */
    public String getInParentOrgName() {
        return inParentOrgName;
    }

    /**
     * 调入项目部上级组织名称
     */
    public void setInParentOrgName(String inParentOrgName) {
        this.inParentOrgName = inParentOrgName;
    }
    /**
     * 调入项目部上级组织编码
     */
    public String getInParentOrgCode() {
        return inParentOrgCode;
    }

    /**
     * 调入项目部上级组织编码
     */
    public void setInParentOrgCode(String inParentOrgCode) {
        this.inParentOrgCode = inParentOrgCode;
    }
    /**
     * 出库物资名称集合
     */
    public String getEquipmentNames() {
        return equipmentNames;
    }

    /**
     * 出库物资名称集合
     */
    public void setEquipmentNames(String equipmentNames) {
        this.equipmentNames = equipmentNames;
    }
    /**
     * 通知收料状人id
     */
    @ReferSerialTransfer(referCode="idm-user")
    public Long getReceiverId() {
        return receiverId;
    }

    /**
     * 通知收料状人id
     */
    @ReferDeserialTransfer
    public void setReceiverId(Long receiverId) {
        this.receiverId = receiverId;
    }
    /**
     * 通知收料状人
     */
    public String getReceiverName() {
        return receiverName;
    }

    /**
     * 通知收料状人
     */
    public void setReceiverName(String receiverName) {
        this.receiverName = receiverName;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 调入组织退回原因
     */
    public String getReturnReason() {
        return returnReason;
    }

    /**
     * 调入组织退回原因
     */
    public void setReturnReason(String returnReason) {
        this.returnReason = returnReason;
    }
    /**
     * 收料状态 1、待收；2、已收；3、退回
     */
    public Integer getReceiveState() {
        return receiveState;
    }

    /**
     * 收料状态 1、待收；2、已收；3、退回
     */
    public void setReceiveState(Integer receiveState) {
        this.receiveState = receiveState;
    }
    /**
     * 收料人id
     */
    public Long getReceiverPersonId() {
        return receiverPersonId;
    }

    /**
     * 收料人id
     */
    public void setReceiverPersonId(Long receiverPersonId) {
        this.receiverPersonId = receiverPersonId;
    }
    /**
     * 收料人
     */
    public String getReceiverPerson() {
        return receiverPerson;
    }

    /**
     * 收料人
     */
    public void setReceiverPerson(String receiverPerson) {
        this.receiverPerson = receiverPerson;
    }
    /**
     * 收料时间
     */
    public Date getReceiveDate() {
        return receiveDate;
    }

    /**
     * 收料时间
     */
    public void setReceiveDate(Date receiveDate) {
        this.receiveDate = receiveDate;
    }
    /**
     * 关联状态
     */
    public String getRelationFlag() {
        return relationFlag;
    }

    /**
     * 关联状态
     */
    public void setRelationFlag(String relationFlag) {
        this.relationFlag = relationFlag;
    }
    /**
     * 分摊状态
     */
    public String getProportionFlag() {
        return proportionFlag;
    }

    /**
     * 分摊状态
     */
    public void setProportionFlag(String proportionFlag) {
        this.proportionFlag = proportionFlag;
    }
    /**
     * 调拨差额合计
     */
    public BigDecimal getSumAllocatDiffMny() {
        return sumAllocatDiffMny;
    }

    /**
     * 调拨差额合计
     */
    public void setSumAllocatDiffMny(BigDecimal sumAllocatDiffMny) {
        this.sumAllocatDiffMny = sumAllocatDiffMny;
    }
    /**
     * 调拨差额合计(无税)
     */
    public BigDecimal getSumAllocatDiffTaxMny() {
        return sumAllocatDiffTaxMny;
    }

    /**
     * 调拨差额合计(无税)
     */
    public void setSumAllocatDiffTaxMny(BigDecimal sumAllocatDiffTaxMny) {
        this.sumAllocatDiffTaxMny = sumAllocatDiffTaxMny;
    }
    
     /**
      * 固定资产调出明细表
      */
      public List<AssetAllotOutDetailVO> getAssetAllotOutDetailList() {
         return assetAllotOutDetailList;
      }
     /**
      * 固定资产调出明细表
      */
     public void setAssetAllotOutDetailList(List<AssetAllotOutDetailVO> assetAllotOutDetailList) {
         this.assetAllotOutDetailList = assetAllotOutDetailList;
     }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getReceiveStateName() {
        return receiveStateName;
    }

    public void setReceiveStateName(String receiveStateName) {
        this.receiveStateName = receiveStateName;
    }

    public String getAllocatTypeName() {
        return allocatTypeName;
    }

    public void setAllocatTypeName(String allocatTypeName) {
        this.allocatTypeName = allocatTypeName;
    }

    @Override
    public List<AssetRecordVO> toRecordList() {
        List<AssetAllotOutDetailVO> allotOutDetailList = this.getAssetAllotOutDetailList();
        ArrayList<AssetRecordVO> assetRecordVOS = new ArrayList<>();
        for (AssetAllotOutDetailVO assetAllotOutDetailVO : allotOutDetailList) {
            AssetRecordVO recordVO = BeanMapper.map(assetAllotOutDetailVO, AssetRecordVO.class);
            recordVO.setId(null);
            recordVO.setVersion(null);
            recordVO.setBillDate(new Date());
            recordVO.setSourceId(this.getId());
            recordVO.setSourceBillCode(this.getBillCode());
            recordVO.setSourceDetailId(assetAllotOutDetailVO.getId());
            recordVO.setSourceType(AssetRecordTypeEnum.调出.getCode());
            recordVO.setSourceTypeName(AssetRecordTypeEnum.调出.getName());
            recordVO.setOrgId(this.getOrgId());
            recordVO.setOrgName(this.getOrgName());
            recordVO.setOrgCode(this.getOrgCode());
            recordVO.setParentOrgId(this.getParentOrgId());
            recordVO.setParentOrgName(this.getParentOrgName());
            recordVO.setParentOrgCode(this.getParentOrgCode());
            recordVO.setProjectId(assetAllotOutDetailVO.getUseUnitId());
            recordVO.setProjectName(assetAllotOutDetailVO.getUseUnit());
            assetRecordVOS.add(recordVO);
        }
        return assetRecordVOS;
    }
}
