package com.ejianc.business.purchaseplan.service.impl;

import com.ejianc.business.purchaseplan.bean.PurchasePlanDetailedEntity;
import com.ejianc.business.purchaseplan.bean.PurchasePlanEntity;
import com.ejianc.business.purchaseplan.mapper.PurchasePlanMapper;
import com.ejianc.business.purchaseplan.service.IPurchasePlanDetailedService;
import com.ejianc.business.purchaseplan.service.IPurchasePlanService;
import com.ejianc.business.purchaseplan.vo.PurchasePlanVO;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 购置计划表
 *
 * @author generator
 */
@Service("purchasePlanService")
public class PurchasePlanServiceImpl extends BaseServiceImpl<PurchasePlanMapper, PurchasePlanEntity> implements IPurchasePlanService {
    @Autowired
    private IPurchasePlanDetailedService purchasePlanDetailedService;

    @Autowired
    private PurchasePlanMapper mapper;

    @Override
    public void saveOrUpdates(PurchasePlanEntity entity) {
        this.saveOrUpdate(entity, false);
        if(CollectionUtil.isNotEmpty(entity.getDetailList())){
            saveOrUpdateChild(entity);
        }
    }

    @Override
    public List<PurchasePlanVO> queryPlanList() {
        List<PurchasePlanVO> list = mapper.queryList();
        return list;
    }

    @Transactional
    public void saveOrUpdateChild(PurchasePlanEntity entity) {
        List<PurchasePlanDetailedEntity> listbs = entity.getDetailList();
        Map<Long, Long> idMap = new HashMap<>();
        for (PurchasePlanDetailedEntity cdEntity : listbs) {
            if (cdEntity.getParentId() == 999L) {
                idMap.put(cdEntity.getDocCategoryId(), cdEntity.getId());
            }
        }
        for (PurchasePlanDetailedEntity cdEntity : listbs) {
            if (!cdEntity.getParentId().equals(999L)) {
                Long parentId = idMap.get(cdEntity.getDocCategoryId());
                cdEntity.setParentId(parentId != null ? parentId : entity.getProjectId());
                cdEntity.setTid(cdEntity.getId());

            } else {
                cdEntity.setTid(cdEntity.getId());
            }
        }
        purchasePlanDetailedService.saveOrUpdateBatch(listbs, listbs.size(), false);
    }

}
