package com.ejianc.business.acceptance.service.impl;

import com.ejianc.business.acceptance.bean.PurchaseAcceptanceEntity;
import com.ejianc.business.acceptance.bean.PurchaseAcceptanceSubEntity;
import com.ejianc.business.acceptance.service.IPurchaseAcceptanceService;
import com.ejianc.business.acceptance.service.IPurchaseAcceptanceSubService;
import com.ejianc.business.purchase.bean.EquipmentDetailedEntity;
import com.ejianc.business.purchase.bean.PurchaseContractEntity;
import com.ejianc.business.purchase.service.IEquipmentDetailedService;
import com.ejianc.business.purchase.service.IPurchaseContractService;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.Date;
import java.util.List;

@Service("purchaseAcceptance") 
public class PurchaseAcceptanceBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private SessionManager sessionManager;
	@Autowired
	private IPurchaseAcceptanceService service;
	@Autowired
	private IPurchaseContractService contractService;
	@Autowired
	private IEquipmentDetailedService equipmentDetailedService;
	@Autowired
	private IPurchaseAcceptanceSubService subService;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		PurchaseAcceptanceEntity e = service.selectById(billId);
		QueryParam params = new QueryParam();
		params.getParams().put("pid",new Parameter(QueryParam.EQ,billId));
		List<PurchaseAcceptanceSubEntity> subEntityList = subService.queryList(params);
		PurchaseAcceptanceSubEntity subEntity = subEntityList.get(0);
		UserContext userContext = sessionManager.getUserContext();
		PurchaseContractEntity contractEntity = contractService.selectById(e.getContractId());
		QueryParam param = new QueryParam();
		param.getParams().put("contractId",new Parameter(QueryParam.EQ,contractEntity.getId()));
		param.getParams().put("docCategoryId",new Parameter(QueryParam.EQ,subEntity.getEquipmentTypeId()));
		param.getParams().put("docId",new Parameter(QueryParam.EQ,subEntity.getEquipmentId()));
		List<EquipmentDetailedEntity> equipmentList = equipmentDetailedService.queryList(param);
		EquipmentDetailedEntity equipmentDetailedEntity = equipmentList.get(0);
		if(equipmentDetailedEntity.getAcceptanceQuantity() == null){
			equipmentDetailedEntity.setAcceptanceQuantity(1);
		}else{
			equipmentDetailedEntity.setAcceptanceQuantity(equipmentDetailedEntity.getAcceptanceQuantity()+1);
		}
		equipmentDetailedService.saveOrUpdate(equipmentDetailedEntity);
		return CommonResponse.success("使用记录审批回调处理成功！");
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
