package com.ejianc.business.purchase.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.api.ITemplateCategoryApi;
import com.ejianc.business.contractbase.vo.TemplateCategoryVO;
import com.ejianc.business.purchase.bean.EquipmentDetailedEntity;
import com.ejianc.business.purchase.bean.PurchaseContractEntity;
import com.ejianc.business.purchase.enums.PerformanceStatusEnum;
import com.ejianc.business.purchase.enums.SignatureStatusEnum;
import com.ejianc.business.purchase.service.IEquipmentDetailedService;
import com.ejianc.business.purchase.service.IPurchaseContractService;
import com.ejianc.business.purchase.vo.EquipmentDetailedVO;
import com.ejianc.business.purchase.vo.PurchaseContractVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 购置合同表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("purchaseContract")
public class PurchaseContractController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String PURCHASE_CONTRACT = "BT220323000000001";//此处需要根据实际修改

    @Autowired
    private IPurchaseContractService service;
    @Autowired
    private IEquipmentDetailedService equipmentDetailedService;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ITemplateCategoryApi templateCategoryApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PurchaseContractVO> saveOrUpdate(@RequestBody PurchaseContractVO saveOrUpdateVO, HttpServletRequest req) {
        String authority = req.getHeader("authority");
        PurchaseContractVO vo = service.insertOrUpdate(saveOrUpdateVO, authority);
        return CommonResponse.success("保存成功！",vo);
    }


    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PurchaseContractVO> queryDetail(Long id) {
        PurchaseContractVO vo = service.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PurchaseContractVO> vos) {
        return service.deleteByIds(vos);
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("firstPartyName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("billCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
//        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
//        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
//        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
//            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
//        }else {//pc端查询
//        }
        orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
//            if(5 == org.getOrgType()) {
//                //项目部
//                departmentIds.add(org.getId());
//            } else {
//                //普通组织
//            }
            commonOrgIds.add(org.getId());
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
            /** 要求主表有orgId字段，保存单据所属组织 */
//            param.getParams().put("projectCompanyId", new Parameter(QueryParam.IN, commonOrgIds));
        } else{
            JSONObject page = new JSONObject();
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            return CommonResponse.success("查询列表数据成功！",page);
        }

        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();

        //设置排序：为了保证主合同与补充协议排列在一起，先用主合同创建时间排序
        if(null != param.getOrderMap().get("createTime")) {
            orderMap.put("main_contract_create_date", param.getOrderMap().get("createTime"));
        }else {
            orderMap.put("main_contract_create_date", QueryParam.DESC);
        }
        orderMap.put("supplement_flag", QueryParam.ASC);
        orderMap.put("create_time", QueryParam.DESC);

        param.setOrderMap(orderMap);
        IPage<PurchaseContractEntity> pageData= service.queryPage(param,false);

        //页面统计，查询原合同金额，现合同金额
        Map<String, Object> contractAmountMap = service.countContractAmount(param);
        JSONObject page = new JSONObject();
        page.put("records", BeanMapper.mapList(pageData.getRecords(), PurchaseContractVO.class));
        page.put("total", pageData.getTotal());
        page.put("current", pageData.getCurrent());
        page.put("size", pageData.getSize());
        page.put("pages", pageData.getPages());
        page.put("sumMnyMap", contractAmountMap);
        return CommonResponse.success("查询列表数据成功！",page);
    }

    /**
     * 查询当前合同下补充协议信息
     * @param id
     * @return
     */
    @RequestMapping(value = "/querySupplementRecord", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PurchaseContractVO> querySupplementRecord(Long id) {
        PurchaseContractVO vo = service.querySupplementRecord(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * 新增或者修改补充协议
     *
     * @param supplement
     * @return
     */
    @RequestMapping(value = "/saveOrUpdateSupplement", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PurchaseContractVO> saveOrUpdateSupplement(@RequestBody PurchaseContractVO supplement) {
        if (supplement.getMainContractId() == null) {
            return CommonResponse.error("保存失败，主合同信息为空！");
        }
        PurchaseContractVO vo = service.saveOrUpdateSupplement(supplement);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Author
     * @Description  新增根据合同主键查询补充协议需要的主合同字段
     * @param contractId
     * @Return
     */
    @RequestMapping(value = "/addConvertByConId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PurchaseContractVO> addConvertByConId(Long contractId) {
        PurchaseContractVO vo = service.addConvertByConId(contractId);
        return CommonResponse.success("新增转换数据成功！",vo);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    /**
     * @Author
     * @Description  判断当前合同是否能新增补充协议
     * @param
     * @Return
     * @return
     */
    @RequestMapping(value = "/addSupplementFlag", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> addSupplementFlag(Long id) {
        Boolean flag = service.addSupplementFlag(id);
        if (flag){
            return CommonResponse.success("校验通过，该合同可以新增补充协议！");
        }
        return CommonResponse.error("当前合同存在未生效的补充协议，不能新增！");
    }

    /**
     * 签章流程
     * @param
     * @return
     */
    @RequestMapping(value = "/signatureProcess", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> signatureProcess(Long id) {
        /*
            后期修改：签章流程暂定为点击就改为已签章
         */
        PurchaseContractEntity contractEntity = service.selectById(id);
        if (contractEntity != null){
            contractEntity.setSignatureStatus(SignatureStatusEnum.已签章.getCode());
//            contractEntity.setContractPerformanceState(PerformanceStatusEnum.履约中.getCode());
            contractEntity.setEffectiveDate(new Date());
            service.saveOrUpdate(contractEntity);
        }
        return CommonResponse.success();
    }

    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        Map<String, Object> beans = new HashMap<>();
        param.setPageSize(-1);
        CommonResponse<JSONObject> commonResponse = queryList(param);
        List<PurchaseContractVO> contractVOList = new ArrayList<>();
        if (null != commonResponse.getData()){
            contractVOList = (List<PurchaseContractVO>) commonResponse.getData().get("records");
            if (null != contractVOList && contractVOList.size() > 0){
                contractVOList.forEach(vo -> {
                    if(org.apache.commons.lang.StringUtils.isBlank(vo.getContractPerformanceState().toString())) {
                        vo.setContractPerformanceState(PerformanceStatusEnum.未签订.getDescription());
                    } else {
                        vo.setContractPerformanceState(PerformanceStatusEnum.getEnumByCode(vo.getContractPerformanceState().toString()).getDescription());
                    }

                    if(org.apache.commons.lang.StringUtils.isBlank(vo.getSignatureStatus())) {
                        vo.setSignatureStatus(SignatureStatusEnum.未签章.getDescription());
                    } else {
                        vo.setSignatureStatus(SignatureStatusEnum.getEnumByCode(vo.getSignatureStatus()).getDescription());
                    }

                    vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
                });
            }
        }
        beans.put("records", contractVOList);
        ExcelExport.getInstance().export("purchaseContract-export.xlsx", beans, response);
    }


    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refPurchaseContractData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PurchaseContractVO>> refPurchaseContractData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        Long projectId = 538790177993801780L;
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            projectId = _con.getLong("projectId");
        }
        if(projectId != null){
            param.getParams().put("projectId",new Parameter(QueryParam.EQ,projectId));
        }else{
            throw new BusinessException("请选择项目");
        }

        List<Integer> list = new ArrayList();
        list.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        list.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        param.getParams().put("billState",new Parameter(QueryParam.IN,list));
        param.getParams().put("signatureStatus",new Parameter(QueryParam.EQ,SignatureStatusEnum.已签章.getCode()));
        param.getParams().put("contractPerformanceState",new Parameter(QueryParam.EQ,PerformanceStatusEnum.履约中.getCode()));
        IPage<PurchaseContractEntity> page = service.queryPage(param,false);
        IPage<PurchaseContractVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PurchaseContractVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refEquipmentDetailedData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<EquipmentDetailedVO>> refEquipmentDetailedData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                               String condition,
                                                                               String searchObject,
                                                                               String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        Long contractId = null;
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            contractId = _con.getLong("cId");
        }
        if(contractId != null){
            param.getParams().put("contractId",new Parameter(QueryParam.EQ,contractId));
        }else{
            throw new BusinessException("请选择合同");
        }
        IPage<EquipmentDetailedEntity> page = equipmentDetailedService.queryPage(param,false);
        IPage<EquipmentDetailedVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<EquipmentDetailedVO> list = BeanMapper.mapList(page.getRecords(), EquipmentDetailedVO.class);
        List<EquipmentDetailedVO> newList = new ArrayList<>();
        if(CollectionUtil.isNotEmpty(list)){
            for(EquipmentDetailedVO vo : list){
                if (vo.getAcceptanceQuantity() == null || vo.getAcceptanceQuantity() == 0) {
                    vo.setAcceptanceQuantity(0);
                    vo.setSurplusNum(vo.getPurchaseNum().intValue());
                    newList.add(vo);
                }else{
                    int num = vo.getPurchaseNum().intValue() - vo.getAcceptanceQuantity();
                    if (num > 0) {
                        vo.setSurplusNum(num);
                        newList.add(vo);
                    }
                }
            }
        }
        pageData.setRecords(newList);


        return CommonResponse.success("查询参照数据成功！",pageData);
    }

    /**
     * 根据合同Id查询合同文件管理信息
     *
     * @param contractId 合同Id
     * @return
     */
    @GetMapping(value = "/getContractFileMgrInfo")
    @ResponseBody
    public CommonResponse<JSONObject> getContractFileMgrInfo(@RequestParam(value = "contractId") Long contractId) {
        JSONObject resp = new JSONObject();
        PurchaseContractEntity contractEntity = service.selectById(contractId);
        CommonResponse<TemplateCategoryVO> categoryResp = templateCategoryApi.queryTmplCategoryById(contractEntity.getContractCategoryId());
        if(!categoryResp.isSuccess()) {
            logger.error("根据合同类别I的-{}查询对应合同类别信息失败, 原因：{}", contractEntity.getContractCategoryId(), categoryResp.getMsg());
            return CommonResponse.error("查询合同类别信息失败");
        }
        TemplateCategoryVO category = categoryResp.getData();
        resp.put("contactId", contractEntity.getId());
        resp.put("contractBillTypeCode", PURCHASE_CONTRACT);
        resp.put("contractCategoryId", category.getId());
        resp.put("boBillType", category.getBillTypeCode());

        return CommonResponse.success("查询成功！", resp);
    }
}
