/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.purchaseplan.service.impl;

import com.ejianc.business.purchaseplan.bean.PurchasePlanDetailedEntity;
import com.ejianc.business.purchaseplan.bean.PurchasePlanEntity;
import com.ejianc.business.purchaseplan.mapper.PurchasePlanMapper;
import com.ejianc.business.purchaseplan.service.IPurchasePlanDetailedService;
import com.ejianc.business.purchaseplan.service.IPurchasePlanService;
import com.ejianc.business.purchaseplan.vo.PurchasePlanVO;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="purchasePlanService")
public class PurchasePlanServiceImpl
extends BaseServiceImpl<PurchasePlanMapper, PurchasePlanEntity>
implements IPurchasePlanService {
    @Autowired
    private IPurchasePlanDetailedService purchasePlanDetailedService;
    @Autowired
    private PurchasePlanMapper mapper;

    @Override
    public void saveOrUpdates(PurchasePlanEntity entity) {
        this.saveOrUpdate((Object)entity, false);
        if (CollectionUtil.isNotEmpty(entity.getDetailList())) {
            this.saveOrUpdateChild(entity);
        }
    }

    @Override
    public List<PurchasePlanVO> queryPlanList(Long projectId) {
        List<PurchasePlanVO> list = this.mapper.queryList(projectId);
        return list;
    }

    @Transactional
    public void saveOrUpdateChild(PurchasePlanEntity entity) {
        List<PurchasePlanDetailedEntity> listbs = entity.getDetailList();
        HashMap<Long, Long> idMap = new HashMap<Long, Long>();
        for (PurchasePlanDetailedEntity cdEntity : listbs) {
            if (cdEntity.getParentId() != 999L) continue;
            idMap.put(cdEntity.getDocCategoryId(), cdEntity.getId());
        }
        for (PurchasePlanDetailedEntity cdEntity : listbs) {
            if (!cdEntity.getParentId().equals(999L)) {
                Long parentId = (Long)idMap.get(cdEntity.getDocCategoryId());
                cdEntity.setParentId(parentId != null ? parentId : entity.getProjectId());
                cdEntity.setTid(cdEntity.getId());
                continue;
            }
            cdEntity.setTid(cdEntity.getId());
        }
        this.purchasePlanDetailedService.saveOrUpdateBatch(listbs, listbs.size(), false);
    }
}

