package com.ejianc.business.purchase.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 签章状态
 */
public enum PerformanceStatusEnum {
    /**
     * 合同履约状态：1、未签订；
     */
    未签订("1", "未签订"),

    /**
     * 合同履约状态：2、履约中；
     */
    履约中("2", "履约中"),

    /**
     * 合同履约状态：3、已封账；
     */
    已封账("3", "已封账"),

    /**
     * 合同履约状态：4、已解除；
     */
    已解除("4", "已解除"),
    /**
     * 合同履约状态
     */
    已冻结("5", "已冻结");



    private String code;
    private String description;
    private static Map<String, PerformanceStatusEnum> enumMap = new HashMap<>();

    PerformanceStatusEnum(String code, String description) {
        this.code = code;
        this.description = description;
    }

    public String getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

    static {
        enumMap = EnumSet.allOf(PerformanceStatusEnum.class).stream().collect(Collectors.toMap(PerformanceStatusEnum::getCode, Function.identity(), (k1, k2) -> k2));
    }

    public static PerformanceStatusEnum getEnumByCode(String billStateCode) {
        return enumMap.get(billStateCode);
    }
}
