/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.settlement.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.purchase.bean.PurchaseContractEntity;
import com.ejianc.business.purchase.service.IPurchaseContractService;
import com.ejianc.business.settlement.bean.PurchaseSettlementEntity;
import com.ejianc.business.settlement.service.IPurchaseSettlementService;
import com.ejianc.business.settlement.vo.PurchaseSettlementVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="purchaseSettlement")
public class PurchaseSettlementBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IBillTypeApi billTypeApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPurchaseContractService contractService;
    @Autowired
    private IPurchaseSettlementService service;
    private static final String BILL_TYPE = "EJCBT202204000000007";
    @Value(value="${common.env.base-host}")
    private String BaseHost;
    @Autowired
    private IExecutionApi executionApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        boolean pool;
        this.logger.info("\u5ba1\u6279\u901a\u8fc7\u4e1a\u52a1\u5f00\u59cb\uff01");
        PurchaseSettlementEntity entity = (PurchaseSettlementEntity)((Object)this.service.selectById(billId));
        PurchaseSettlementVO settlementVO = (PurchaseSettlementVO)BeanMapper.map((Object)((Object)entity), PurchaseSettlementVO.class);
        if (entity.getContractId() != null && entity.getSignatureType() == 1) {
            PurchaseContractEntity contractEntity = (PurchaseContractEntity)((Object)this.contractService.selectById(entity.getContractId()));
            contractEntity.setContractPerformanceState("3");
            this.contractService.saveOrUpdate((Object)contractEntity);
            this.logger.info("\u4fee\u6539\u5408\u540c\u72b6\u6001\uff01" + JSONObject.toJSONString((Object)((Object)contractEntity)));
        }
        if (!(pool = this.service.pushSettleToPool(settlementVO))) {
            throw new BusinessException("\u63a8\u9001\u4f9b\u65b9\u5931\u8d25");
        }
        this.service.updateById((Object)entity);
        return CommonResponse.success((String)"\u5ba1\u6279\u901a\u8fc7\u903b\u8f91\u64cd\u4f5c\u5b8c\u6210");
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        PurchaseSettlementEntity entity = (PurchaseSettlementEntity)((Object)this.service.selectById(billId));
        if (entity.getSignStatus() == 1) {
            throw new BusinessException("\u5df2\u7b7e\u5b57\u4e0d\u80fd\u64a4\u56de\uff01");
        }
        if (entity.getContractId() != null) {
            LambdaQueryWrapper lambda = new LambdaQueryWrapper();
            lambda.eq(PurchaseSettlementEntity::getContractId, (Object)entity.getContractId());
            lambda.eq(PurchaseSettlementEntity::getSettlementType, (Object)entity.getSettlementType());
            lambda.orderByDesc(BaseEntity::getCreateTime);
            List list = this.service.list((Wrapper)lambda);
            PurchaseSettlementEntity settlementEntity = (PurchaseSettlementEntity)((Object)list.get(0));
            if (!entity.getId().equals(settlementEntity.getId())) {
                throw new BusinessException("\u53ea\u80fd\u64a4\u56de\u6700\u65b0\u7684\u7ed3\u7b97\u5355\uff01");
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        boolean pool;
        PurchaseSettlementEntity entity = (PurchaseSettlementEntity)((Object)this.service.selectById(billId));
        if (entity.getContractId() != null && entity.getSignatureType() == 1) {
            PurchaseContractEntity contractEntity = (PurchaseContractEntity)((Object)this.contractService.selectById(entity.getContractId()));
            contractEntity.setContractPerformanceState("2");
            this.contractService.saveOrUpdate((Object)contractEntity);
            this.logger.info("\u4fee\u6539\u5408\u540c\u72b6\u6001\uff01" + JSONObject.toJSONString((Object)((Object)contractEntity)));
        }
        if (!(pool = this.service.delSettleFromPool(billId))) {
            throw new BusinessException("\u5f03\u5ba1\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25\uff01");
        }
        return CommonResponse.success();
    }
}

