package com.ejianc.business.purchase.service.impl;

import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.purchase.mapper.PurchaseContractRelieveMapper;
import com.ejianc.business.purchase.bean.PurchaseContractRelieveEntity;
import com.ejianc.business.purchase.service.IPurchaseContractRelieveService;

import java.util.List;

/**
 * 购置合同-合同解除表
 * 
 * @author generator
 * 
 */
@Service("purchaseContractRelieveService")
public class PurchaseContractRelieveServiceImpl extends BaseServiceImpl<PurchaseContractRelieveMapper, PurchaseContractRelieveEntity> implements IPurchaseContractRelieveService{

    @Autowired
    private IPurchaseContractRelieveService service;

    /**
     * 根据合同编号查询是否可以新增合同解除单据
     *
     * @param contractId 合同id
     * @return Boolean 是否可以新增
     */
    @Override
    public Boolean isCanRelieve(Long contractId) {
        // 添加校验
        QueryParam param = new QueryParam();
        param.getParams().put("contract_id", new Parameter(QueryParam.EQ, contractId));
        List<PurchaseContractRelieveEntity> list = service.queryList(param);
        return list.isEmpty();
    }
}
