package com.ejianc.business.purchaseplan.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.purchaseplan.bean.PurchasePlanDetailedEntity;
import com.ejianc.business.purchaseplan.bean.PurchasePlanEntity;
import com.ejianc.business.purchaseplan.mapper.PurchasePlanMapper;
import com.ejianc.business.purchaseplan.service.IPurchasePlanDetailedService;
import com.ejianc.business.purchaseplan.service.IPurchasePlanService;
import com.ejianc.business.purchaseplan.vo.PurchasePlanVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.ibatis.annotations.Param;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 购置计划表
 *
 * @author generator
 */
@Service("purchasePlanService")
public class PurchasePlanServiceImpl extends BaseServiceImpl<PurchasePlanMapper, PurchasePlanEntity> implements IPurchasePlanService {
    @Autowired
    private IPurchasePlanDetailedService purchasePlanDetailedService;

    @Autowired
    private PurchasePlanMapper mapper;

    @Override
    public void saveOrUpdates(PurchasePlanEntity entity) {
        this.saveOrUpdate(entity, false);
        if(CollectionUtil.isNotEmpty(entity.getDetailList())){
            saveOrUpdateChild(entity);
        }
    }

    @Override
    public List<PurchasePlanVO> queryPlanList(Long projectId) {
        List<PurchasePlanVO> list = mapper.queryList(projectId);
        return list;
    }

    @Transactional
    public void saveOrUpdateChild(PurchasePlanEntity entity) {
        List<PurchasePlanDetailedEntity> listbs = entity.getDetailList();
        Map<Long, Long> idMap = new HashMap<>();
        for (PurchasePlanDetailedEntity cdEntity : listbs) {
            if (cdEntity.getParentId() == 999L) {
                idMap.put(cdEntity.getDocCategoryId(), cdEntity.getId());
            }
        }
        for (PurchasePlanDetailedEntity cdEntity : listbs) {
            if (!cdEntity.getParentId().equals(999L)) {
                Long parentId = idMap.get(cdEntity.getDocCategoryId());
                cdEntity.setParentId(parentId != null ? parentId : entity.getProjectId());
                cdEntity.setTid(cdEntity.getId());

            } else {
                cdEntity.setTid(cdEntity.getId());
            }
        }
        purchasePlanDetailedService.saveOrUpdateBatch(listbs, listbs.size(), false);
    }
    /**
     * 检查单据是否存在相同编码
     * @param contractVO
     * @return
     */
    public Boolean checkSameBillCode(PurchasePlanVO contractVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper<PurchasePlanEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(PurchasePlanEntity::getBillCode, contractVO.getBillCode());
        lambda.eq(PurchasePlanEntity::getTenantId, tenantId);
        if (null != contractVO.getId() && contractVO.getId() > 0) {
            lambda.ne(PurchasePlanEntity::getId, contractVO.getId());
        }
        return super.list(lambda).size() > 0;
    }

}
