package com.ejianc.business.acceptance.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.acceptance.vo.PurchaseAcceptanceVO;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.acceptance.mapper.PurchaseAcceptanceMapper;
import com.ejianc.business.acceptance.bean.PurchaseAcceptanceEntity;
import com.ejianc.business.acceptance.service.IPurchaseAcceptanceService;

import java.util.List;

/**
 * 购置验收表
 * 
 * @author generator
 * 
 */
@Service("purchaseAcceptanceService")
public class PurchaseAcceptanceServiceImpl extends BaseServiceImpl<PurchaseAcceptanceMapper, PurchaseAcceptanceEntity> implements IPurchaseAcceptanceService{

    @Override
    public IPage<PurchaseAcceptanceVO> refPurchaseAcceptanceData(QueryParam param, Long contractId, Integer pageNumber, Integer pageSize) {
        IPage<PurchaseAcceptanceVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        List<PurchaseAcceptanceVO> list = baseMapper.refPurchaseAcceptanceData(changeToQueryWrapper(param),contractId, page);
        IPage<PurchaseAcceptanceVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(list);
        return pageData;
    }
}
