/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.settlement.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.contractbase.pool.enums.SettleSourceTypeEnum;
import com.ejianc.business.contractbase.pool.settlepool.api.ISettlePoolApi;
import com.ejianc.business.contractbase.pool.settlepool.vo.SettlePoolVO;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.purchase.bean.EquipmentDetailedEntity;
import com.ejianc.business.purchase.bean.PurchaseContractEntity;
import com.ejianc.business.purchase.enums.ChangeTypeEnum;
import com.ejianc.business.purchase.service.IPurchaseContractService;
import com.ejianc.business.settlement.bean.PurchaseSettlementDetailEntity;
import com.ejianc.business.settlement.bean.PurchaseSettlementEntity;
import com.ejianc.business.settlement.mapper.PurchaseSettlementMapper;
import com.ejianc.business.settlement.service.IPurchaseSettlementService;
import com.ejianc.business.settlement.vo.BillPushStatusEnum;
import com.ejianc.business.settlement.vo.PurchaseSettlementVO;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import redis.clients.jedis.JedisPool;

@Service(value="purchaseSettlementService")
public class PurchaseSettlementServiceImpl
extends BaseServiceImpl<PurchaseSettlementMapper, PurchaseSettlementEntity>
implements IPurchaseSettlementService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPurchaseContractService contractService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    private static final String CHECK_PARAM_CODE = "P-ogZh3516";
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IPurchaseSettlementService settlementService;
    @Autowired
    private ISettlePoolApi settlePoolApi;
    private static final String BILL_CODE = "EQUIPMENTPJS-CODE";
    private static final String BILL_TYPE = "EJCBT202204000012";

    @Override
    public CommonResponse<PurchaseSettlementVO> saveOrUpdate(PurchaseSettlementVO saveOrUpdateVO) {
        PurchaseSettlementEntity entity = (PurchaseSettlementEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, PurchaseSettlementEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            if (null != entity.getContractId() && this.queryExist(entity.getContractId())) {
                throw new BusinessException("\u8be5\u5408\u540c\u4e0b\u6709\u672a\u751f\u6548\u7684\u7ed3\u7b97\u5355\uff01");
            }
            entity.setSignStatus(0);
            entity.setSignatureStatus(0);
            entity.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
        }
        if (entity.getContractId() != null) {
            PurchaseContractEntity contractEntity = (PurchaseContractEntity)((Object)this.contractService.selectById(entity.getContractId()));
            List<EquipmentDetailedEntity> contractDetailList = contractEntity.getDetailList();
            List collect = contractDetailList.stream().filter(t -> t.getDocCategoryId() != null && !ChangeTypeEnum.\u4e2d\u6b62.toString().equals(t.getChangeType())).map(EquipmentDetailedEntity::getDocCategoryId).collect(Collectors.toList());
            for (PurchaseSettlementDetailEntity detail : entity.getPurchaseSettlementDetailList()) {
                if (collect.contains(detail.getMaterialTypeId())) continue;
                throw new BusinessException("\u6750\u6599\u3010" + detail.getMaterialName() + "\u3011\u5728\u5408\u540c\u3010" + entity.getContractName() + "\u3011\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u53d8\u66f4\u5408\u540c\u540e\u518d\u7ed3\u7b97");
            }
        }
        super.saveOrUpdate((Object)entity, false);
        PurchaseSettlementVO vo = (PurchaseSettlementVO)BeanMapper.map((Object)((Object)entity), PurchaseSettlementVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    public boolean queryExist(Long contractId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(PurchaseSettlementEntity::getContractId, (Object)contractId);
        wrapper.notIn(PurchaseSettlementEntity::getBillState, new Object[]{1, 3});
        List list = super.list((Wrapper)wrapper);
        return CollectionUtils.isNotEmpty((Collection)list);
    }

    @Override
    public CommonResponse<Map> getDateMny(Long contractId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        BigDecimal currentTaxMny = BigDecimal.ZERO;
        BigDecimal currentMny = BigDecimal.ZERO;
        String sTDate = null;
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        wrapper.in(PurchaseSettlementEntity::getBillState, new Object[]{1, 3});
        wrapper.eq(BaseEntity::getDr, (Object)0);
        wrapper.eq(PurchaseSettlementEntity::getContractId, (Object)contractId);
        List list = super.list((Wrapper)wrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            PurchaseSettlementEntity purchaseSettlementEntity = (PurchaseSettlementEntity)((Object)list.get(0));
            currentTaxMny = purchaseSettlementEntity.getCurrentSettlementTaxMny() == null ? BigDecimal.ZERO : purchaseSettlementEntity.getCurrentSettlementTaxMny();
            currentMny = purchaseSettlementEntity.getCurrentSettlementMny() == null ? BigDecimal.ZERO : purchaseSettlementEntity.getCurrentSettlementMny();
            sTDate = DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)purchaseSettlementEntity.getSettlementDate());
        }
        map.put("currentTaxMny", currentTaxMny);
        map.put("currentMny", currentMny);
        map.put("sTDate", sTDate);
        return CommonResponse.success((String)"\u83b7\u53d6\u91d1\u989d\u548c\u65f6\u95f4\u6210\u529f\uff01", map);
    }

    @Override
    public CommonResponse<String> delete(List<PurchaseSettlementVO> vos) {
        PurchaseSettlementEntity PurchaseSettlementEntity2 = (PurchaseSettlementEntity)((Object)super.selectById((Serializable)vos.get(0).getId()));
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @Override
    public boolean pushSettleToPool(PurchaseSettlementVO vo) {
        SettlePoolVO spv = new SettlePoolVO();
        boolean flag = false;
        try {
            this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u81ea\u52a8\u8f6c\u6362\u5f00\u59cb-----" + JSONObject.toJSONString((Object)vo));
            BeanConvertorUtil.convert((Object)vo, (Object)spv);
            this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u81ea\u52a8\u8f6c\u6362\u7ed3\u675f\uff0c\u4e0b\u9762\u5f00\u59cb\u624b\u52a8\u8f6c\u6362");
            this.convertSettleVOToSettlePoolVO(vo, spv);
            spv.setBillCodeUrl("/ejc-proequipmentp-frontend/#/settlementList/settlementCard?id=" + vo.getId());
            this.logger.info("\u63a8\u9001\u53c2\u6570----" + JSONObject.toJSONString((Object)spv));
            CommonResponse res = this.settlePoolApi.saveOrUpdateSettle(spv);
            this.logger.info("\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u7ed3\u675f---" + JSONObject.toJSONString((Object)res));
            if (!res.isSuccess()) {
                this.logger.error("\u7ed3\u7b97\u5355\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff01\u7ed3\u7b97\u5355id-{}\uff0c{}", (Object)vo.getId(), (Object)res.getMsg());
                throw new BusinessException("\u7ed3\u7b97\u5355\u5f03\u5ba1\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25!");
            }
            flag = true;
            this.logger.info("\u7ed3\u7b97\u5355\u63a8\u9001\u5408\u540c\u6c60\u6210\u529f---{}", (Object)res.getMsg());
        }
        catch (Exception e) {
            this.logger.error("\u7ed3\u7b97\u5355\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff01\u7ed3\u7b97\u5355id-{}", (Object)vo.getId(), (Object)e);
            throw new BusinessException("\u7ed3\u7b97\u5355\u63a8\u9001\u5408\u540c\u6c60\u5f02\u5e38!");
        }
        return flag;
    }

    @Override
    public boolean delSettleFromPool(Long id) {
        SettlePoolVO spv = new SettlePoolVO();
        boolean flag = false;
        spv.setSourceId(id);
        try {
            this.logger.info("\u7ed3\u7b97\u5355\u5f03\u5ba1\u63a8\u9001\u7ed3\u7b97\u6c60\u5f00\u59cb,\u7ed3\u7b97\u5355id-{}", (Object)id);
            CommonResponse res = this.settlePoolApi.deleteSettle(spv);
            this.logger.info("\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u7ed3\u675f---" + JSONObject.toJSONString((Object)res));
            if (!res.isSuccess()) {
                this.logger.error("\u7ed3\u7b97\u5355\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff01\u7ed3\u7b97\u5355id-{}\uff0c{}", (Object)id, (Object)res.getMsg());
                throw new BusinessException("\u7ed3\u7b97\u5355\u5f03\u5ba1\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25!");
            }
            flag = true;
            this.logger.info("\u7ed3\u7b97\u5355\u5f03\u5ba1\u63a8\u9001\u5408\u540c\u6c60\u6210\u529f---{}", (Object)res.getMsg());
        }
        catch (Exception e) {
            this.logger.error("\u7ed3\u7b97\u5355\u5f03\u5ba1\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff01\u7ed3\u7b97\u5355id-{}", (Object)id, (Object)e);
            throw new BusinessException("\u7ed3\u7b97\u5355\u5f03\u5ba1\u63a8\u9001\u5408\u540c\u6c60\u5f02\u5e38!");
        }
        return flag;
    }

    private void convertSettleVOToSettlePoolVO(PurchaseSettlementVO vo, SettlePoolVO spv) {
        if (null == vo || null == spv) {
            this.logger.error("\u5c06\u7ed3\u7b97\u5355\u63a8\u9001\u81f3\u7ed3\u7b97\u6c60\u5931\u8d25\uff01\u539f\u56e0\uff1a\u7ed3\u7b97\u5355\u5bf9\u8c61\u4e3a\u7a7a\u6216\u7ed3\u7b97\u6c60\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u65e0\u6cd5\u8f6c\u6362\uff01");
            return;
        }
        this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u624b\u52a8\u8f6c\u6362\u5f00\u59cb");
        switch (vo.getBillState()) {
            case 0: {
                spv.setBillStateName("\u81ea\u7531\u6001");
                break;
            }
            case 1: {
                spv.setBillStateName("\u5df2\u63d0\u4ea4");
                break;
            }
            case 3: {
                spv.setBillStateName("\u5ba1\u6279\u901a\u8fc7");
                break;
            }
            case 4: {
                spv.setBillStateName("\u5ba1\u6279\u9a73\u56de");
                break;
            }
            default: {
                spv.setBillStateName("\u5ba1\u6279\u4e2d");
            }
        }
        spv.setId(vo.getId());
        spv.setSourceType(SettleSourceTypeEnum.\u8bbe\u5907\u91c7\u8d2d\u7ed3\u7b97.getCode());
        spv.setSettlePropertyName("\u652f\u51fa");
        spv.setSettleProperty(Integer.valueOf(0));
        spv.setSourceId(vo.getId());
        spv.setCreateUserCode(vo.getCreateUserCode());
        spv.setCreateTime(vo.getCreateTime());
        spv.setUpdateUserCode(vo.getUpdateUserCode());
        spv.setUpdateTime(vo.getUpdateTime());
        if (vo.getContractId() != null) {
            PurchaseContractEntity contractEntity = (PurchaseContractEntity)((Object)this.contractService.selectById(vo.getContractId()));
            spv.setContractType("purchaseContract");
            spv.setSupplementFlag(contractEntity.getSupplementFlag());
            spv.setMaiContractId(contractEntity.getMainContractId());
            spv.setMaiContractName(contractEntity.getMainContractName());
            spv.setMaiContractCode(contractEntity.getMainContractCode());
            spv.setContractCode(contractEntity.getBillCode());
            spv.setPartyaId(contractEntity.getFirstPartyId());
            spv.setPartyaName(contractEntity.getFirstPartyName());
            spv.setSignDate(contractEntity.getSignDate());
            BigDecimal lastTaxMny = BigDecimal.ZERO;
            BigDecimal lastMny = BigDecimal.ZERO;
            BigDecimal lastTax = BigDecimal.ZERO;
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.orderByDesc(BaseEntity::getCreateTime);
            wrapper.in(PurchaseSettlementEntity::getBillState, new Object[]{1, 3});
            wrapper.eq(BaseEntity::getDr, (Object)0);
            wrapper.eq(PurchaseSettlementEntity::getContractId, (Object)vo.getContractId());
            wrapper.ne(BaseEntity::getId, (Object)vo.getId());
            List list = super.list((Wrapper)wrapper);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                for (PurchaseSettlementEntity purchaseSettlementEntity : list) {
                    BigDecimal settTaxMny = purchaseSettlementEntity.getSettlementTaxMny() == null ? BigDecimal.ZERO : purchaseSettlementEntity.getSettlementTaxMny();
                    BigDecimal settMny = purchaseSettlementEntity.getSettlementMny() == null ? BigDecimal.ZERO : purchaseSettlementEntity.getSettlementMny();
                    BigDecimal settTax = purchaseSettlementEntity.getSettlementTax() == null ? BigDecimal.ZERO : purchaseSettlementEntity.getSettlementTax();
                    lastTaxMny = lastTaxMny.add(settTaxMny);
                    lastMny = lastMny.add(settMny);
                    lastTax = lastTax.add(settTax);
                }
            }
            spv.setLastTaxMny(lastTaxMny);
            spv.setLastMny(lastMny);
            spv.setLastTax(lastTax);
        }
        this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u624b\u52a8\u8f6c\u6362\u5b8c\u6210\uff0c\u4e0b\u9762\u5f00\u59cb\u63a8\u9001\u81f3\u7ed3\u7b97\u6c60");
    }

    private BigDecimal getSubStractAbs(BigDecimal a, BigDecimal b) {
        if (a == null || b == null) {
            return null;
        }
        BigDecimal subtract = a.subtract(b);
        if (subtract == null) {
            return null;
        }
        return subtract.abs();
    }

    @Override
    public ParamsCheckVO checkParams(Integer purchaseType, BigDecimal contractTaxMny, BigDecimal settleTaxMny, BigDecimal totalSettleTaxMny) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
        CommonResponse billParamByCode = this.paramConfigApi.getBillParamByCode(CHECK_PARAM_CODE);
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            BillParamVO billParamVO = (BillParamVO)billParamByCode.getData();
            BigDecimal roleValue = billParamVO.getRoleValue();
            BigDecimal comMny = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)contractTaxMny, (BigDecimal)roleValue), (BigDecimal)new BigDecimal("100")).setScale(2, 4);
            if (2 == purchaseType) {
                paramsCheckVO.setWarnType(paramsArray[0]);
                return paramsCheckVO;
            }
            paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
            if (totalSettleTaxMny.compareTo(comMny) > 0) {
                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                paramsCheckDsVO.setWarnItem("\u5408\u540c\u8d85\u7ed3");
                paramsCheckDsVO.setWarnName("\u7d2f\u8ba1\u7ed3\u7b97\u91d1\u989d\u5927\u4e8e\u5408\u540c\u91d1\u989d");
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\uff1a").append(settleTaxMny.toString()).append("\u5143\uff0c\u542b\u672c\u6b21\u7d2f\u8ba1\u7ed3\u7b97\u91d1\u989d\uff1a").append(totalSettleTaxMny).append("\u5143\uff0c\u5408\u540c\u91d1\u989d*").append(roleValue).append("%:").append(comMny).append("\u5143\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(ComputeUtil.safeSub((BigDecimal)totalSettleTaxMny, (BigDecimal)comMny)).append("\u5143");
                paramsCheckDsVO.setContent(stringBuffer.toString());
                checkDsVOS.add(paramsCheckDsVO);
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        paramsCheckVO.setDataSource(checkDsVOS);
        return paramsCheckVO;
    }
}

