package com.ejianc.business.purchase.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractPropertyEnum;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.purchase.bean.*;
import com.ejianc.business.purchase.enums.ChangeStatusEnum;
import com.ejianc.business.purchase.enums.DraftTypeEnum;
import com.ejianc.business.purchase.enums.PerformanceStatusEnum;
import com.ejianc.business.purchase.enums.SignatureStatusEnum;
import com.ejianc.business.purchase.mapper.PurchaseContractMapper;
import com.ejianc.business.purchase.service.IChangePurchaseContractService;
import com.ejianc.business.purchase.service.IPurchaseContractFreezeService;
import com.ejianc.business.purchase.service.IPurchaseContractRelieveService;
import com.ejianc.business.purchase.service.IPurchaseContractService;
import com.ejianc.business.purchase.vo.EquipmentDetailedVO;
import com.ejianc.business.purchase.vo.PurchaseContractVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.vo.DetailExecutionVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.business.tender.api.ITenderSubApi;
import com.ejianc.business.vo.util.TreeNodeBUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 购置合同表
 *
 * @author generator
 */
@Service("purchaseContractService")
public class PurchaseContractServiceImpl extends BaseServiceImpl<PurchaseContractMapper, PurchaseContractEntity> implements IPurchaseContractService {

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private ITenderSubApi tenderApi;
    //定标结果未占用状态
    int unOccupyState = 0;
    //定标结果已占用状态
    int occupyState = 1;
    private static final String BILL_TYPE = "BT220323000000001";//合同单据编码

    private static final String CHANGE_BILL_TYPE = "BT220323000000002";//变更合同单据编码

    private static final String BILL_CODE = "PURCBASE_CONTRACT";//此处需要根据实际修改

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IPurchaseContractService service;

    @Autowired
    private IChangePurchaseContractService changeService;

    @Autowired
    private IPurchaseContractRelieveService relieveService;

    @Autowired
    private IPurchaseContractFreezeService freezeService;


    @Value("${common.env.base-host}")
    private String BaseHost;

    @Autowired
    private IContractPoolApi contractPoolApi;

    @Autowired
    private IExecutionApi executionApi;

    @Autowired
    private IShareMaterialApi materialApi;

    private static final String linkUrl = "/ejc-proequipmentp-frontend/#/machineryPurchaseContract/card?id=";//此处需要根据实际修改
    private static final String changeLinkUrl = "ejc-proequipmentp-frontend/#/machineryPurchaseContract/contractChangeCard?id=";//此处需要根据实际修改


    /**
     * 新增或者修改合同
     *
     * @param contractVO
     * @return
     */
    @Override
    public PurchaseContractVO insertOrUpdate(PurchaseContractVO contractVO, String authority, Boolean isControl) {
        PurchaseContractEntity entity = BeanMapper.map(contractVO, PurchaseContractEntity.class);
        // parentOrgCode如果是空的，则需要查询赋值
        if (StringUtils.isEmpty(entity.getParentOrgCode()) && entity.getParentOrgId() != null) {
            CommonResponse<OrgVO> orgResponse = iOrgApi.getOneById(entity.getParentOrgId());
            if (orgResponse.isSuccess()) {
                OrgVO orgVO = orgResponse.getData();
                entity.setParentOrgCode(orgVO.getCode());
                contractVO.setParentOrgCode(orgVO.getCode());
            }
        }
        if (!isControl) {
            if (entity.getId() == null) {
                if (StringUtils.isBlank(entity.getBillCode())) {
                    BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), contractVO);
                    CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                    if (!billCode.isSuccess()) {
                        logger.error("保存合同失败，自动生成合同合同失败: {}", billCode.getMsg());
                        throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                    }

                    entity.setBillCode(billCode.getData());
                }
                else {
                    //验证编码是否唯一
                    if (checkSameBillCode(BeanMapper.map(entity, PurchaseContractVO.class))) {
                        throw new BusinessException("编码重复，不允许保存!");
                    }
                }

                //设置合同初始状态
                entity.setSignatureStatus(SignatureStatusEnum.未签章.getCode());
                entity.setSupplementFlag(0);
                entity.setChangeStatus(ChangeStatusEnum.未变更.getCode());
                entity.setMainContractCreateDate(new Date());
                //回写定标结果占据状态
                tenderApi.updateById(entity.getTargetResultId(), occupyState);
            }
            else {
                //若定标结果更换则回写原来定标结果为为占用状态，新定标结果为占用状态
                PurchaseContractEntity oldPurchaseContractEntity = super.selectById(entity.getId());
                if (null != entity.getTargetResultId() && !entity.getTargetResultId().equals(oldPurchaseContractEntity.getTargetResultId())) {
                    tenderApi.updateById(oldPurchaseContractEntity.getTargetResultId(), unOccupyState);
                    tenderApi.updateById(entity.getTargetResultId(), occupyState);
                }
                if (StringUtils.isBlank(entity.getBillCode())) {
                    entity.setBillCode(oldPurchaseContractEntity.getBillCode());
                }
                else {
                    //验证编码是否唯一
                    if (checkSameBillCode(BeanMapper.map(entity, PurchaseContractVO.class))) {
                        throw new BusinessException("编码重复，不允许保存!");
                    }
                }
            }
        }
        //补充金额明细
        entity.setContractMny(contractVO.getContractMny() == null ? BigDecimal.ZERO : contractVO.getContractMny());
        entity.setContractTaxMny(contractVO.getContractTaxMny() == null ? BigDecimal.ZERO : contractVO.getContractTaxMny());
        entity.setContractTax(contractVO.getContractTax() == null ? BigDecimal.ZERO : contractVO.getContractTax());
        //分包明细
        entity.setEquipmentTaxMny(contractVO.getEquipmentTaxMny() == null ? BigDecimal.ZERO : contractVO.getEquipmentTaxMny());
        entity.setEquipmentMny(contractVO.getEquipmentMny() == null ? BigDecimal.ZERO : contractVO.getEquipmentMny());
        entity.setEquipmentTax(contractVO.getEquipmentTax() == null ? BigDecimal.ZERO : contractVO.getEquipmentTax());
        //其他费用
        entity.setOtherTaxMny(contractVO.getOtherTaxMny() == null ? BigDecimal.ZERO : contractVO.getOtherTaxMny());
        entity.setOtherMny(contractVO.getOtherMny() == null ? BigDecimal.ZERO : contractVO.getOtherMny());
        entity.setOtherTax(contractVO.getOtherTax() == null ? BigDecimal.ZERO : contractVO.getOtherTax());
        //设置初始金额
        entity.setBaseMny(entity.getContractMny() == null ? BigDecimal.ZERO : entity.getContractMny());
        entity.setBaseTaxMny(entity.getContractTaxMny() == null ? BigDecimal.ZERO : entity.getContractTaxMny());
        //设置变更前金额
        entity.setBeforeChangeMny(entity.getContractMny() == null ? BigDecimal.ZERO : entity.getContractMny());
        entity.setBeforeChangeTaxMny(entity.getContractTaxMny() == null ? BigDecimal.ZERO : entity.getContractTaxMny());

        if (entity.getContractFileId() != null) {
            if (entity.getId() != null) {
                PurchaseContractEntity contract = service.getById(entity.getId());
                //如果改合同上次修改的起草方式不是线上起草  且 这次改为线上起草，则删除附件
                if (contract != null && !DraftTypeEnum.线上起草.getCode().toString().equals(contract.getDraftType()) && DraftTypeEnum.线上起草.getCode().toString().equals(entity.getDraftType())) {
                    delContractFile(entity.getContractFileId(), authority);
                    entity.setContractFileId(null);
                    entity.setContractFilePath(null);
                }
            }
            else {
                //如果是新建合同，且起草方式为线上起草则删除附件
                if (DraftTypeEnum.线上起草.getCode().toString().equals(entity.getDraftType())) {
                    delContractFile(entity.getContractFileId(), authority);
                    entity.setContractFileId(null);
                    entity.setContractFilePath(null);
                }
            }
        }
        //将合同文件同步标识置为未同步
        if (DraftTypeEnum.线上起草.getCode().toString().equals(entity.getDraftType()) || DraftTypeEnum.线上起草不使用电子签章.getCode().toString().equals(entity.getDraftType())) {
            entity.setContractFileSyncFlag(false);
        }


        //设置项目部id和项目部上级组织id
//        if (null != entity.getOrgId()){
//            CommonResponse<OrgVO> orgResp = iOrgApi.getOneById(entity.getOrgId());
//            if(!orgResp.isSuccess()) {
//                logger.error("保存合同失败，获取项目部id-{}信息失败，{}", entity.getOrgId(), orgResp.getMsg());
//                throw new BusinessException("保存失败，获取项目部信息失败！");
//            }
//            OrgVO orgVO = orgResp.getData();
//            if (null != orgVO && null != orgVO.getParentId()){
//                entity.setParentOrgId(orgVO.getParentId());
//                entity.setParentOrgName(orgVO.getpFName());
//                //获取父级orgCode
//                CommonResponse<OrgVO> parentOrgResp = iOrgApi.getOneById(orgVO.getParentId());
//                if(!parentOrgResp.isSuccess()) {
//                    logger.error("保存合同失败，获取项目部parentId-{}信息失败，{}", orgVO.getParentId(), parentOrgResp.getMsg());
//                    throw new BusinessException("保存失败，获取项目部父级信息失败！");
//                }
//                OrgVO parentOrgVO = parentOrgResp.getData();
//                if (null != parentOrgVO && null != parentOrgVO.getCode()){
//                    entity.setParentOrgCode(parentOrgVO.getCode());
//                }
//            }
//        }

        //保存前清空主键和父主键，重新生成
//        resetPid(entity.getDetailList());
        if (!isControl) {
            super.saveOrUpdate(entity, false);
            //目标成本推送
            ExecutionVO executionVO = service.targetCost(BeanMapper.map(entity, PurchaseContractVO.class), BILL_TYPE, linkUrl);
            logger.info("目标成本推送数据" + JSON.toJSONString(executionVO));
            CommonResponse<String> response = executionApi.aggPush(executionVO);
            if (!response.isSuccess()) {
                throw new BusinessException("目标成本推送失败," + response.getMsg());
            }
        }
        if (null == entity.getId() && isControl) {
            entity.setId(IdWorker.getId());
            return BeanMapper.map(entity, PurchaseContractVO.class);
        }
        return queryDetail(entity.getId());
    }

    @Override
    public ExecutionVO targetCost(PurchaseContractVO contractVO, String BillType, String linkUrl) {
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        List<DetailExecutionVO> detailList = new ArrayList<>();
        totalVO.setSourceId(contractVO.getId());
        totalVO.setTenantId(contractVO.getTenantId());
        totalVO.setBillCode(contractVO.getBillCode());
        totalVO.setBillType(BillType);
        totalVO.setBussinessType(BussinessTypeEnum.设备采购合同.getCode());
        totalVO.setBillCategory(BillCategoryEnum.合同.getCode());
        totalVO.setProjectId(contractVO.getProjectId());
        totalVO.setOrgId(contractVO.getOrgId());
        totalVO.setMoney(contractVO.getContractMny());
        totalVO.setTaxMoney(contractVO.getContractTaxMny());
        totalVO.setLinkUrl(BaseHost + linkUrl + contractVO.getId());
        List contractDetailList;
        if (BillType.equals(BILL_TYPE)) {
            contractDetailList = contractVO.getDetailList();
        }
        else {
            contractDetailList = changeService.queryDetail(contractVO.getId()).getDetailList();
        }
        if (contractDetailList != null) {
            for (EquipmentDetailedVO planDetailVO : contractVO.getDetailList()) {
                DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                detailExecutionVO.setSourceId(planDetailVO.getId());
                detailExecutionVO.setSourceBillId(planDetailVO.getContractId());
                detailExecutionVO.setCategoryId(planDetailVO.getDocCategoryId());
                detailExecutionVO.setCategoryName(planDetailVO.getEquipmentType());
                //判断是否是分类
                if (planDetailVO.getDocId() == null) {
                    detailExecutionVO.setCategoryFlag(true);
                    detailExecutionVO.setDocId(planDetailVO.getDocCategoryId());
                }
                else {
                    detailExecutionVO.setCategoryFlag(false);
                    detailExecutionVO.setDocId(planDetailVO.getDocId());
                }
                detailExecutionVO.setCode(planDetailVO.getEquipmentCode());
                detailExecutionVO.setCategoryContainFlag(false);
                //根据分类ID查询物料分类信息
                MaterialCategoryVO categoryVO = materialApi.queryCategoryById(planDetailVO.getDocId()).getData();
                if (categoryVO == null) {
                    detailExecutionVO.setCategoryInnerCode(null);
                    detailExecutionVO.setCategoryCode(null);
                }
                else {
                    detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                    detailExecutionVO.setCategoryCode(categoryVO.getCode());
                }
                detailExecutionVO.setDocType(DocTypeEnum.设备档案.getCode());
                detailExecutionVO.setName(planDetailVO.getEquipmentName());
//                detailExecutionVO.setUnitId(planDetailVO.getUnitId());
                detailExecutionVO.setUnitName(planDetailVO.getCompany());
                detailExecutionVO.setNum(BigDecimal.valueOf(planDetailVO.getPurchaseNum()));
                detailExecutionVO.setMoney(planDetailVO.getPurchaseAmountNoTax());
                detailExecutionVO.setSpec(planDetailVO.getSpec());
                detailExecutionVO.setTaxMoney(planDetailVO.getEstimateAmortizeMny());
                detailExecutionVO.setPrice(planDetailVO.getPurchasePricetNoTax());
                detailExecutionVO.setTaxPrice(planDetailVO.getPurchasePrice());
                detailExecutionVO.setTaxRate(planDetailVO.getTaxRate());
                detailList.add(detailExecutionVO);
            }
        }
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }

    @Override
    public void pushContract(PurchaseContractVO contractVO) {
        ContractPoolVO data = new ContractPoolVO();
        try {
            BeanConvertorUtil.convert(contractVO, data);
            data.setPcCardUrl(linkUrl + contractVO.getId());
            data.setSourceType(ContractTypeEnum.设备采购.getTypeCode());

//            data.setPcCardUrl("/ejc-proequipmentp-frontend/#/machineryPurchaseContract/contractApprove?id="
//                    + contractVO.getId() + "&supplementFlag=" + contractVO.getSupplementFlag()
//                    + "&targetType=" + contractVO.getTargetResultId() + "&performanceStatus="
//                    + contractVO.getContractPerformanceState());
            data.setContractProperty(ContractPropertyEnum.支出合同.getPropertyCode());
            logger.info("开始推送合同池>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            logger.info("推送数据：{}", JSONObject.toJSONString(data));
            CommonResponse<ContractPoolVO> transDataResp = contractPoolApi.saveOrUpdateContract(data);
            logger.info("推送合同池结束，推送结果：{}<<<<<<<<<<<<<<<<<<<<<<<<<<<<<", transDataResp.isSuccess());
            if (!transDataResp.isSuccess()) {
                logger.error("合同id-{}推送合同池失败，{}", contractVO.getId(), transDataResp.getMsg());
            }
        } catch (Exception e) {
            logger.error("合同-{}推送合同池失败，", contractVO.getId(), e);
        }
    }

    @Override
    public Boolean delContractFile(Long fileId, String authority) {
        Map<String, Object> params = new HashMap<>();
        Map<String, String> header = new HashMap<>();
        params.put("ids", fileId.toString());
        header.put("authority", authority);

        String delRespStr = null;
        try {
            delRespStr = HttpTookit.get(BaseHost + "ejc-file-web/attachment/delete", params, header, 10000, 10000);
        } catch (Exception e) {
            e.printStackTrace();
        }
        CommonResponse<String> delResp = JSONObject.parseObject(delRespStr, CommonResponse.class);
        if (delResp != null) {
            logger.info("在线起草，删除上传合同返回信息：" + delResp.getMsg());
        }
        return true;
    }

    private void resetPid(List<EquipmentDetailedEntity> detailList) {
        if (CollectionUtils.isNotEmpty(detailList)) {
            Map<String, Long> idMap = new HashMap<>();
            for (EquipmentDetailedEntity cdEntity : detailList) {
                if (cdEntity.getId() == null) {
                    cdEntity.setId(IdWorker.getId());
                }
                idMap.put(cdEntity.getDocId().toString(), cdEntity.getId());
                cdEntity.setParentId(null);
            }
            for (EquipmentDetailedEntity cdEntity : detailList) {
                if (StringUtils.isNotEmpty(cdEntity.getDocId().toString())) {
                    cdEntity.setParentId(idMap.get(cdEntity.getDocId()));
                }
            }
        }
    }

    /**
     * 查询合同详情
     *
     * @param id
     * @return
     */
    @Override
    public PurchaseContractVO queryDetail(Long id) {
        Map<String, LinkedHashMap<String, String>> orderMap = new HashMap<>();
        LinkedHashMap<String, String> orderParams = new LinkedHashMap<>();
        orderMap.put("detailList", orderParams);
        orderMap.put("otherCostList", orderParams);

        PurchaseContractEntity contractEntity = super.selectById(id, orderMap);
        PurchaseContractVO contractVO = BeanMapper.map(contractEntity, PurchaseContractVO.class);

        if (CollectionUtils.isNotEmpty(contractVO.getDetailList())) {
            contractVO.setDetailList(contractVO.getDetailList());
        }

        return contractVO;
    }

    /**
     * 查询当前合同下补充协议列表
     *
     * @param id
     * @return
     */
    @Override
    public PurchaseContractVO querySupplementRecord(Long id) {
        PurchaseContractEntity contractEntity = super.selectById(id);
        PurchaseContractVO contractVO = new PurchaseContractVO();

        BigDecimal contractTaxMny = contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny();

        contractVO.setId(id);
        contractVO.setContractTaxMny(contractTaxMny);
        contractVO.setChangeStatus(contractEntity.getChangeStatus());

        QueryWrapper<PurchaseContractEntity> query = new QueryWrapper<>();
        query.eq("main_contract_id", id);
        query.eq("contract_performance_state", PerformanceStatusEnum.履约中.getCode());
        query.orderByDesc("create_time");
        List<PurchaseContractEntity> supplementEntities = super.list(query);

        contractVO.setSupplementList(BeanMapper.mapList(supplementEntities, PurchaseContractVO.class));
        //补充协议次数
        contractVO.setSupplementNum(supplementEntities.size());
        //设置累计补充总金额
        BigDecimal allSupplementAmt = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(supplementEntities)) {
            for (PurchaseContractEntity c : supplementEntities) {
                if (c.getContractTaxMny() != null) {
                    allSupplementAmt = c.getContractTaxMny().add(allSupplementAmt);
                }
            }
        }
        contractVO.setAllSupplementMny(allSupplementAmt);
        //设置补充金额比例
        contractVO.setSupplementMnyRate(BigDecimal.ZERO.compareTo(contractTaxMny) != 0 ? (allSupplementAmt.divide(contractTaxMny, 8, BigDecimal.ROUND_HALF_UP)).multiply(new BigDecimal(100)) : BigDecimal.ZERO);

        //判断能否新增补充协议
        if (SignatureStatusEnum.已签章.getCode().equals(contractEntity.getSignatureStatus())
                && (BillStateEnum.PASSED_STATE.getBillStateCode().equals(contractEntity.getBillState()) || BillStateEnum.COMMITED_STATE.getBillStateCode().equals(contractEntity.getBillState()))
                && (!(PerformanceStatusEnum.已解除.getCode().equals(contractEntity.getContractPerformanceState()) || PerformanceStatusEnum.已冻结.getCode().equals(contractEntity.getContractPerformanceState()) || PerformanceStatusEnum.已封账.getCode().equals(contractEntity.getContractPerformanceState())))) {
            contractVO.setEditFlag(this.addSupplementFlag(id));
        }
        return contractVO;
    }

    /**
     * 判断当前合同是否能新增补充协议
     *
     * @param id
     * @return
     */
    @Override
    public Boolean addSupplementFlag(Long id) {
        /*
            一个主合同仅有一个未生效得补充协议
            单据生效： 当单据审批通过，且签章状态为已签章
         */
        LambdaQueryWrapper<PurchaseContractEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(PurchaseContractEntity::getMainContractId, id);
        lambda.eq(PurchaseContractEntity::getSupplementFlag, PurchaseContractVO.CONTRACT_TYPE_SUPPLEMENT);
        lambda.and(l -> l.ne(PurchaseContractEntity::getSignatureStatus, String.valueOf(SignatureStatusEnum.已签章.getCode())).or(c -> c.notIn(PurchaseContractEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode())).or(c -> c.eq(PurchaseContractEntity::getContractPerformanceState, String.valueOf(PerformanceStatusEnum.已解除.getCode()))));
        List<PurchaseContractEntity> supplementList = super.list(lambda);
        return supplementList.size() == 0;
    }

    /**
     * 新增或者修改补充协议
     *
     * @param contractVO
     * @return
     */
    @Override
    public PurchaseContractVO saveOrUpdateSupplement(PurchaseContractVO contractVO) {
        PurchaseContractEntity entity = null;
        // parentOrgCode如果是空的，则需要查询赋值
        if (StringUtils.isEmpty(contractVO.getParentOrgCode()) && contractVO.getParentOrgId() != null) {
            CommonResponse<OrgVO> orgResponse = iOrgApi.getOneById(contractVO.getParentOrgId());
            if (orgResponse.isSuccess()) {
                OrgVO orgVO = orgResponse.getData();
                contractVO.setParentOrgCode(orgVO.getCode());
            }
        }
        if (StringUtils.isNotBlank(contractVO.getBillCode()) && checkSameBillCode(contractVO)) {
            throw new BusinessException("编码重复，不允许保存!");
        }
        if (contractVO.getId() == null) {
            //新增补充协议
            //校验：补充协议只能存在一条未生效的
            QueryParam param = new QueryParam();
            param.getParams().put("main_contract_id", new Parameter("eq", contractVO.getMainContractId()));
            List<PurchaseContractEntity> supplementList = service.queryList(param, false);
            supplementList.stream().forEach(e -> {
                if (!(e.getSignatureStatus().equals(SignatureStatusEnum.已签章.getCode()) &&
                        (e.getBillState().equals(BillStateEnum.COMMITED_STATE.getBillStateCode())
                                || e.getBillState().equals(BillStateEnum.PASSED_STATE.getBillStateCode())))) {
                    //存在未生效的补充协议
                    throw new BusinessException("该合同已存在未生效的补充协议!");
                }
            });

            //设置补充协议编码
            String supplementNum = "";
            if (supplementList.size() < 9) {
                supplementNum += "0" + (supplementList.size() + 1);
            }
            else {
                supplementNum += (supplementList.size() + 1);
            }

            //主合同
            PurchaseContractEntity mainContract = service.selectById(contractVO.getMainContractId());
            if (null == mainContract) {
                throw new BusinessException("未找到主合同，不能创建补充协议！");
            }

            entity = BeanMapper.map(mainContract, PurchaseContractEntity.class);
            //清空基础字段
            clearBaseFields(entity);
            entity.setSignatureStatus(SignatureStatusEnum.未签章.getCode());
            entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            entity.setBillCode(entity.getBillCode() + "2" + supplementNum);

            //基本信息
            entity.setContractName(contractVO.getContractName());
            entity.setSignDate(contractVO.getSignDate());
            entity.setContractPerformanceState(contractVO.getContractPerformanceState());
            entity.setDraftType(contractVO.getDraftType());
            entity.setTaxRate(contractVO.getTaxRate());
            entity.setFirstPartyEmployeeId(contractVO.getFirstPartyEmployeeId());
            entity.setFirstPartyEmployee(contractVO.getFirstPartyEmployee());
            entity.setContractCode(contractVO.getContractCode());

            //设置文件路径
            entity.setContractFilePath(contractVO.getContractFilePath());
            entity.setContractFileId(contractVO.getContractFileId());

            entity.setContractTemplateId(contractVO.getContractTemplateId());
            entity.setContractTemplateName(contractVO.getContractTemplateName());
            entity.setContractFileVersionId(contractVO.getContractFileVersionId());
            entity.setContractFileVersion(contractVO.getContractFileVersion());
            entity.setSupplementDescribe(contractVO.getSupplementDescribe());

            entity.setContractMny(contractVO.getContractMny() == null ? BigDecimal.ZERO : contractVO.getContractMny());
            entity.setContractTaxMny(contractVO.getContractTaxMny() == null ? BigDecimal.ZERO : contractVO.getContractTaxMny());
            entity.setContractTax(contractVO.getContractTax() == null ? BigDecimal.ZERO : contractVO.getContractTax());

            entity.setEquipmentTaxMny(contractVO.getEquipmentTaxMny() == null ? BigDecimal.ZERO : contractVO.getEquipmentTaxMny());
            entity.setEquipmentMny(contractVO.getEquipmentMny() == null ? BigDecimal.ZERO : contractVO.getEquipmentMny());
            entity.setEquipmentTax(contractVO.getEquipmentTax() == null ? BigDecimal.ZERO : contractVO.getEquipmentTax());

            entity.setOtherMny(contractVO.getOtherMny() == null ? BigDecimal.ZERO : contractVO.getOtherMny());
            entity.setOtherTaxMny(contractVO.getOtherTaxMny() == null ? BigDecimal.ZERO : contractVO.getOtherTaxMny());
            entity.setOtherTax(contractVO.getOtherTax() == null ? BigDecimal.ZERO : contractVO.getOtherTax());

            entity.setDetailList(BeanMapper.mapList(contractVO.getDetailList(), EquipmentDetailedEntity.class));
            entity.setOtherCostList(BeanMapper.mapList(contractVO.getOtherCostList(), OtherDetailedEntity.class));
            entity.setClauseList(BeanMapper.mapList(contractVO.getClauseList(), PurchaseContractClauseEntity.class));
            entity.setPaymentList(BeanMapper.mapList(contractVO.getPaymentList(), PurchaseContractPaymentClauseEntity.class));

            //初始化变更字段
            entity.setChangingMny(null);
            entity.setChangeCode(null);
            entity.setChangeVersion(null);
            entity.setChangeId(null);
            entity.setChangeStatus(ChangeStatusEnum.未变更.getCode());

            //补充协议状态
            entity.setSupplementFlag(PurchaseContractVO.CONTRACT_TYPE_SUPPLEMENT);
            entity.setMainContractId(contractVO.getMainContractId());
            entity.setMainContractCode(contractVO.getMainContractCode());
            entity.setMainContractName(contractVO.getMainContractName());
        }
        else {
            entity = BeanMapper.map(contractVO, PurchaseContractEntity.class);
        }

        //设置初始金额
        entity.setBaseMny(entity.getContractMny());
        entity.setBaseTaxMny(entity.getContractTaxMny());
        //设置变更前金额
        entity.setBeforeChangeMny(entity.getContractMny());
        entity.setBeforeChangeTaxMny(entity.getContractTaxMny());
        //设置关联的附件Ids
        entity.setAttachIds(contractVO.getAttachIds());

        //保存前清空主键和父主键，重新生成
//        resetPid(entity.getDetailList());
        // 校验其他单据
        this.checkContract(entity.getMainContractId(), entity.getId());
        service.saveOrUpdate(entity, false);
        return queryDetail(entity.getId());
    }

    /**
     * 重置单据基础字段
     *
     * @param entity
     */
    private void clearBaseFields(PurchaseContractEntity entity) {
        entity.setId(null);
        entity.setCreateTime(null);
        entity.setCreateUserCode(null);
        entity.setUpdateTime(null);
        entity.setUpdateUserCode(null);
        entity.setCommitDate(null);
        entity.setCommitUserCode(null);
        entity.setCommitDate(null);
        entity.setCommitUserName(null);
        entity.setEffectiveDate(null);
    }

    /**
     * 查询补充协议代入的主合同信息
     *
     * @param contractId
     * @return
     */
    @Override
    public PurchaseContractVO addConvertByConId(Long contractId) {
        PurchaseContractEntity contractVO = super.selectById(contractId);
        PurchaseContractVO supplementVO = new PurchaseContractVO();
        supplementVO.setMainContractName(contractVO.getContractName());
        supplementVO.setMainContractCode(contractVO.getBillCode());
        supplementVO.setMainContractId(contractId);
        supplementVO.setSupplementFlag(PurchaseContractVO.CONTRACT_TYPE_SUPPLEMENT);
        supplementVO.setContractCategoryId(contractVO.getContractCategoryId());

        supplementVO.setProjectName(contractVO.getProjectName());
        supplementVO.setProjectId(contractVO.getProjectId());
        supplementVO.setFirstPartyId(contractVO.getFirstPartyId());
        supplementVO.setFirstPartyName(contractVO.getFirstPartyName());
        supplementVO.setSupplierId(contractVO.getSupplierId());
        supplementVO.setSupplierName(contractVO.getSupplierName());
        supplementVO.setOrgId(contractVO.getOrgId());
        supplementVO.setOrgName(contractVO.getOrgName());
        supplementVO.setParentOrgId(contractVO.getParentOrgId());
        supplementVO.setParentOrgName(contractVO.getParentOrgName());
        supplementVO.setParentOrgCode(contractVO.getParentOrgCode());
        supplementVO.setDraftType(DraftTypeEnum.上传合同.getCode().toString());
        supplementVO.setContractName(contractVO.getContractName() + "补充协议");

        return supplementVO;
    }

    /**
     * 计算合同列表需要字段
     *
     * @param param
     * @return
     */
    @Override
    public Map<String, Object> countContractAmount(QueryParam param) {
        Map<String, Object> resp = new HashMap<>();
        QueryWrapper wrapper = changeToQueryWrapper(param);
        wrapper.select("sum(base_tax_mny) as baseTaxMny, sum(contract_tax_mny) as contractTaxMny");
        resp = super.getMap(wrapper);
        if (null == resp) {
            resp = new HashMap<>();
            resp.put("baseTaxMny", 0);
            resp.put("contractTaxMny", 0);
        }
        return resp;

    }

    @Override
    public CommonResponse<String> deleteByIds(List<PurchaseContractVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            //目标成本推送
            List<TotalExecutionVO> totalExecutionVOList = new ArrayList<>();
            for (PurchaseContractVO contractVO : vos) {
                PurchaseContractEntity contractEntity = service.selectById(contractVO.getId());
                ExecutionVO executionVO = service.targetCost(BeanMapper.map(contractEntity, PurchaseContractVO.class), BILL_TYPE, linkUrl);
                totalExecutionVOList.add(executionVO.getTotalVO());
                logger.info("目标成本删除数据" + JSON.toJSONString(totalExecutionVOList));
                CommonResponse<String> response = executionApi.aggDel(totalExecutionVOList);
                if (!response.isSuccess()) {
                    throw new BusinessException("目标成本推送失败," + response.getMsg());
                }
            }
        }
        vos.forEach(contractVO -> {
            PurchaseContractEntity contractEntity = super.getById(contractVO.getId());
            if (null != contractEntity.getTargetResultId()) {
//                CommonResponse<String>  tender = tenderApi.updateById(contractEntity.getTargetResultId(), unOccupyState);
//                logger.info("定标结果占用状态修改为未占用状态信息：" + tender.getMsg());
            }
        });
        service.removeByIds(vos.stream().map(PurchaseContractVO::getId).collect(Collectors.toList()), false);
        return CommonResponse.success("删除成功！");
    }

    /**
     * 检查单据是否存在相同编码
     *
     * @param contractVO
     * @return
     */
    private Boolean checkSameBillCode(PurchaseContractVO contractVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper<PurchaseContractEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(PurchaseContractEntity::getBillCode, contractVO.getBillCode());
        lambda.eq(PurchaseContractEntity::getTenantId, tenantId);
        if (null != contractVO.getId() && contractVO.getId() > 0) {
            lambda.ne(PurchaseContractEntity::getId, contractVO.getId());
        }
        return super.list(lambda).size() > 0;
    }

    /**
     * 校验合同是否能做其他业务
     * 合同只能存在一个未生效的下游业务
     *
     * @param id      合同id
     * @param otherId 其他单据id
     */
    @Override
    public boolean checkContract(Long id, Long otherId) {
        List<Integer> billStateList = Arrays.asList(BillStateEnum.UNCOMMITED_STATE.getBillStateCode(),
                BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(),
                BillStateEnum.UNAPPROVED.getBillStateCode(),
                BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode());
        // 校验补充协议
        // 存在非审批通过或非签章通过的补充协议，不允许做其他业务
//        queryParam.getParams().put("supplementFlag", new Parameter(QueryParam.EQ, 1));
        QueryParam supplementQueryParam = new QueryParam();
        supplementQueryParam.getParams().put("mainContractId", new Parameter(QueryParam.EQ, id));
        if (otherId != null) {
            supplementQueryParam.getParams().put("id", new Parameter(QueryParam.NE, otherId));
        }
        supplementQueryParam.getParams().put("signatureStatus", new Parameter(QueryParam.NE, SignatureStatusEnum.已签章.getCode()));
        List<PurchaseContractEntity> supplementContractList = super.queryList(supplementQueryParam, false);
        // 存在未生效的补充协议，则抛出异常
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(supplementContractList)) {
            throw new BusinessException("存在未生效的补充协议！");
        }

        // 校验变更合同
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, id));
//        queryParam.getParams().put("billState", new Parameter(QueryParam.IN, billStateList));
        queryParam.getParams().put("signatureStatus", new Parameter(QueryParam.NE, SignatureStatusEnum.已签章.getCode()));
        // 做修改时，排除当前单据的id
        if (otherId != null) {
            queryParam.getParams().put("id", new Parameter(QueryParam.NE, otherId));
        }
        List<ChangePurchaseContractEntity> contractChangeEntityList = changeService.queryList(queryParam, false);
        // 存在未生效的变更合同，则抛出异常
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(contractChangeEntityList)) {
            throw new BusinessException("存在未生效的变更合同！");
        }

        // 查询合同解除
        List<PurchaseContractRelieveEntity> relieveEntityList = relieveService.queryList(queryParam, false);
        // 存在未生效的合同解除，则抛出异常
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(relieveEntityList)) {
            throw new BusinessException("存在未生效的合同解除单据！");
        }
        // 查询合同冻结、解冻
        // 清除签章条件
        queryParam.getParams().remove("signatureStatus");
        queryParam.getParams().put("billState", new Parameter(QueryParam.IN, billStateList));
        List<PurchaseContractFreezeEntity> freezeEntityList = freezeService.queryList(queryParam, false);
        // 存在未生效的合同冻结、解冻，则抛出异常
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(freezeEntityList)) {
            throw new BusinessException("存在未生效的合同冻结或合同解冻单据！");
        }
        return true;
    }

    @Override
    public ParamsCheckVO targetCostCtrl(PurchaseContractVO contractVO, String authority) {
        PurchaseContractVO contractVO1 = insertOrUpdate(contractVO, authority, true);
        ExecutionVO executionVO = service.targetCost(BeanMapper.map(contractVO1, PurchaseContractVO.class), BILL_TYPE, linkUrl);
        logger.info("目标成本推送数据" + JSON.toJSONString(executionVO));
        logger.error("ss" + JSONObject.toJSONString(executionVO));
        CommonResponse<ParamsCheckVO> response = executionApi.ctrlCheckVO(executionVO);
        return response.getData();
    }

    @Override
    public ParamsCheckVO viewTargetCostCtrlInfo(Long id) {
        PurchaseContractVO contractVO = queryDetail(id);
        ExecutionVO executionVO = service.targetCost(BeanMapper.map(contractVO, PurchaseContractVO.class), BILL_TYPE, linkUrl);
        logger.error("ss" + JSONObject.toJSONString(executionVO));
        CommonResponse<ParamsCheckVO> response = executionApi.ctrlCheckVO(executionVO);
        return response.getData();
    }

    @Override
    public CommonResponse<String> pushTargetCost(Long id) {
        QueryWrapper<ChangePurchaseContractEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("contract_id",id).eq("dr", 0).orderByDesc("create_time");
        List<ChangePurchaseContractEntity> list = changeService.list(wrapper);
        ExecutionVO executionVO;
        //判断是否有过变更
        if (list.size() > 0) {
            executionVO = service.targetCost(BeanMapper.map(list.get(0), PurchaseContractVO.class), CHANGE_BILL_TYPE, changeLinkUrl);
        }
        else {
            executionVO = service.targetCost(service.queryDetail(id), BILL_TYPE, linkUrl);
            logger.info("目标成本推送数据" + JSON.toJSONString(executionVO));
        }
        CommonResponse<String> response = executionApi.aggPush(executionVO);
        if (!response.isSuccess()) {
            throw new BusinessException("目标成本推送失败," + response.getMsg());
        }
        return CommonResponse.success("目标成本推送成功");
    }
}
