package com.ejianc.business.settlement.controller.api;

import com.ejianc.business.settlement.mapper.PurchaseSettlementMapper;
import com.ejianc.business.settlement.vo.SourceBliVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.stream.Collectors;

@RestController
@RequestMapping
public class PurchaseSettleApi {
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private PurchaseSettlementMapper purchaseSettlementMapper;
    @GetMapping(value = "/api/purchaseSettle/getSourceBliVO")
    @ResponseBody
    CommonResponse<SourceBliVO> getSourceBliVO(@RequestParam(value = "supplierId") Long supplierId, @RequestParam(value = "dateIn",required = false) String dateIn){
        List<Long> orgIds =
                iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        SourceBliVO vo= purchaseSettlementMapper.getSourceBliVO(supplierId,orgIds,dateIn);
        return CommonResponse.success("查询成功", vo);
    }
}
