/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.purchaseplan.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.purchaseplan.bean.PurchasePlanEntity;
import com.ejianc.business.purchaseplan.service.IPurchasePlanDetailedService;
import com.ejianc.business.purchaseplan.service.IPurchasePlanService;
import com.ejianc.business.purchaseplan.vo.PurchasePlanDetailedRefVO;
import com.ejianc.business.purchaseplan.vo.PurchasePlanVO;
import com.ejianc.business.vo.util.TreeNodeBUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"purchasePlan"})
public class PurchasePlanController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "PURCHASE_PLAN";
    @Autowired
    private IPurchasePlanService service;
    @Autowired
    private IPurchasePlanDetailedService planService;
    @Autowired
    private SessionManager sessionManager;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PurchasePlanVO> saveOrUpdate(@RequestBody PurchasePlanVO saveOrUpdateVO) {
        PurchasePlanEntity entity = (PurchasePlanEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, PurchasePlanEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            if (StringUtils.isBlank((CharSequence)entity.getBillCode())) {
                BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
                CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
                if (!billCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                entity.setBillCode((String)billCode.getData());
            } else if (this.service.checkSameBillCode((PurchasePlanVO)BeanMapper.map((Object)((Object)entity), PurchasePlanVO.class)).booleanValue()) {
                throw new BusinessException("\u7f16\u7801\u91cd\u590d\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        }
        this.service.saveOrUpdates(entity);
        PurchasePlanVO vo = (PurchasePlanVO)BeanMapper.map((Object)((Object)entity), PurchasePlanVO.class);
        vo.setDetailList(TreeNodeBUtil.buildTree((List)vo.getDetailList()));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PurchasePlanVO> queryDetail(Long id) {
        PurchasePlanEntity entity = (PurchasePlanEntity)((Object)this.service.selectById(id));
        PurchasePlanVO vo = (PurchasePlanVO)BeanMapper.map((Object)((Object)entity), PurchasePlanVO.class);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(entity.getDetailList())) {
            vo.setDetailList(TreeNodeBUtil.buildTree((List)vo.getDetailList()));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PurchasePlanVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (PurchasePlanVO purchasePlanVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PurchasePlanVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("employee");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (!param.getParams().containsKey("orgId")) {
            UserContext userContextCache = this.sessionManager.getUserContext();
            String authOrgIds = userContextCache.getAuthOrgIds();
            List orgVOList = null;
            orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            ArrayList commonOrgIds = new ArrayList();
            ArrayList departmentIds = new ArrayList();
            orgVOList.stream().forEach(org -> {
                if (5 == org.getOrgType()) {
                    departmentIds.add(org.getId());
                } else {
                    commonOrgIds.add(org.getId());
                }
            });
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
            } else if (CollectionUtils.isNotEmpty(departmentIds)) {
                param.getParams().put("orgId", new Parameter("in", departmentIds));
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PurchasePlanVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("employee");
        param.getFuzzyFields().add("billCode");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        List voList = new ArrayList();
        if (list.size() > 0) {
            voList = BeanMapper.mapList((Iterable)list, PurchasePlanVO.class);
            for (PurchasePlanVO vo : voList) {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            }
        }
        HashMap beans = new HashMap();
        beans.put("records", voList);
        ExcelExport.getInstance().export("purchasePlan-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refPurchasePlanData"}, method={RequestMethod.GET})
    @ResponseBody
    public List<PurchasePlanVO> refPurchasePlanData(@RequestParam(required=false) String searchText, @RequestParam(required=false) String condition) {
        JSONObject _con;
        Long projectId = null;
        if (StringUtils.isNotEmpty((CharSequence)condition) && (projectId = (_con = JSONObject.parseObject((String)condition)).getLong("projectId")) == null) {
            throw new BusinessException("\u9879\u76eeid\u5fc5\u987b\u4f20\uff01");
        }
        List<PurchasePlanVO> dataList = this.service.queryPlanList(projectId);
        SimpleDateFormat sim = new SimpleDateFormat("yyyy-MM-dd");
        if (CollectionUtil.isNotEmpty(dataList)) {
            for (PurchasePlanVO vo : dataList) {
                vo.setName(vo.getBillCode() + "-" + vo.getEmployee() + "-" + sim.format(vo.getPlanUseDate()));
            }
        }
        return dataList;
    }

    @RequestMapping(value={"/refPurchasePlanDataByProjectId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<PurchasePlanDetailedRefVO>> refPurchasePlanDataByProjectId(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        Long projectId = null;
        Long orgId = null;
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            projectId = _con.getLong("projectId");
            orgId = _con.getLong("orgId");
            if (projectId == null) {
                throw new BusinessException("\u9879\u76eeid\u5fc5\u987b\u4f20\uff01");
            }
        }
        ArrayList<Long> idList = new ArrayList<Long>();
        if (projectId != null) {
            QueryParam params = new QueryParam();
            params.getParams().put("projectId", new Parameter("eq", (Object)projectId));
            params.getParams().put("billState", new Parameter("in", Arrays.asList(1, 3)));
            params.getParams().put("planState", new Parameter("eq", (Object)0));
            List list = this.service.queryList(params);
            if (CollectionUtil.isNotEmpty((Collection)list)) {
                for (PurchasePlanEntity entity : list) {
                    idList.add(entity.getId());
                }
            }
        }
        if (orgId != null) {
            CommonResponse orgResp = this.iOrgApi.getOneById(orgId);
            OrgVO orgVO = (OrgVO)orgResp.getData();
            if (OrgVO.ORG_TYPE_DEPARTMENT.equals(orgVO.getOrgType())) {
                param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
            } else {
                param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            }
        }
        if (!CollectionUtil.isNotEmpty(idList)) {
            throw new BusinessException("\u9879\u76eeid\u5fc5\u987b\u4f20\uff01");
        }
        param.getParams().put("planId", new Parameter("in", idList));
        IPage page = this.planService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PurchasePlanDetailedRefVO.class));
        List refVOList = pageData.getRecords();
        for (PurchasePlanDetailedRefVO refVO : refVOList) {
            PurchasePlanEntity planEntity = (PurchasePlanEntity)((Object)this.service.selectById(refVO.getPlanId()));
            refVO.setPlanCode(planEntity.getBillCode());
            refVO.setProjectId(planEntity.getProjectId());
            refVO.setProjectCode(planEntity.getProjectCode());
            refVO.setProjectName(planEntity.getProjectName());
            refVO.setOrgId(planEntity.getOrgId());
            refVO.setOrgName(planEntity.getOrgName());
            refVO.setOrgCode(planEntity.getOrgCode());
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/refPurchasePlanDetailedData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<PurchasePlanDetailedRefVO>> refPurchasePlanDetailedData(@RequestParam(defaultValue="1") int pageNumber, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=false) String relyCondition, @RequestParam(required=false) String relyNode, @RequestParam(required=false) String searchText, @RequestParam(required=false) String condition, @RequestParam(required=false) String searchObject) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("equipmentType");
        fuzzyFields.add("equipmentName");
        Long planId = null;
        if (StringUtils.isNotEmpty((CharSequence)relyCondition)) {
            planId = Long.parseLong(relyCondition.split("=")[1]);
        }
        if (planId != null) {
            param.getParams().put("planId", new Parameter("eq", (Object)planId));
            param.getParams().put("leafFlag", new Parameter("eq", (Object)false));
        }
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.planService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PurchasePlanDetailedRefVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ApiOperation(value="\u5f15\u7528/\u91ca\u653e/\u5f15\u7528\u5b8c\u6210\u91c7\u8d2d\u8ba1\u5212")
    @RequestMapping(value={"/updateBatPlanQuote"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> updateBatPlanQuote(@RequestParam(value="idList") List<String> idList, @RequestParam(value="planState") Integer planState) {
        this.logger.info("\u4fee\u6539\u91c7\u8d2d\u8ba1\u5212\u3010{}\u3011\u72b6\u6001\u4e3a\uff1a[{}](\u8ba1\u5212\u72b6\u6001\uff080-\u5f85\u91c7\u8d2d\uff1b1-\u91c7\u8d2d\u4e2d\uff1b2-\u91c7\u8d2d\u5b8c\u6210\uff09)", (Object)(idList == null ? null : idList.toString()), (Object)planState);
        this.service.updateBatPlanByQuoteType(idList, planState);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }
}

