/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.purchaseplan.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.promaterial.plan.vo.BatPlanEnum;
import com.ejianc.business.purchaseplan.bean.PurchasePlanDetailedEntity;
import com.ejianc.business.purchaseplan.bean.PurchasePlanEntity;
import com.ejianc.business.purchaseplan.mapper.PurchasePlanMapper;
import com.ejianc.business.purchaseplan.service.IPurchasePlanDetailedService;
import com.ejianc.business.purchaseplan.service.IPurchasePlanService;
import com.ejianc.business.purchaseplan.vo.PurchasePlanEnum;
import com.ejianc.business.purchaseplan.vo.PurchasePlanVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="purchasePlanService")
public class PurchasePlanServiceImpl
extends BaseServiceImpl<PurchasePlanMapper, PurchasePlanEntity>
implements IPurchasePlanService {
    @Autowired
    private IPurchasePlanDetailedService purchasePlanDetailedService;
    @Autowired
    private PurchasePlanMapper mapper;

    @Override
    public void saveOrUpdates(PurchasePlanEntity entity) {
        this.saveOrUpdate((Object)entity, false);
        if (CollectionUtil.isNotEmpty(entity.getDetailList())) {
            this.saveOrUpdateChild(entity);
        }
    }

    @Override
    public List<PurchasePlanVO> queryPlanList(Long projectId) {
        List<PurchasePlanVO> list = this.mapper.queryList(projectId);
        return list;
    }

    @Transactional
    public void saveOrUpdateChild(PurchasePlanEntity entity) {
        List<PurchasePlanDetailedEntity> listbs = entity.getDetailList();
        HashMap<Long, Long> idMap = new HashMap<Long, Long>();
        for (PurchasePlanDetailedEntity cdEntity : listbs) {
            if (cdEntity.getParentId() != 999L) continue;
            idMap.put(cdEntity.getDocCategoryId(), cdEntity.getId());
        }
        for (PurchasePlanDetailedEntity cdEntity : listbs) {
            if (!cdEntity.getParentId().equals(999L)) {
                Long parentId = (Long)idMap.get(cdEntity.getDocCategoryId());
                cdEntity.setParentId(parentId != null ? parentId : entity.getProjectId());
                cdEntity.setTid(cdEntity.getId());
                continue;
            }
            cdEntity.setTid(cdEntity.getId());
        }
        this.purchasePlanDetailedService.saveOrUpdateBatch(listbs, listbs.size(), false);
    }

    @Override
    public Boolean checkSameBillCode(PurchasePlanVO contractVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(PurchasePlanEntity::getBillCode, (Object)contractVO.getBillCode());
        lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
        if (null != contractVO.getId() && contractVO.getId() > 0L) {
            lambda.ne(BaseEntity::getId, (Object)contractVO.getId());
        }
        return super.list((Wrapper)lambda).size() > 0;
    }

    @Override
    public void updateBatPlanByQuoteType(List<String> idList, Integer planState) {
        List entityList;
        if (StringUtils.isEmpty((CharSequence)PurchasePlanEnum.getDescriptionByStateCode((Integer)planState))) {
            throw new BusinessException("\u8ba1\u5212\u72b6\u6001\u9519\u8bef");
        }
        if (CollectionUtils.isNotEmpty(idList) && CollectionUtils.isNotEmpty((Collection)(entityList = (List)super.listByIds(idList)))) {
            for (PurchasePlanEntity entity : entityList) {
                if (BatPlanEnum.PLAN_STATE_OVER.getPlanState().equals(entity.getPlanState())) {
                    throw new BusinessException("\u91c7\u8d2d\u8ba1\u5212\u7f16\u7801\u3010" + entity.getBillCode() + "\u3011\u5df2\u91c7\u8d2d\u5b8c\u6210\uff01");
                }
                entity.setPlanState(planState);
            }
            super.saveOrUpdateBatch((Collection)entityList);
        }
    }
}

