package com.ejianc.business.asset.service.impl;

import com.ejianc.business.acceptance.bean.PurchaseAcceptanceEntity;
import com.ejianc.business.acceptance.bean.PurchaseAcceptanceSubEntity;
import com.ejianc.business.acceptance.service.IPurchaseAcceptanceService;
import com.ejianc.business.asset.vo.AssetVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import jdk.nashorn.internal.ir.EmptyNode;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.asset.mapper.AssetMapper;
import com.ejianc.business.asset.bean.AssetEntity;
import com.ejianc.business.asset.service.IAssetService;

import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;

/**
 *  固定资产
 * 
 * @author generator
 * 
 */
@Service("assetService")
public class AssetServiceImpl extends BaseServiceImpl<AssetMapper, AssetEntity> implements IAssetService{
    @Autowired
    private IPurchaseAcceptanceService purchaseAcceptanceService;
    @Autowired
    private IAssetService assetService;
    @Autowired
    private IBillCodeApi billCodeApi;

    private static final String BILL_CODE = "ASSET_Bli_CODE";//此处需要根据实际修改
    @Override
    public void pushAsset(Long billId) {
        PurchaseAcceptanceEntity purchaseAcceptanceEntity = purchaseAcceptanceService.selectById(billId);
        AssetEntity entity = new AssetEntity();
        if (Optional.ofNullable(purchaseAcceptanceEntity).isPresent()){
            //封装数据 组织信息
            entity.setOrgId(purchaseAcceptanceEntity.getOrgId());
            entity.setOrgName(purchaseAcceptanceEntity.getOrgName());
            entity.setOrgCode(purchaseAcceptanceEntity.getOrgCode());
            entity.setParentOrgId(purchaseAcceptanceEntity.getParentOrgId());
            entity.setParentOrgName(purchaseAcceptanceEntity.getParentOrgName());
            entity.setParentOrgCode(purchaseAcceptanceEntity.getParentOrgCode());
            entity.setPropertyRightCompanyId(purchaseAcceptanceEntity.getPropertyRightCompanyId());
            entity.setPropertyRightCompany(purchaseAcceptanceEntity.getPropertyRightCompany());
            entity.setManageCompanyId(purchaseAcceptanceEntity.getManageCompanyId());
            entity.setPropertyRightCompany(purchaseAcceptanceEntity.getPropertyRightCompany());
            //封装数据 项目信息
            entity.setProjectId(purchaseAcceptanceEntity.getProjectId());
            entity.setProjectName(purchaseAcceptanceEntity.getProjectName());
            List<PurchaseAcceptanceSubEntity> purchaseAcceptanceSubList = purchaseAcceptanceEntity.getPurchaseAcceptanceSubList();
            if (CollectionUtils.isNotEmpty(purchaseAcceptanceSubList)){
                //一只只能验收一台设备
                PurchaseAcceptanceSubEntity purchaseAcceptanceSubEntity = purchaseAcceptanceSubList.get(0);
                //原值 净值
                entity.setOriginalValueTax(purchaseAcceptanceSubEntity.getPurchasePrice());
                BigDecimal tax = ComputeUtil.safeMultiply(purchaseAcceptanceSubEntity.getPurchasePrice(), purchaseAcceptanceSubEntity.getTaxRate());
                BigDecimal originalValue = ComputeUtil.safeSub(purchaseAcceptanceSubEntity.getPurchasePrice(), tax);
                entity.setOriginalValue(originalValue);
                entity.setTaxRate(purchaseAcceptanceSubEntity.getTaxRate());
                //封装设备信息
                entity.setEquipmentId(purchaseAcceptanceSubEntity.getEquipmentId());
                entity.setEquipmentName(purchaseAcceptanceSubEntity.getEquipmentName());
                entity.setEquipmentCode(purchaseAcceptanceSubEntity.getEquipmentCode());
                entity.setEquipmentTypeId(purchaseAcceptanceSubEntity.getEquipmentTypeId());
                entity.setEquipmentTypeName(purchaseAcceptanceSubEntity.getEquipmentType());
                entity.setEquipmentTypeCode(purchaseAcceptanceSubEntity.getEquipmentCode());
                entity.setEquipmentStatus(1);
                //大于2000 资产类型 1:固定资产 2:普通资产
                if (purchaseAcceptanceSubEntity.getPurchasePrice().compareTo(new BigDecimal(2000))!=-1){
                  entity.setAssetType(1);
                }else {
                    entity.setAssetType(2);
                }
            }
            entity.setFinancePushFlag(purchaseAcceptanceEntity.getFinancePushFlag());
            //// 来源 1：验收 2：期初 3：调拨
            entity.setSourceType(1);
            //设备出厂指标
            entity.setManufacturer(purchaseAcceptanceEntity.getManufacturer());
            entity.setCertificateNum(purchaseAcceptanceEntity.getCertificateNum());
//            entity.setLeaveFactoryDate()
            entity.setLeaveFactoryCode(purchaseAcceptanceEntity.getLeaveFactoryCode());
            entity.setRandomTool(purchaseAcceptanceEntity.getRandomTool());
            entity.setAbility(purchaseAcceptanceEntity.getAbility());
            entity.setWeight(purchaseAcceptanceEntity.getWeight());
            entity.setPower(purchaseAcceptanceEntity.getPower());
            entity.setOwnWeight(purchaseAcceptanceEntity.getOwnWeight());
            entity.setAppearanceSize(purchaseAcceptanceEntity.getAppearanceSize());
            entity.setModelExplain(purchaseAcceptanceEntity.getModelExplain());
            entity.setSupplierId(purchaseAcceptanceEntity.getSupplierId());
            entity.setSupplierName(purchaseAcceptanceEntity.getSupplierName());
            AssetVO vo = BeanMapper.map(entity, AssetVO.class);
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),vo);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        assetService.saveOrUpdate(entity, false);
    }
}
