/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.purchase.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.purchase.bean.PurchaseContractEntity;
import com.ejianc.business.purchase.bean.PurchaseContractRelieveEntity;
import com.ejianc.business.purchase.enums.PerformanceStatusEnum;
import com.ejianc.business.purchase.enums.SignatureStatusEnum;
import com.ejianc.business.purchase.mapper.PurchaseContractRelieveMapper;
import com.ejianc.business.purchase.service.IPurchaseContractRelieveService;
import com.ejianc.business.purchase.service.IPurchaseContractService;
import com.ejianc.business.purchase.vo.PurchaseContractVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="purchaseContractRelieveService")
public class PurchaseContractRelieveServiceImpl
extends BaseServiceImpl<PurchaseContractRelieveMapper, PurchaseContractRelieveEntity>
implements IPurchaseContractRelieveService {
    @Autowired
    private IPurchaseContractRelieveService service;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPurchaseContractService contractService;

    @Override
    public Boolean isCanRelieve(Long contractId) {
        QueryParam param = new QueryParam();
        param.getParams().put("contract_id", new Parameter("eq", (Object)contractId));
        List list = this.service.queryList(param);
        return list.isEmpty();
    }

    @Override
    public CommonResponse<String> relieveContract(String billId, String status, String refCode) {
        this.logger.info("\u66f4\u65b0\u5408\u540c\u89e3\u9664\u5355\u636e\u7b7e\u7ae0\u72b6\u6001\u548c\u5408\u540c\u72b6\u6001\uff0c\u5165\u53c2\uff1aid:{}\uff0csignatureStatus\uff1a{}\uff0crefCode\uff1a{}", new Object[]{billId, status, refCode});
        Integer id = Integer.valueOf(billId);
        PurchaseContractRelieveEntity purchaseContractRelieveEntity = (PurchaseContractRelieveEntity)((Object)super.selectById((Serializable)id));
        purchaseContractRelieveEntity.setSignatureStatus(status);
        PurchaseContractEntity purchaseContractEntity = (PurchaseContractEntity)((Object)this.contractService.selectById(purchaseContractRelieveEntity.getContractId()));
        if (purchaseContractEntity == null) {
            throw new BusinessException("\u5408\u540c\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        this.logger.info("\u4fee\u6539\u5408\u540c\u4fe1\u606f-----{}", (Object)JSONObject.toJSONString((Object)((Object)purchaseContractEntity)));
        if (SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode().equals(status) && PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode().equals(purchaseContractEntity.getContractPerformanceState())) {
            purchaseContractRelieveEntity.setEffectiveDate(new Date());
            purchaseContractEntity.setContractPerformanceState(PerformanceStatusEnum.\u5df2\u89e3\u9664.getCode());
            this.contractService.saveOrUpdate((Object)purchaseContractEntity, false);
            this.contractService.pushContract((PurchaseContractVO)BeanMapper.map((Object)((Object)purchaseContractEntity), PurchaseContractVO.class));
            this.logger.info("\u5408\u540c\u5df2\u89e3\u9664\uff01");
        }
        super.saveOrUpdate((Object)purchaseContractRelieveEntity, false);
        return CommonResponse.success((String)"\u5408\u540c\u89e3\u9664\u5355\u636e\u7b7e\u7ae0\u72b6\u6001\u66f4\u65b0\u6210\u529f\uff01");
    }
}

