package com.ejianc.business.asset.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.asset.bean.AssetAllotInDetailEntity;
/**
 * 固定资产调入表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_proequipment_asset_allot_in")
public class AssetAllotInEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="allot_out_id")
    private Long allotOutId; // 设备调出单id
    @TableField(value="allot_range")
    private Integer allotRange; // 调入范围 1-项目，2-组织
    @TableField(value="project_id")
    private Long projectId; // 调入项目id
    @TableField(value="project_name")
    private String projectName; // 调入项目名称
    @TableField(value="org_id")
    private Long orgId; // 调入组织id
    @TableField(value="org_code")
    private String orgCode; // 调入组织编码
    @TableField(value="org_name")
    private String orgName; // 调入组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 项目部上级组织Id
    @TableField(value="parent_org_name")
    private String parentOrgName; // 项目部上级组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目部上级组织编码
    @TableField(value="out_date")
    private Date outDate; // 调出的时间
    @TableField(value="out_mny")
    private BigDecimal outMny; // 调出金额
    @TableField(value="out_tax_mny")
    private BigDecimal outTaxMny; // 调出金额(有税)
    @TableField(value="allocat_type")
    private Integer allocatType; // 调拨方式 1 资产盘活 2 自制
    @TableField(value="employee_id")
    private Long employeeId; // 经办人id
    @TableField(value="employee_name")
    private String employeeName; // 经办人
    @TableField(value="department_id")
    private Long departmentId; // 经办人部门id
    @TableField(value="department_name")
    private String departmentName; // 经办人部门
    @TableField(value="out_allot_range")
    private Integer outAllotRange; // 调出范围 1-项目，2-组织
    @TableField(value="out_project_id")
    private Long outProjectId; // 调出项目id
    @TableField(value="out_project_name")
    private String outProjectName; // 调出项目名称
    @TableField(value="out_org_id")
    private Long outOrgId; // 调出项目部id
    @TableField(value="out_org_name")
    private String outOrgName; // 调出项目部名称
    @TableField(value="out_org_code")
    private String outOrgCode; //调出项目部编码
    @TableField(value="out_parent_org_id")
    private Long outParentOrgId; // 调出上级组织Id
    @TableField(value="out_parent_org_name")
    private String outParentOrgName; // 调出上级组织名称
    @TableField(value="out_parent_org_code")
    private String outParentOrgCode; // 调出上级组织编码
    @TableField(value="equipment_names")
    private String equipmentNames; // 调出设备名称集合
    @TableField(value="notify_receiver_id")
    private Long notifyReceiverId; // 通知收料人id
    @TableField(value="notify_receiver_name")
    private String notifyReceiverName; // 通知收料人
    @TableField(value="receiver_name")
    private String receiverName;// 调入组织收料人
    @TableField(value="receive_date")
    private Date receiveDate; // 收料时间
    @TableField(value="pass_date")
    private Date passDate; // 通过时间
    @TableField(value="return_reason")
    private String returnReason; // 退回原因
    @TableField(value="receive_state")
    private Integer receiveState; // 收料状态 1、待收；2、已收；3、退回
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="receiver_person_id")
    private Long receiverPersonId; // 收料人id
    @TableField(value="receiver_person")
    private String receiverPerson; // 收料人
    @TableField(value="finance_allot_flag")
    private Integer financeAllotFlag; // 财务调拨 0-未完成，1-已完成
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="assetAllotInDetailService",pidName ="allocatId")//此处有pid="xxx"，默认值pid="pid"
    private List<AssetAllotInDetailEntity> assetAllotInDetailList = new ArrayList<>(); // 固定资产调入明细表
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getAllotOutId() {
        return allotOutId;
    }

    public void setAllotOutId(Long allotOutId) {
        this.allotOutId = allotOutId;
    }
    public Integer getAllotRange() {
        return allotRange;
    }

    public void setAllotRange(Integer allotRange) {
        this.allotRange = allotRange;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Date getOutDate() {
        return outDate;
    }

    public void setOutDate(Date outDate) {
        this.outDate = outDate;
    }
    public BigDecimal getOutMny() {
        return outMny;
    }

    public void setOutMny(BigDecimal outMny) {
        this.outMny = outMny;
    }
    public BigDecimal getOutTaxMny() {
        return outTaxMny;
    }

    public void setOutTaxMny(BigDecimal outTaxMny) {
        this.outTaxMny = outTaxMny;
    }
    public Integer getAllocatType() {
        return allocatType;
    }

    public void setAllocatType(Integer allocatType) {
        this.allocatType = allocatType;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public Integer getOutAllotRange() {
        return outAllotRange;
    }

    public void setOutAllotRange(Integer outAllotRange) {
        this.outAllotRange = outAllotRange;
    }
    public Long getOutProjectId() {
        return outProjectId;
    }

    public void setOutProjectId(Long outProjectId) {
        this.outProjectId = outProjectId;
    }
    public String getOutProjectName() {
        return outProjectName;
    }

    public void setOutProjectName(String outProjectName) {
        this.outProjectName = outProjectName;
    }
    public Long getOutOrgId() {
        return outOrgId;
    }

    public void setOutOrgId(Long outOrgId) {
        this.outOrgId = outOrgId;
    }
    public String getOutOrgName() {
        return outOrgName;
    }

    public void setOutOrgName(String outOrgName) {
        this.outOrgName = outOrgName;
    }

    public String getOutOrgCode() {
        return outOrgCode;
    }

    public void setOutOrgCode(String outOrgCode) {
        this.outOrgCode = outOrgCode;
    }

    public Long getOutParentOrgId() {
        return outParentOrgId;
    }

    public void setOutParentOrgId(Long outParentOrgId) {
        this.outParentOrgId = outParentOrgId;
    }

    public String getOutParentOrgName() {
        return outParentOrgName;
    }

    public void setOutParentOrgName(String outParentOrgName) {
        this.outParentOrgName = outParentOrgName;
    }

    public String getOutParentOrgCode() {
        return outParentOrgCode;
    }

    public void setOutParentOrgCode(String outParentOrgCode) {
        this.outParentOrgCode = outParentOrgCode;
    }

    public String getEquipmentNames() {
        return equipmentNames;
    }

    public void setEquipmentNames(String equipmentNames) {
        this.equipmentNames = equipmentNames;
    }
    public Long getNotifyReceiverId() {
        return notifyReceiverId;
    }

    public void setNotifyReceiverId(Long notifyReceiverId) {
        this.notifyReceiverId = notifyReceiverId;
    }
    public String getNotifyReceiverName() {
        return notifyReceiverName;
    }

    public void setNotifyReceiverName(String notifyReceiverName) {
        this.notifyReceiverName = notifyReceiverName;
    }

    public String getReceiverName() {
        return receiverName;
    }

    public void setReceiverName(String receiverName) {
        this.receiverName = receiverName;
    }

    public Date getReceiveDate() {
        return receiveDate;
    }

    public void setReceiveDate(Date receiveDate) {
        this.receiveDate = receiveDate;
    }
    public Date getPassDate() {
        return passDate;
    }

    public void setPassDate(Date passDate) {
        this.passDate = passDate;
    }
    public String getReturnReason() {
        return returnReason;
    }

    public void setReturnReason(String returnReason) {
        this.returnReason = returnReason;
    }
    public Integer getReceiveState() {
        return receiveState;
    }

    public void setReceiveState(Integer receiveState) {
        this.receiveState = receiveState;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getReceiverPersonId() {
        return receiverPersonId;
    }

    public void setReceiverPersonId(Long receiverPersonId) {
        this.receiverPersonId = receiverPersonId;
    }
    public String getReceiverPerson() {
        return receiverPerson;
    }

    public void setReceiverPerson(String receiverPerson) {
        this.receiverPerson = receiverPerson;
    }
    public Integer getFinanceAllotFlag() {
        return financeAllotFlag;
    }

    public void setFinanceAllotFlag(Integer financeAllotFlag) {
        this.financeAllotFlag = financeAllotFlag;
    }
    
    public List<AssetAllotInDetailEntity> getAssetAllotInDetailList() {
        return assetAllotInDetailList;
    }

    public void setAssetAllotInDetailList(List<AssetAllotInDetailEntity> assetAllotInDetailList) {
        this.assetAllotInDetailList = assetAllotInDetailList;
    }
}
