/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.purchase.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.contractbase.api.IParamCheckApi;
import com.ejianc.business.contractbase.filing.enums.FilingStatusEnum;
import com.ejianc.business.purchase.bean.ChangeEquipmentDetailedEntity;
import com.ejianc.business.purchase.bean.ChangeOtherDetailedEntity;
import com.ejianc.business.purchase.bean.ChangePurchaseContractEntity;
import com.ejianc.business.purchase.bean.EquipmentDetailedEntity;
import com.ejianc.business.purchase.bean.OtherDetailedEntity;
import com.ejianc.business.purchase.bean.PurchaseContractClauseEntity;
import com.ejianc.business.purchase.bean.PurchaseContractEntity;
import com.ejianc.business.purchase.bean.PurchaseContractPaymentClauseEntity;
import com.ejianc.business.purchase.bean.PurchaseContractRecordEntity;
import com.ejianc.business.purchase.enums.ChangeStatusEnum;
import com.ejianc.business.purchase.enums.DraftTypeEnum;
import com.ejianc.business.purchase.enums.PerformanceStatusEnum;
import com.ejianc.business.purchase.enums.SignatureStatusEnum;
import com.ejianc.business.purchase.mapper.ChangePurchaseContractMapper;
import com.ejianc.business.purchase.service.IChangePurchaseContractService;
import com.ejianc.business.purchase.service.IPurchaseContractRecordService;
import com.ejianc.business.purchase.service.IPurchaseContractService;
import com.ejianc.business.purchase.service.impl.PurchaseContractClauseServiceImpl;
import com.ejianc.business.purchase.service.impl.PurchaseContractPaymentClauseServiceImpl;
import com.ejianc.business.purchase.vo.ChangePurchaseContractVO;
import com.ejianc.business.purchase.vo.PurchaseContractVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="changePurchaseContractService")
public class ChangePurchaseContractServiceImpl
extends BaseServiceImpl<ChangePurchaseContractMapper, ChangePurchaseContractEntity>
implements IChangePurchaseContractService {
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IParamCheckApi paramCheckApi;
    @Autowired
    private IPurchaseContractService contractService;
    @Autowired
    private IPurchaseContractRecordService recordService;
    @Autowired
    private IChangePurchaseContractService changeService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private PurchaseContractClauseServiceImpl contractClauseService;
    @Autowired
    private PurchaseContractPaymentClauseServiceImpl contractPaymentService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IExecutionApi executionApi;
    private static final String linkUrl = "ejc-proequipmentp-frontend/#/machineryPurchaseContract/card?id=";
    private static final String changeLinkUrl = "ejc-proequipmentp-frontend/#/machineryPurchaseContract/contractChangeCard?id=";
    private static final String BILL_TYPE = "BT220323000000001";
    private static final String CHANGE_BILL_TYPE = "BT220323000000002";
    @Autowired
    private IParamConfigApi paramConfigApi;
    private static final String CHECK_PARAM_CODE = "P-z3M80967";

    @Override
    public ChangePurchaseContractVO queryDetailRecord(Long id) {
        PurchaseContractEntity contractEntity = (PurchaseContractEntity)((Object)this.contractService.selectById(id));
        ChangePurchaseContractVO changeVO = new ChangePurchaseContractVO();
        changeVO.setId(id);
        changeVO.setBaseTaxMny(contractEntity.getBaseTaxMny() == null ? BigDecimal.ZERO : contractEntity.getBaseTaxMny());
        changeVO.setContractTaxMny(contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny());
        QueryParam param = new QueryParam();
        param.getParams().put("contract_id", new Parameter("eq", (Object)id));
        param.getParams().put("contract_performance_state", new Parameter("eq", (Object)PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode()));
        param.getOrderMap().put("change_date", "desc");
        param.getOrderMap().put("create_time", "desc");
        Map resp = new HashMap();
        QueryWrapper wrapper = ChangePurchaseContractServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.select(new String[]{"sum(change_mny) as sumChangeMoney, count(*) as changeNum"});
        resp = super.getMap((Wrapper)wrapper);
        changeVO.setChangeList(BeanMapper.mapList((Iterable)this.queryList(param), ChangePurchaseContractVO.class));
        BigDecimal sumChangeMoney = null != resp.get("sumChangeMoney") ? new BigDecimal(resp.get("sumChangeMoney").toString()) : BigDecimal.ZERO;
        BigDecimal changeAmtRate = BigDecimal.ZERO;
        if (null != contractEntity.getBaseTaxMny() && contractEntity.getBaseTaxMny().compareTo(BigDecimal.ZERO) > 0) {
            changeAmtRate = sumChangeMoney.divide(contractEntity.getBaseTaxMny(), 8, 5).multiply(new BigDecimal(100));
        }
        changeVO.setAllChangeMny(sumChangeMoney);
        Long changeNum = (Long)resp.get("changeNum");
        changeVO.setChangeNum(Integer.valueOf(changeNum != null ? Integer.valueOf(String.valueOf(changeNum)) : 0));
        changeVO.setChangeMnyRate(changeAmtRate);
        changeVO.setSupplementFlag(contractEntity.getSupplementFlag());
        changeVO.setAddType(contractEntity.getAddType());
        if (SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode().equals(contractEntity.getSignatureStatus()) && (BillStateEnum.PASSED_STATE.getBillStateCode().equals(contractEntity.getBillState()) || BillStateEnum.COMMITED_STATE.getBillStateCode().equals(contractEntity.getBillState())) && !PerformanceStatusEnum.\u5df2\u89e3\u9664.getCode().equals(contractEntity.getContractPerformanceState()) && !PerformanceStatusEnum.\u5df2\u51bb\u7ed3.getCode().equals(contractEntity.getContractPerformanceState()) && !PerformanceStatusEnum.\u5df2\u5c01\u8d26.getCode().equals(contractEntity.getContractPerformanceState())) {
            changeVO.setEditFlag(this.editChangeFlag(id));
        }
        return changeVO;
    }

    @Override
    public Boolean editChangeFlag(Long contractId) {
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(ChangePurchaseContractEntity::getContractId, (Object)contractId);
        lambda.and(l -> (LambdaQueryWrapper)((LambdaQueryWrapper)l.ne(ChangePurchaseContractEntity::getSignatureStatus, (Object)SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode())).or(c -> (LambdaQueryWrapper)c.notIn(ChangePurchaseContractEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()})));
        List changeList = super.list((Wrapper)lambda);
        if (changeList.size() > 0) {
            return false;
        }
        return true;
    }

    @Override
    public ChangePurchaseContractVO addConvertByConId(Long contractId, Long changeId) {
        PurchaseContractEntity contractEntity = (PurchaseContractEntity)((Object)this.contractService.selectById(contractId));
        ChangePurchaseContractVO changeVO = (ChangePurchaseContractVO)BeanMapper.map((Object)((Object)contractEntity), ChangePurchaseContractVO.class);
        changeVO.setBillState(null);
        changeVO.setBeforeChangeMny(contractEntity.getContractMny());
        changeVO.setBeforeChangeTaxMny(contractEntity.getContractTaxMny());
        changeVO.setBeforeContractName(contractEntity.getContractName());
        changeVO.setChangeDraftType(DraftTypeEnum.\u4e0a\u4f20\u5408\u540c.getCode().toString());
        changeVO.setContractId(contractId);
        changeVO.setChangeVersion(Integer.valueOf(contractEntity.getChangeVersion() == null ? 1 : contractEntity.getChangeVersion() + 1));
        changeVO.setSignatureStatus(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode());
        contractEntity.setChangingMny(BigDecimal.ZERO);
        contractEntity.setChangingTaxMny(BigDecimal.ZERO);
        changeVO.setCreateUserCode(null);
        changeVO.setCreateTime(null);
        changeVO.setUpdateUserCode(null);
        changeVO.setUpdateTime(null);
        changeVO.setChangeDate(new Date());
        changeVO.setId(null);
        changeVO.setCommitDate(null);
        changeVO.setCommitUserCode(null);
        changeVO.setCommitUserName(null);
        changeVO.setEffectiveDate(null);
        changeVO.setChangeFileId(null);
        changeVO.setChangeFilePath(null);
        changeVO.setChangeFilingStatus(FilingStatusEnum.\u672a\u5f52\u6863.getTypeCode());
        this.resetSub(changeVO);
        return changeVO;
    }

    @Override
    public ChangePurchaseContractVO queryDetail(Long id) {
        HashMap orderMap = new HashMap();
        LinkedHashMap orderParams = new LinkedHashMap();
        orderMap.put("detailList", orderParams);
        orderMap.put("otherCostList", orderParams);
        ChangePurchaseContractEntity changeEntity = (ChangePurchaseContractEntity)((Object)super.selectById((Serializable)id, orderMap));
        ChangePurchaseContractVO changeVO = new ChangePurchaseContractVO();
        if (null != changeEntity) {
            changeVO = (ChangePurchaseContractVO)BeanMapper.map((Object)((Object)changeEntity), ChangePurchaseContractVO.class);
        }
        return changeVO;
    }

    private void resetSub(ChangePurchaseContractVO changeVO) {
        List payList;
        List changeClauseList;
        List changeDetailList = changeVO.getDetailList();
        if (CollectionUtils.isNotEmpty((Collection)changeDetailList)) {
            changeDetailList.forEach(changeDetailVO -> {
                changeDetailVO.setSrcTblId(changeDetailVO.getId());
                changeDetailVO.setBeforeChangeNum(BigDecimal.valueOf(changeDetailVO.getPurchaseNum()));
                changeDetailVO.setBeforeChangePrice(changeDetailVO.getPurchasePrice());
                changeDetailVO.setBeforeChangeRate(changeDetailVO.getTaxRate());
                changeDetailVO.setParentId(changeDetailVO.getParentId() != null ? changeDetailVO.getParentId() : null);
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(null);
            });
        }
        changeVO.setDetailList(changeDetailList);
        List changeOtherCostVOList = changeVO.getOtherCostList();
        if (CollectionUtils.isNotEmpty((Collection)changeOtherCostVOList)) {
            changeOtherCostVOList.forEach(changeOtherCostVO -> {
                changeOtherCostVO.setSrcTblId(changeOtherCostVO.getId());
                changeOtherCostVO.setBeforeChangeNum(BigDecimal.valueOf(changeOtherCostVO.getNum().intValue()));
                changeOtherCostVO.setBeforeChangePrice(changeOtherCostVO.getTaxPrice());
                changeOtherCostVO.setBeforeChangeRate(changeOtherCostVO.getTaxRate());
                changeOtherCostVO.setRowState("edit");
                changeOtherCostVO.setId(null);
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)(changeClauseList = changeVO.getClauseList()))) {
            changeClauseList.forEach(changeClauseVO -> {
                changeClauseVO.setRowState("add");
                changeClauseVO.setId(null);
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)(payList = changeVO.getPaymentList()))) {
            payList.forEach(item -> item.setRowState("add"));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ChangePurchaseContractVO insertOrUpdate(ChangePurchaseContractVO changeVO, Boolean isControl) {
        ChangePurchaseContractEntity changeEntity;
        PurchaseContractEntity contract = (PurchaseContractEntity)((Object)this.contractService.selectById(changeVO.getContractId()));
        if (CollectionUtils.isNotEmpty((Collection)changeVO.getAttachIds()) && null != contract.getContractFileId()) {
            changeVO.getAttachIds().remove(contract.getContractFileId());
        }
        if ((changeEntity = (ChangePurchaseContractEntity)((Object)BeanMapper.map((Object)changeVO, ChangePurchaseContractEntity.class))).getChangeFilingStatus() != null && FilingStatusEnum.\u5df2\u5f52\u6863.getTypeCode().equals(changeEntity.getChangeFilingStatus())) {
            changeEntity.setFilingRef(0);
        }
        LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
        lambdachange.eq(ChangePurchaseContractEntity::getContractId, (Object)changeVO.getContractId());
        if (changeVO.getId() != null) {
            lambdachange.ne(BaseEntity::getId, (Object)changeVO.getId());
        }
        lambdachange.and(l -> (LambdaQueryWrapper)((LambdaQueryWrapper)l.ne(ChangePurchaseContractEntity::getSignatureStatus, (Object)SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode())).or(c -> (LambdaQueryWrapper)c.notIn(ChangePurchaseContractEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()})));
        int num = super.count((Wrapper)lambdachange);
        if (num > 0) {
            throw new BusinessException("\u8be5\u5408\u540c\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u53d8\u66f4\u5355!");
        }
        if (changeEntity.getId() == null) {
            changeEntity.setSignatureStatus(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode());
            changeEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            changeEntity.setContractPerformanceState(PerformanceStatusEnum.\u672a\u7b7e\u8ba2.getCode());
            if (StringUtils.isBlank((CharSequence)changeEntity.getBillCode()) || contract.getBillCode().equals(changeEntity.getBillCode())) {
                if (changeEntity.getChangeVersion() < 10) {
                    changeEntity.setBillCode(contract.getBillCode() + "10" + changeEntity.getChangeVersion());
                } else {
                    changeEntity.setBillCode(contract.getBillCode() + "1" + changeEntity.getChangeVersion());
                }
            } else if (this.checkSameBillCode(changeEntity)) {
                throw new BusinessException("\u7f16\u7801\u91cd\u590d\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        } else {
            ChangePurchaseContractEntity dbEntity = (ChangePurchaseContractEntity)((Object)super.selectById((Serializable)changeEntity.getId()));
            if (StringUtils.isBlank((CharSequence)changeEntity.getBillCode())) {
                changeEntity.setBillCode(dbEntity.getBillCode());
            } else if (!dbEntity.getBillCode().equals(changeEntity.getBillCode()) && this.checkSameBillCode(changeEntity)) {
                throw new BusinessException("\u7f16\u7801\u91cd\u590d\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        }
        if (!isControl.booleanValue()) {
            this.contractService.checkContract(changeVO.getContractId(), changeVO.getId());
        }
        List<ChangeEquipmentDetailedEntity> beforeDetails = changeEntity.getDetailList();
        if (changeVO.getId() == null && !isControl.booleanValue()) {
            ExecutionVO executionVO1;
            QueryWrapper wrapper = new QueryWrapper();
            ((QueryWrapper)((QueryWrapper)wrapper.eq((Object)"contract_id", (Object)changeVO.getContractId())).eq((Object)"dr", (Object)0)).orderByDesc((Object)"create_time");
            List list = this.changeService.list((Wrapper)wrapper);
            ArrayList<TotalExecutionVO> totalExecutionVOList = new ArrayList<TotalExecutionVO>();
            if (list.size() > 0) {
                executionVO1 = this.contractService.targetCost((PurchaseContractVO)BeanMapper.map(list.get(0), PurchaseContractVO.class), CHANGE_BILL_TYPE, changeLinkUrl);
            } else {
                PurchaseContractEntity contractEntity = (PurchaseContractEntity)((Object)this.contractService.selectById(changeVO.getContractId()));
                executionVO1 = this.contractService.targetCost((PurchaseContractVO)BeanMapper.map((Object)((Object)contractEntity), PurchaseContractVO.class), BILL_TYPE, linkUrl);
            }
            totalExecutionVOList.add(executionVO1.getTotalVO());
            this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString(totalExecutionVOList));
            CommonResponse response = this.executionApi.aggDel(totalExecutionVOList);
            if (!response.isSuccess()) {
                throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
            }
        }
        if (!isControl.booleanValue()) {
            this.changeService.saveOrUpdate((Object)changeEntity, false);
            this.saveWriteContract(changeEntity);
            ExecutionVO executionVO = this.contractService.targetCost((PurchaseContractVO)BeanMapper.map((Object)((Object)changeEntity), PurchaseContractVO.class), CHANGE_BILL_TYPE, changeLinkUrl);
            this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO));
            CommonResponse response = this.executionApi.aggPush(executionVO);
            if (!response.isSuccess()) {
                throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
            }
        }
        if (null == changeEntity.getId() && isControl.booleanValue()) {
            changeEntity.setId(IdWorker.getId());
            return (ChangePurchaseContractVO)BeanMapper.map((Object)((Object)changeEntity), ChangePurchaseContractVO.class);
        }
        return this.queryDetail(changeEntity.getId());
    }

    private boolean checkSameBillCode(ChangePurchaseContractEntity changeEntity) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(ChangePurchaseContractEntity::getBillCode, (Object)changeEntity.getBillCode());
        lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
        if (null != changeEntity.getId() && changeEntity.getId() > 0L) {
            lambda.ne(BaseEntity::getId, (Object)changeEntity.getId());
        }
        return super.list((Wrapper)lambda).size() > 0;
    }

    @Override
    public Map<String, Object> queryChangeCompare(Long id) {
        LinkedHashMap orderByParams = new LinkedHashMap();
        return null;
    }

    private void saveWriteContract(ChangePurchaseContractEntity changeEntity) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.set(PurchaseContractEntity::getChangeId, (Object)changeEntity.getId());
        if (null != changeEntity.getChangeMny() && null != changeEntity.getChangeTax()) {
            updateWrapper.set(PurchaseContractEntity::getChangingMny, (Object)changeEntity.getContractTaxMny());
        }
        updateWrapper.set(PurchaseContractEntity::getChangingTaxMny, (Object)changeEntity.getChangeMny());
        updateWrapper.set(PurchaseContractEntity::getChangeCode, (Object)changeEntity.getBillCode());
        updateWrapper.set(PurchaseContractEntity::getChangeVersion, (Object)changeEntity.getChangeVersion());
        updateWrapper.set(PurchaseContractEntity::getChangeStatus, (Object)ChangeStatusEnum.\u53d8\u66f4\u4e2d.getCode());
        updateWrapper.set(PurchaseContractEntity::getChangeDate, (Object)changeEntity.getChangeDate());
        updateWrapper.set(PurchaseContractEntity::getChangeDraftType, (Object)changeEntity.getChangeDraftType());
        updateWrapper.set(PurchaseContractEntity::getChangeContractSignatureStatus, (Object)Integer.valueOf(changeEntity.getSignatureStatus()));
        updateWrapper.set(PurchaseContractEntity::getChangeFileId, (Object)changeEntity.getChangeFileId());
        updateWrapper.set(PurchaseContractEntity::getChangeContractName, (Object)changeEntity.getContractName());
        updateWrapper.eq(BaseEntity::getId, (Object)changeEntity.getContractId());
        this.contractService.update(this.contractService.selectById(changeEntity.getContractId()), (Wrapper)updateWrapper, false);
    }

    @Override
    public CommonResponse<String> deleteById(Long changeBillId) {
        ChangePurchaseContractEntity entity = (ChangePurchaseContractEntity)((Object)super.selectById((Serializable)changeBillId));
        ArrayList<TotalExecutionVO> totalExecutionVOList = new ArrayList<TotalExecutionVO>();
        ArrayList<Object> contractEntityList = new ArrayList<Object>();
        ExecutionVO executionVO = this.contractService.targetCost((PurchaseContractVO)BeanMapper.map((Object)((Object)entity), PurchaseContractVO.class), CHANGE_BILL_TYPE, changeLinkUrl);
        totalExecutionVOList.add(executionVO.getTotalVO());
        contractEntityList.add(this.contractService.selectById(entity.getContractId()));
        this.logger.info("\u76ee\u6807\u6210\u672c\u5220\u9664\u6570\u636e" + JSON.toJSONString(totalExecutionVOList));
        CommonResponse response = this.executionApi.aggDel(totalExecutionVOList);
        if (!response.isSuccess()) {
            throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
        }
        for (PurchaseContractEntity purchaseContractEntity : contractEntityList) {
            List contractChangeEntityList = this.changeService.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"contract_id", (Object)purchaseContractEntity.getId())).eq((Object)"dr", (Object)0)).orderByDesc((Object)"create_time"));
            ExecutionVO executionVO1 = contractChangeEntityList.size() > 1 ? this.contractService.targetCost((PurchaseContractVO)BeanMapper.map(contractChangeEntityList.get(1), PurchaseContractVO.class), CHANGE_BILL_TYPE, changeLinkUrl) : this.contractService.targetCost((PurchaseContractVO)BeanMapper.map((Object)((Object)purchaseContractEntity), PurchaseContractVO.class), BILL_TYPE, linkUrl);
            this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO1));
            CommonResponse response1 = this.executionApi.aggPush(executionVO1);
            if (response1.isSuccess()) continue;
            throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response1.getMsg());
        }
        PurchaseContractEntity contractEntity = (PurchaseContractEntity)((Object)this.contractService.selectById(entity.getContractId()));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"contract_id", (Object)contractEntity.getId());
        queryWrapper.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        queryWrapper.ne((Object)"id", (Object)changeBillId);
        int count = super.count((Wrapper)queryWrapper);
        contractEntity.setChangeVersion(contractEntity.getChangeVersion() - 1);
        contractEntity.setChangeStatus(count > 0 ? ChangeStatusEnum.\u5df2\u53d8\u66f4.getCode() : ChangeStatusEnum.\u672a\u53d8\u66f4.getCode());
        contractEntity.setChangingMny(BigDecimal.ZERO);
        contractEntity.setChangingTaxMny(BigDecimal.ZERO);
        contractEntity.setChangeCode(null);
        contractEntity.setChangeId(null);
        contractEntity.setChangeDate(null);
        contractEntity.setChangeDraftType(null);
        contractEntity.setChangeContractSignatureStatus(null);
        contractEntity.setChangeFileId(null);
        contractEntity.setChangeContractName(null);
        this.contractService.update((Object)contractEntity, (Wrapper)new QueryWrapper().eq((Object)"id", (Object)contractEntity.getId()), false);
        super.removeById((Serializable)changeBillId, false);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @Override
    public ChangePurchaseContractVO queryChangeRecord(Long contractId, Long changeId) {
        PurchaseContractEntity contractEntity = (PurchaseContractEntity)((Object)this.contractService.selectById(contractId));
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contract_id", new Parameter("eq", (Object)contractEntity.getId()));
        queryParam.getParams().put("change_id", new Parameter("eq", (Object)changeId));
        queryParam.getOrderMap().put("createTime", "desc");
        List recordList = this.recordService.queryList(queryParam);
        ChangePurchaseContractVO changeVO = new ChangePurchaseContractVO();
        if (CollectionUtils.isNotEmpty((Collection)recordList)) {
            changeVO = (ChangePurchaseContractVO)BeanMapper.map(recordList.get(0), ChangePurchaseContractVO.class);
        }
        if (changeVO != null) {
            this.resetSub(changeVO);
        }
        return changeVO;
    }

    @Override
    public CommonResponse<String> effectiveSaveWriteContract(Long changeBillId, String billTypeCode, Boolean commitState, Boolean filingFlag) {
        List<OtherDetailedEntity> contractOtherCostList;
        List<EquipmentDetailedEntity> contractDetailList;
        CommonResponse resp = null;
        ChangePurchaseContractEntity changeEntity = (ChangePurchaseContractEntity)((Object)this.selectById(changeBillId));
        if (commitState.booleanValue()) {
            changeEntity.setCommitDate(new Date());
            changeEntity.setCommitUserCode(this.sessionManager.getUserContext().getUserCode());
            changeEntity.setCommitUserName(this.sessionManager.getUserContext().getUserName());
        }
        PurchaseContractVO contractVO = this.contractService.queryDetail(changeEntity.getContractId());
        QueryWrapper countQuery = new QueryWrapper();
        countQuery.eq((Object)"contract_id", (Object)contractVO.getId());
        countQuery.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        int curRecordVersion = this.recordService.count((Wrapper)countQuery);
        HashMap contIdVersionMap = new HashMap();
        PurchaseContractRecordEntity recordEntity = (PurchaseContractRecordEntity)((Object)BeanMapper.map((Object)contractVO, PurchaseContractRecordEntity.class));
        recordEntity.setContractId(recordEntity.getId());
        recordEntity.setChangeVersion(curRecordVersion + 1);
        recordEntity.setId(null);
        this.logger.info("\u53d8\u66f4\u524d\u4e3b\u5408\u540c\u6570\u636e: {}", (Object)JSONObject.toJSONString((Object)contractVO));
        this.logger.info("\u53d8\u66f4\u524d\u4e3b\u5408\u540c\u5b50\u8868detail\u6570\u636e: {}", (Object)JSONObject.toJSONString((Object)contractVO.getDetailList()));
        this.logger.info("\u8bb0\u5f55\u8868\u4ece\u4e3b\u5408\u540c\u8868\u590d\u5236\u7684\u6570\u636e: {}", (Object)JSONObject.toJSONString((Object)((Object)recordEntity)));
        this.logger.info("\u8bb0\u5f55\u8868\u4ece\u4e3b\u5408\u540c\u8868\u590d\u5236\u7684\u6570\u636e\u7684\u5b50\u8868detail\u6570\u636e: {}", (Object)JSONObject.toJSONString(recordEntity.getDetailList()));
        if (CollectionUtils.isNotEmpty(recordEntity.getDetailList())) {
            recordEntity.getDetailList().forEach(vo -> {
                contIdVersionMap.put(vo.getId(), vo.getVersion());
                vo.setSrcTblId(vo.getId());
                vo.setId(null);
            });
        }
        if (CollectionUtils.isNotEmpty(recordEntity.getClauseList())) {
            recordEntity.getClauseList().forEach(vo -> {
                vo.setSrcTblId(vo.getId());
                vo.setId(null);
            });
        }
        if (CollectionUtils.isNotEmpty(recordEntity.getOtherCostList())) {
            recordEntity.getOtherCostList().forEach(vo -> {
                vo.setSrcTblId(vo.getId());
                vo.setId(null);
            });
        }
        if (CollectionUtils.isNotEmpty(recordEntity.getPaymentList())) {
            recordEntity.getPaymentList().forEach(vo -> {
                vo.setSrcTblId(vo.getId());
                vo.setId(null);
            });
        }
        this.logger.info("\u8bb0\u5f55\u8868\u4ece\u4e3b\u5408\u540c\u8868\u590d\u5236\u7684\u5b50\u8868detail\u6570\u636e\uff0c\u8bbe\u7f6eid\u540e\u7684\u503c: {}", (Object)JSONObject.toJSONString(recordEntity.getDetailList()));
        this.recordService.saveOrUpdate((Object)recordEntity, false);
        this.logger.info("\u5ba1\u6279-\u53d8\u66f4\u8bb0\u5f55\u8868\u4fdd\u5b58\u4e3b\u5408\u540c\u6570\u636e\u6210\u529f\uff01");
        resp = this.attachmentApi.copyFilesFromSourceBillToTargetBill(contractVO.getId().toString(), BILL_TYPE, BILL_TYPE, recordEntity.getId().toString(), "BT220323000000003", "BT220323000000003");
        this.logger.info("resp---{}", (Object)JSONObject.toJSONString((Object)resp));
        resp = this.attachmentApi.copyFilesFromSourceBillToTargetBill(contractVO.getId().toString(), BILL_TYPE, "attachMgr", recordEntity.getId().toString(), "BT220323000000003", "attachMgr");
        this.logger.info("resp---{}", (Object)JSONObject.toJSONString((Object)resp));
        this.logger.info("\u66f4\u65b0\u53d8\u66f4\u6570\u636e\u5230\u4e3b\u5408\u540c\u8868,contractVO---------------->: {}", (Object)JSONObject.toJSONString((Object)contractVO));
        PurchaseContractEntity contractEntity = (PurchaseContractEntity)((Object)BeanMapper.map((Object)contractVO, PurchaseContractEntity.class));
        contractEntity.setContractName(changeEntity.getContractName());
        contractEntity.setFirstPartyId(changeEntity.getFirstPartyId());
        contractEntity.setFirstPartyName(changeEntity.getFirstPartyName());
        contractEntity.setSupplierId(changeEntity.getSupplierId());
        contractEntity.setSupplierName(changeEntity.getSupplierName());
        contractEntity.setSignDate(changeEntity.getSignDate());
        contractEntity.setSignPlace(changeEntity.getSignPlace());
        contractEntity.setTaxRate(changeEntity.getTaxRate());
        contractEntity.setDraftType(changeEntity.getDraftType());
        contractEntity.setContractFilePath(changeEntity.getContractFilePath());
        contractEntity.setContractFileId(changeEntity.getContractFileId());
        contractEntity.setContractTemplateId(changeEntity.getContractTemplateId());
        contractEntity.setContractTemplateName(changeEntity.getContractTemplateName());
        contractEntity.setContractFileVersionId(changeEntity.getContractFileVersionId());
        contractEntity.setContractFileVersion(changeEntity.getContractFileVersion());
        contractEntity.setFirstPartyPhone(changeEntity.getFirstPartyPhone());
        contractEntity.setSupplierPhone(changeEntity.getSupplierPhone());
        contractEntity.setSupplierEmployee(changeEntity.getSupplierEmployee());
        contractEntity.setProjectAddress(changeEntity.getProjectAddress());
        contractEntity.setInvoiceTypeId(changeEntity.getInvoiceTypeId());
        contractEntity.setInvoiceTypeName(changeEntity.getInvoiceTypeName());
        contractEntity.setContractTaxMny(changeEntity.getContractTaxMny());
        contractEntity.setContractMny(changeEntity.getContractMny());
        contractEntity.setContractTax(changeEntity.getContractTax());
        contractEntity.setEquipmentMny(changeEntity.getEquipmentMny());
        contractEntity.setEquipmentTaxMny(changeEntity.getEquipmentTaxMny());
        contractEntity.setEquipmentTax(changeEntity.getEquipmentTax());
        contractEntity.setOtherMny(changeEntity.getOtherMny());
        contractEntity.setOtherTaxMny(changeEntity.getOtherMny());
        contractEntity.setOtherTax(changeEntity.getOtherTax());
        contractEntity.setChangeStatus(ChangeStatusEnum.\u5df2\u53d8\u66f4.getCode());
        contractEntity.setChangeContractSignatureStatus(Integer.valueOf(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode()));
        contractEntity.setChangingMny(null);
        contractEntity.setChangingTaxMny(null);
        this.logger.info("1212-\u8fdb\u5165\u53d8\u66f4\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03------>\u5408\u540c\u63d0\u4ea4\uff0c\u7ebf\u4e0b\u7b7e\u8ba2\u76f4\u63a5\u4fee\u6539\u7b7e\u7ae0\u72b6\u6001");
        changeEntity.setSignatureStatus(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode());
        changeEntity.setContractPerformanceState(PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode());
        changeEntity.setEffectiveDate(new Date());
        if (filingFlag.booleanValue()) {
            changeEntity.setChangeFilingStatus(FilingStatusEnum.\u5df2\u5f52\u6863.getTypeCode());
            changeEntity.setFilingRef(0);
        }
        resp = this.attachmentApi.copyFilesFromSourceBillToTargetBill(changeBillId.toString(), CHANGE_BILL_TYPE, CHANGE_BILL_TYPE, contractEntity.getId().toString(), BILL_TYPE, BILL_TYPE);
        this.logger.info("resp---{}", (Object)JSONObject.toJSONString((Object)resp));
        this.changeService.saveOrUpdate((Object)changeEntity);
        this.logger.info("\u66f4\u65b0\u53d8\u66f4\u8868\u5408\u540c\u72b6\u6001\u548c\u6570\u636e,changeEntity---------->\uff1a {}", (Object)JSONObject.toJSONString((Object)((Object)changeEntity)));
        this.logger.info("\u66f4\u65b0\u53d8\u66f4\u8868\u6570\u636e\u5230\u4e3b\u5408\u540c\u5f00\u59cb----------->" + contractEntity.getChangeStatus());
        PurchaseContractEntity contractChangeEntity = (PurchaseContractEntity)((Object)BeanMapper.map((Object)((Object)changeEntity), PurchaseContractEntity.class));
        List<ChangeEquipmentDetailedEntity> changeDetailList = changeEntity.getDetailList();
        HashMap changDetailIdMap = new HashMap();
        if (CollectionUtils.isNotEmpty(changeDetailList)) {
            changeDetailList.forEach(changeDetailEntity -> changDetailIdMap.put(changeDetailEntity.getId(), changeDetailEntity.getSrcTblId()));
        }
        if (CollectionUtils.isNotEmpty(contractDetailList = contractChangeEntity.getDetailList())) {
            Long contractBid = null;
            for (EquipmentDetailedEntity contractDetailEntity : contractDetailList) {
                contractBid = (Long)changDetailIdMap.get(contractDetailEntity.getId());
                contractDetailEntity.setContractId(changeEntity.getContractId());
                contractDetailEntity.setChangeBid(contractDetailEntity.getId());
                if (null != contractDetailEntity.getParentId()) {
                    contractDetailEntity.setParentId((Long)changDetailIdMap.get(contractDetailEntity.getParentId()));
                }
                contractDetailEntity.setId(contractBid);
                contractDetailEntity.setVersion((Integer)contIdVersionMap.get(contractBid));
                contractDetailEntity.setChangeType(null);
            }
        }
        contractEntity.setDetailList(contractDetailList);
        List<ChangeOtherDetailedEntity> changeOtherCostList = changeEntity.getOtherCostList();
        HashMap changOtherCostIdMap = new HashMap();
        if (CollectionUtils.isNotEmpty(changeOtherCostList)) {
            changeOtherCostList.forEach(changeOtherCostEntity -> changOtherCostIdMap.put(changeOtherCostEntity.getId(), changeOtherCostEntity.getSrcTblId()));
        }
        if (CollectionUtils.isNotEmpty(contractOtherCostList = contractChangeEntity.getOtherCostList())) {
            Long contractBid = null;
            for (OtherDetailedEntity contractOtherCostEntity : contractOtherCostList) {
                contractBid = (Long)changOtherCostIdMap.get(contractOtherCostEntity.getId());
                contractOtherCostEntity.setChangeBid(contractOtherCostEntity.getId());
                contractOtherCostEntity.setId(contractBid);
                contractOtherCostEntity.setVersion((Integer)contIdVersionMap.get(contractBid));
                contractOtherCostEntity.setContractId(contractEntity.getId());
            }
        }
        contractEntity.setOtherCostList(contractOtherCostList);
        List<PurchaseContractClauseEntity> contractClauseList = contractEntity.getClauseList();
        List<PurchaseContractClauseEntity> contractChangeClauseList = contractChangeEntity.getClauseList();
        if (CollectionUtils.isNotEmpty(contractClauseList)) {
            this.logger.info("\u5220\u9664\u5408\u540c\u6761\u6b3e\u5b50\u8868\u6570\u636e: {}", (Object)JSONObject.toJSONString(contractClauseList));
            this.contractClauseService.deleteByIds(contractClauseList.stream().map(BaseEntity::getId).collect(Collectors.toList()));
            contractChangeClauseList.forEach(clauseEntity -> {
                clauseEntity.setChangeBid(clauseEntity.getId());
                clauseEntity.setId(null);
                clauseEntity.setRowState("add");
                clauseEntity.setContractId(contractEntity.getId());
            });
        }
        contractEntity.setClauseList(contractChangeClauseList);
        List<PurchaseContractPaymentClauseEntity> contractPayList = contractEntity.getPaymentList();
        List<PurchaseContractPaymentClauseEntity> pList = contractChangeEntity.getPaymentList();
        if (CollectionUtils.isNotEmpty(contractPayList)) {
            this.logger.info("\u5220\u9664\u5408\u540c\u4ed8\u6b3e\u9636\u6bb5\u5b50\u8868\u6570\u636e: {}", (Object)JSONObject.toJSONString(contractPayList));
            this.contractPaymentService.deleteByIds(contractPayList.stream().map(BaseEntity::getId).collect(Collectors.toList()));
            pList.forEach(item -> {
                item.setChangeBid(item.getId());
                item.setId(null);
                item.setRowState("add");
                item.setContractId(contractEntity.getId());
            });
        }
        contractEntity.setPaymentList(pList);
        this.contractService.saveOrUpdate((Object)contractEntity, false);
        this.contractService.pushContract((PurchaseContractVO)BeanMapper.map((Object)((Object)contractEntity), PurchaseContractVO.class));
        this.logger.info("\u66f4\u65b0\u5408\u540c\u8868\u6570\u636e\u6210\u529f,contractEntity---------->: {}", (Object)JSONObject.toJSONString((Object)((Object)contractEntity)));
        return CommonResponse.success((String)"\u53d8\u66f4\u5355\u751f\u6548\uff0c\u56de\u5199\u5408\u540c\u6210\u529f\uff01");
    }

    private CommonResponse copyFile(String srcBillId, String srcBillTypeCode, String targetBillId, String targetBillTypeCode, String srcAttachSourceType, boolean copyContractFile) {
        CommonResponse copyContractFileResp;
        CommonResponse copyContractAttachResp = this.attachmentApi.copyFilesFromSourceBillToTargetBill(srcBillId, srcBillTypeCode, srcAttachSourceType, targetBillId, targetBillTypeCode, srcAttachSourceType);
        if (!copyContractAttachResp.isSuccess()) {
            this.logger.info("\u540c\u6b65\u5408\u540c\u6587\u4ef6\u5931\u8d25--------------->srcBillId-{},srcBillTypeCode-{},srcSourceType-{},targetBillId-{},targetBillTypeCode-{},targetSourceType-{},\uff1a{}", new Object[]{srcBillId, srcBillTypeCode, "BT220323000000003", targetBillId, targetBillTypeCode, "BT220323000000003", copyContractAttachResp.getMsg()});
            this.logger.info("\u540c\u6b65\u9644\u4ef6\u7ba1\u7406\u4e2d\u7684\u9644\u4ef6\u5931\u8d25--------------->\u5931\u8d25\u4fe1\u606f------------>\uff1a{}", (Object)copyContractAttachResp.getMsg());
            return CommonResponse.error((String)("\u5ba1\u6279\u5931\u8d25\uff0c\u540c\u6b65\u9644\u4ef6\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + copyContractAttachResp.getMsg()));
        }
        if (copyContractFile && !(copyContractFileResp = this.attachmentApi.copyFilesFromSourceBillToTargetBill(srcBillId, srcBillTypeCode, BILL_TYPE, targetBillId, targetBillTypeCode, "BT220323000000003")).isSuccess()) {
            this.logger.info("\u540c\u6b65\u5408\u540c\u6587\u4ef6\u5931\u8d25--------------->srcBillId-{},srcBillTypeCode-{},srcSourceType-{},targetBillId-{},targetBillTypeCode-{},targetSourceType-{},\uff1a{}", new Object[]{srcBillId, srcBillTypeCode, BILL_TYPE, targetBillId, targetBillTypeCode, "BT220323000000003", copyContractFileResp.getMsg()});
            return CommonResponse.error((String)("\u5ba1\u6279\u5931\u8d25\uff0c\u540c\u6b65\u5408\u540c\u6587\u4ef6\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + copyContractFileResp.getMsg()));
        }
        return null;
    }

    @Override
    public ParamsCheckVO targetCostCtrl(ChangePurchaseContractVO changeContractVO) {
        ChangePurchaseContractVO contractVO1 = this.insertOrUpdate(changeContractVO, true);
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)wrapper.eq((Object)"contract_id", (Object)contractVO1.getContractId())).eq((Object)"dr", (Object)0)).orderByDesc((Object)"create_time");
        List list = this.changeService.list((Wrapper)wrapper);
        if (list.size() > 0) {
            contractVO1.setMainContractId(((ChangePurchaseContractEntity)((Object)list.get(0))).getId());
        } else {
            contractVO1.setMainContractId(changeContractVO.getContractId());
        }
        ExecutionVO executionVO = this.contractService.targetCost((PurchaseContractVO)BeanMapper.map((Object)contractVO1, PurchaseContractVO.class), CHANGE_BILL_TYPE, changeLinkUrl);
        this.logger.error("\u76ee\u6807\u6210\u672c\u63a8\u9001\u63a7\u5236" + JSONObject.toJSONString((Object)executionVO));
        CommonResponse response = this.executionApi.ctrlCheckVO(executionVO);
        ParamsCheckVO paramsCheckVO = this.checkParams(contractVO1, (ParamsCheckVO)response.getData());
        return paramsCheckVO;
    }

    @Override
    public ParamsCheckVO viewTargetCostCtrlInfo(Long id) {
        ChangePurchaseContractVO contractVO = this.queryDetail(id);
        ExecutionVO executionVO = this.contractService.targetCost((PurchaseContractVO)BeanMapper.map((Object)contractVO, PurchaseContractVO.class), CHANGE_BILL_TYPE, changeLinkUrl);
        this.logger.error("ss" + JSONObject.toJSONString((Object)executionVO));
        CommonResponse response = this.executionApi.ctrlCheckVO(executionVO);
        ParamsCheckVO paramsCheckVO = this.checkParams(contractVO, (ParamsCheckVO)response.getData());
        return paramsCheckVO;
    }

    @Override
    public ParamsCheckVO checkParams(ChangePurchaseContractVO vo, ParamsCheckVO paramsCheckVO2) {
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        if (null != this.checkParamsConstruction(vo)) {
            paramsCheckVOS.add(this.checkParamsConstruction(vo));
        }
        paramsCheckVOS.add(this.checkParamsMny(vo));
        if (paramsCheckVO2 != null) {
            paramsCheckVOS.add(paramsCheckVO2);
        }
        HashMap<String, List> map = new HashMap<String, List>();
        String[] paramsArray = new String[]{"alert", "warn", "none"};
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List checkDsVOS = (List)map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                    continue;
                }
                map.put(warnType, checkVO.getDataSource());
            }
        }
        for (String s : paramsArray) {
            if (!map.containsKey(s)) continue;
            paramsCheckVO.setWarnType(s);
            paramsCheckVO.setDataSource((List)map.get(s));
            if (CollectionUtils.isEmpty((Collection)paramsCheckVO.getDataSource())) {
                paramsCheckVO.setWarnType("none");
            }
            return paramsCheckVO;
        }
        return paramsCheckVO;
    }

    @Override
    public ParamsCheckVO checkParamsConstruction(ChangePurchaseContractVO vo) {
        CommonResponse response = this.paramCheckApi.paramsCheck(vo.getProjectId(), vo.getContractId(), vo.getContractTaxMny());
        return (ParamsCheckVO)response.getData();
    }

    @Override
    public ParamsCheckVO checkParamsMny(ChangePurchaseContractVO vo) {
        BigDecimal changeMoney = vo.getChangeMny() == null ? BigDecimal.ZERO : vo.getChangeMny();
        BigDecimal contractTaxMny = vo.getBaseTaxMny() == null ? BigDecimal.ZERO : vo.getBaseTaxMny();
        BigDecimal totalChangeMoney = changeMoney;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"contract_id", (Object)vo.getContractId());
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.in((Object)"bill_state", new Object[]{1, 3});
        query.eq((Object)"signature_status", (Object)SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode());
        List list = this.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (ChangePurchaseContractEntity changeEntity : list) {
                totalChangeMoney = ComputeUtil.safeAdd((BigDecimal)changeEntity.getChangeMny(), (BigDecimal)totalChangeMoney);
            }
        }
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
        CommonResponse billParamByCode = this.paramConfigApi.getBillParamByCode(CHECK_PARAM_CODE);
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            BillParamVO billParamVO = (BillParamVO)billParamByCode.getData();
            BigDecimal roleValue = billParamVO.getRoleValue();
            BigDecimal comMny = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)contractTaxMny, (BigDecimal)roleValue), (BigDecimal)new BigDecimal("100")).setScale(2, 4);
            paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
            if (totalChangeMoney.compareTo(comMny) > 0) {
                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                paramsCheckDsVO.setWarnItem("\u53d8\u66f4\u8d85\u5408\u540c\u91d1\u989d");
                paramsCheckDsVO.setWarnName("\u7d2f\u8ba1\u53d8\u66f4\u91d1\u989d\u5927\u4e8e\u5408\u540c\u91d1\u989d");
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("\u672c\u6b21\u53d8\u66f4\u91d1\u989d\uff1a").append(changeMoney.setScale(2, 4)).append("\u5143\uff0c\u542b\u672c\u6b21\u7d2f\u8ba1\u53d8\u66f4\u91d1\u989d\uff1a").append(totalChangeMoney.setScale(2, 4)).append("\u5143\uff0c\u5408\u540c\u91d1\u989d*").append(roleValue).append("%:").append(comMny.setScale(2, 4)).append("\u5143\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(ComputeUtil.safeSub((BigDecimal)totalChangeMoney, (BigDecimal)comMny).setScale(2, 4)).append("\u5143");
                paramsCheckDsVO.setContent(stringBuffer.toString());
                checkDsVOS.add(paramsCheckDsVO);
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        paramsCheckVO.setDataSource(checkDsVOS);
        return paramsCheckVO;
    }
}

