/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.purchase.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.contractbase.api.IParamCheckApi;
import com.ejianc.business.contractbase.filing.enums.FilingStatusEnum;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractPropertyEnum;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.purchase.bean.EquipmentDetailedEntity;
import com.ejianc.business.purchase.bean.OtherDetailedEntity;
import com.ejianc.business.purchase.bean.PurchaseContractClauseEntity;
import com.ejianc.business.purchase.bean.PurchaseContractEntity;
import com.ejianc.business.purchase.bean.PurchaseContractPaymentClauseEntity;
import com.ejianc.business.purchase.enums.ChangeStatusEnum;
import com.ejianc.business.purchase.enums.DraftTypeEnum;
import com.ejianc.business.purchase.enums.PerformanceStatusEnum;
import com.ejianc.business.purchase.enums.SignatureStatusEnum;
import com.ejianc.business.purchase.mapper.PurchaseContractMapper;
import com.ejianc.business.purchase.service.IChangePurchaseContractService;
import com.ejianc.business.purchase.service.IPurchaseContractFreezeService;
import com.ejianc.business.purchase.service.IPurchaseContractRelieveService;
import com.ejianc.business.purchase.service.IPurchaseContractService;
import com.ejianc.business.purchase.vo.EquipmentDetailedVO;
import com.ejianc.business.purchase.vo.PurchaseContractVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.vo.DetailExecutionVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.business.tender.api.ITenderSubApi;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="purchaseContractService")
public class PurchaseContractServiceImpl
extends BaseServiceImpl<PurchaseContractMapper, PurchaseContractEntity>
implements IPurchaseContractService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IParamCheckApi paramCheckApi;
    @Autowired
    private ITenderSubApi tenderApi;
    int unOccupyState = 0;
    int occupyState = 1;
    private static final String BILL_TYPE = "BT220323000000001";
    private static final String CHANGE_BILL_TYPE = "BT220323000000002";
    private static final String BILL_CODE = "PURCBASE_CONTRACT";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPurchaseContractService service;
    @Autowired
    private IChangePurchaseContractService changeService;
    @Autowired
    private IPurchaseContractRelieveService relieveService;
    @Autowired
    private IPurchaseContractFreezeService freezeService;
    @Autowired
    private IParamConfigApi paramConfigApi;
    private static final String CHECK_PARAM_CODE = "P-06vj8393";
    @Value(value="${common.env.base-host}")
    private String BaseHost;
    @Autowired
    private IContractPoolApi contractPoolApi;
    @Autowired
    private IExecutionApi executionApi;
    @Autowired
    private IShareMaterialApi materialApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    private static final String linkUrl = "/ejc-proequipmentp-frontend/#/machineryPurchaseContract/card?id=";
    private static final String changeLinkUrl = "ejc-proequipmentp-frontend/#/machineryPurchaseContract/contractChangeCard?id=";

    @Override
    public PurchaseContractVO insertOrUpdate(PurchaseContractVO contractVO, String authority, Boolean isControl) {
        CommonResponse orgResponse;
        PurchaseContractEntity entity = (PurchaseContractEntity)((Object)BeanMapper.map((Object)contractVO, PurchaseContractEntity.class));
        if (StringUtils.isEmpty((CharSequence)entity.getParentOrgCode()) && entity.getParentOrgId() != null && (orgResponse = this.iOrgApi.getOneById(entity.getParentOrgId())).isSuccess()) {
            OrgVO orgVO = (OrgVO)orgResponse.getData();
            entity.setParentOrgCode(orgVO.getCode());
            contractVO.setParentOrgCode(orgVO.getCode());
        }
        if (!isControl.booleanValue()) {
            if (entity.getId() == null) {
                if (StringUtils.isBlank((CharSequence)entity.getBillCode())) {
                    BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)contractVO);
                    CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
                    if (!billCode.isSuccess()) {
                        this.logger.error("\u4fdd\u5b58\u5408\u540c\u5931\u8d25\uff0c\u81ea\u52a8\u751f\u6210\u5408\u540c\u5408\u540c\u5931\u8d25: {}", (Object)billCode.getMsg());
                        throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                    }
                    entity.setBillCode((String)billCode.getData());
                } else if (this.checkSameBillCode((PurchaseContractVO)BeanMapper.map((Object)((Object)entity), PurchaseContractVO.class)).booleanValue()) {
                    throw new BusinessException("\u7f16\u7801\u91cd\u590d\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
                }
                if (entity.getId() == null) {
                    if (entity.getFilingStatus() == null) {
                        entity.setFilingStatus(FilingStatusEnum.\u672a\u5f52\u6863.getTypeCode());
                    }
                    entity.setFilingRef(0);
                }
                entity.setSignatureStatus(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode());
                entity.setSupplementFlag(0);
                entity.setChangeStatus(ChangeStatusEnum.\u672a\u53d8\u66f4.getCode());
                entity.setMainContractCreateDate(new Date());
                this.tenderApi.updateById(entity.getTargetResultId(), Integer.valueOf(this.occupyState));
            } else {
                PurchaseContractEntity oldPurchaseContractEntity = (PurchaseContractEntity)((Object)super.selectById((Serializable)entity.getId()));
                if (null != entity.getTargetResultId() && !entity.getTargetResultId().equals(oldPurchaseContractEntity.getTargetResultId())) {
                    this.tenderApi.updateById(oldPurchaseContractEntity.getTargetResultId(), Integer.valueOf(this.unOccupyState));
                    this.tenderApi.updateById(entity.getTargetResultId(), Integer.valueOf(this.occupyState));
                }
                if (StringUtils.isBlank((CharSequence)entity.getBillCode())) {
                    entity.setBillCode(oldPurchaseContractEntity.getBillCode());
                } else if (this.checkSameBillCode((PurchaseContractVO)BeanMapper.map((Object)((Object)entity), PurchaseContractVO.class)).booleanValue()) {
                    throw new BusinessException("\u7f16\u7801\u91cd\u590d\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
                }
            }
        }
        entity.setContractMny(contractVO.getContractMny() == null ? BigDecimal.ZERO : contractVO.getContractMny());
        entity.setContractTaxMny(contractVO.getContractTaxMny() == null ? BigDecimal.ZERO : contractVO.getContractTaxMny());
        entity.setContractTax(contractVO.getContractTax() == null ? BigDecimal.ZERO : contractVO.getContractTax());
        entity.setEquipmentTaxMny(contractVO.getEquipmentTaxMny() == null ? BigDecimal.ZERO : contractVO.getEquipmentTaxMny());
        entity.setEquipmentMny(contractVO.getEquipmentMny() == null ? BigDecimal.ZERO : contractVO.getEquipmentMny());
        entity.setEquipmentTax(contractVO.getEquipmentTax() == null ? BigDecimal.ZERO : contractVO.getEquipmentTax());
        entity.setOtherTaxMny(contractVO.getOtherTaxMny() == null ? BigDecimal.ZERO : contractVO.getOtherTaxMny());
        entity.setOtherMny(contractVO.getOtherMny() == null ? BigDecimal.ZERO : contractVO.getOtherMny());
        entity.setOtherTax(contractVO.getOtherTax() == null ? BigDecimal.ZERO : contractVO.getOtherTax());
        entity.setBaseMny(entity.getContractMny() == null ? BigDecimal.ZERO : entity.getContractMny());
        entity.setBaseTaxMny(entity.getContractTaxMny() == null ? BigDecimal.ZERO : entity.getContractTaxMny());
        entity.setBeforeChangeMny(entity.getContractMny() == null ? BigDecimal.ZERO : entity.getContractMny());
        entity.setBeforeChangeTaxMny(entity.getContractTaxMny() == null ? BigDecimal.ZERO : entity.getContractTaxMny());
        if (entity.getContractFileId() != null) {
            if (entity.getId() != null) {
                PurchaseContractEntity contract = (PurchaseContractEntity)((Object)this.service.getById(entity.getId()));
                if (contract != null && !DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().toString().equals(contract.getDraftType()) && DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().toString().equals(entity.getDraftType())) {
                    this.delContractFile(entity.getContractFileId(), authority);
                    entity.setContractFileId(null);
                    entity.setContractFilePath(null);
                }
            } else if (DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().toString().equals(entity.getDraftType())) {
                this.delContractFile(entity.getContractFileId(), authority);
                entity.setContractFileId(null);
                entity.setContractFilePath(null);
            }
        }
        if (DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().toString().equals(entity.getDraftType()) || DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349\u4e0d\u4f7f\u7528\u7535\u5b50\u7b7e\u7ae0.getCode().toString().equals(entity.getDraftType())) {
            entity.setContractFileSyncFlag(false);
        }
        if (!isControl.booleanValue()) {
            super.saveOrUpdate((Object)entity, false);
            ExecutionVO executionVO = this.service.targetCost((PurchaseContractVO)BeanMapper.map((Object)((Object)entity), PurchaseContractVO.class), BILL_TYPE, linkUrl);
            this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO));
            CommonResponse response = this.executionApi.aggPush(executionVO);
            if (!response.isSuccess()) {
                throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
            }
        }
        if (null == entity.getId() && isControl.booleanValue()) {
            entity.setId(IdWorker.getId());
            return (PurchaseContractVO)BeanMapper.map((Object)((Object)entity), PurchaseContractVO.class);
        }
        return this.queryDetail(entity.getId());
    }

    @Override
    public ExecutionVO targetCost(PurchaseContractVO contractVO, String BillType, String linkUrl) {
        List contractDetailList;
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        ArrayList<DetailExecutionVO> detailList = new ArrayList<DetailExecutionVO>();
        totalVO.setSourceId(contractVO.getId());
        totalVO.setTenantId(contractVO.getTenantId());
        totalVO.setBillCode(contractVO.getBillCode());
        totalVO.setBillType(BillType);
        totalVO.setBussinessType(BussinessTypeEnum.\u8bbe\u5907\u91c7\u8d2d\u5408\u540c.getCode());
        totalVO.setBillCategory(BillCategoryEnum.\u5408\u540c.getCode());
        totalVO.setProjectId(contractVO.getProjectId());
        totalVO.setOrgId(contractVO.getOrgId());
        totalVO.setMoney(contractVO.getContractMny());
        totalVO.setTaxMoney(contractVO.getContractTaxMny());
        totalVO.setLinkUrl(this.BaseHost + linkUrl + contractVO.getId());
        if (BillType.equals(BILL_TYPE)) {
            contractDetailList = contractVO.getDetailList();
        } else {
            totalVO.setLastSourceId(contractVO.getMainContractId());
            contractDetailList = this.changeService.queryDetail(contractVO.getId()).getDetailList();
        }
        if (contractDetailList != null) {
            for (EquipmentDetailedVO planDetailVO : contractVO.getDetailList()) {
                if (planDetailVO.getRowState() != null && planDetailVO.getRowState().equals("del")) continue;
                DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                detailExecutionVO.setSourceId(Long.valueOf(planDetailVO.getId() == null ? IdWorker.getId() : planDetailVO.getId()));
                detailExecutionVO.setSourceBillId(contractVO.getId());
                detailExecutionVO.setCategoryId(planDetailVO.getDocCategoryId());
                detailExecutionVO.setCategoryName(planDetailVO.getEquipmentType());
                if (planDetailVO.getDocId() == null) {
                    detailExecutionVO.setCategoryFlag(Boolean.valueOf(true));
                    detailExecutionVO.setDocId(planDetailVO.getDocCategoryId());
                } else {
                    detailExecutionVO.setCategoryFlag(Boolean.valueOf(false));
                    detailExecutionVO.setDocId(planDetailVO.getDocId());
                }
                detailExecutionVO.setCode(planDetailVO.getEquipmentCode());
                detailExecutionVO.setCategoryContainFlag(Boolean.valueOf(false));
                MaterialCategoryVO categoryVO = (MaterialCategoryVO)this.materialApi.queryCategoryById(planDetailVO.getDocId()).getData();
                if (categoryVO == null) {
                    detailExecutionVO.setCategoryInnerCode(null);
                    detailExecutionVO.setCategoryCode(null);
                } else {
                    detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                    detailExecutionVO.setCategoryCode(categoryVO.getCode());
                }
                detailExecutionVO.setDocType(DocTypeEnum.\u8bbe\u5907\u6863\u6848.getCode());
                detailExecutionVO.setName(planDetailVO.getEquipmentName());
                detailExecutionVO.setUnitName(planDetailVO.getCompany());
                detailExecutionVO.setNum(BigDecimal.valueOf(planDetailVO.getPurchaseNum()));
                detailExecutionVO.setMoney(planDetailVO.getPurchaseAmountNoTax());
                detailExecutionVO.setSpec(planDetailVO.getSpec());
                detailExecutionVO.setTaxMoney(planDetailVO.getPurchaseAmount());
                detailExecutionVO.setPrice(planDetailVO.getPurchasePricetNoTax());
                detailExecutionVO.setTaxPrice(planDetailVO.getPurchasePrice());
                detailExecutionVO.setTaxRate(planDetailVO.getTaxRate());
                detailList.add(detailExecutionVO);
            }
        }
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }

    @Override
    public void pushContract(PurchaseContractVO contractVO) {
        ContractPoolVO data = new ContractPoolVO();
        try {
            BeanConvertorUtil.convert((Object)contractVO, (Object)data);
            data.setPcCardUrl(linkUrl + contractVO.getId());
            data.setSourceType(ContractTypeEnum.\u8bbe\u5907\u91c7\u8d2d.getTypeCode());
            data.setContractProperty(ContractPropertyEnum.\u652f\u51fa\u5408\u540c.getPropertyCode());
            this.logger.info("\u5f00\u59cb\u63a8\u9001\u5408\u540c\u6c60>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            this.logger.info("\u63a8\u9001\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString((Object)data));
            CommonResponse transDataResp = this.contractPoolApi.saveOrUpdateContract(data);
            this.logger.info("\u63a8\u9001\u5408\u540c\u6c60\u7ed3\u675f\uff0c\u63a8\u9001\u7ed3\u679c\uff1a{}<<<<<<<<<<<<<<<<<<<<<<<<<<<<<", (Object)transDataResp.isSuccess());
            if (!transDataResp.isSuccess()) {
                this.logger.error("\u5408\u540cid-{}\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff0c{}", (Object)contractVO.getId(), (Object)transDataResp.getMsg());
            }
        }
        catch (Exception e) {
            this.logger.error("\u5408\u540c-{}\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff0c", (Object)contractVO.getId(), (Object)e);
        }
    }

    @Override
    public Boolean delContractFile(Long fileId, String authority) {
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, String> header = new HashMap<String, String>();
        params.put("ids", fileId.toString());
        header.put("authority", authority);
        String delRespStr = null;
        try {
            delRespStr = HttpTookit.get((String)(this.BaseHost + "ejc-file-web/attachment/delete"), params, header, (int)10000, (int)10000);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CommonResponse delResp = (CommonResponse)JSONObject.parseObject(delRespStr, CommonResponse.class);
        if (delResp != null) {
            this.logger.info("\u5728\u7ebf\u8d77\u8349\uff0c\u5220\u9664\u4e0a\u4f20\u5408\u540c\u8fd4\u56de\u4fe1\u606f\uff1a" + delResp.getMsg());
        }
        return true;
    }

    private void resetPid(List<EquipmentDetailedEntity> detailList) {
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(detailList)) {
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (EquipmentDetailedEntity cdEntity : detailList) {
                if (cdEntity.getId() == null) {
                    cdEntity.setId(IdWorker.getId());
                }
                idMap.put(cdEntity.getDocId().toString(), cdEntity.getId());
                cdEntity.setParentId(null);
            }
            for (EquipmentDetailedEntity cdEntity : detailList) {
                if (!StringUtils.isNotEmpty((CharSequence)cdEntity.getDocId().toString())) continue;
                cdEntity.setParentId((Long)idMap.get(cdEntity.getDocId()));
            }
        }
    }

    @Override
    public PurchaseContractVO queryDetail(Long id) {
        HashMap orderMap = new HashMap();
        LinkedHashMap orderParams = new LinkedHashMap();
        orderMap.put("detailList", orderParams);
        orderMap.put("otherCostList", orderParams);
        PurchaseContractEntity contractEntity = (PurchaseContractEntity)((Object)super.selectById((Serializable)id, orderMap));
        PurchaseContractVO contractVO = (PurchaseContractVO)BeanMapper.map((Object)((Object)contractEntity), PurchaseContractVO.class);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)contractVO.getDetailList())) {
            contractVO.setDetailList(contractVO.getDetailList());
        }
        return contractVO;
    }

    @Override
    public PurchaseContractVO querySupplementRecord(Long id) {
        PurchaseContractEntity contractEntity = (PurchaseContractEntity)((Object)super.selectById((Serializable)id));
        PurchaseContractVO contractVO = new PurchaseContractVO();
        BigDecimal contractTaxMny = contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny();
        contractVO.setId(id);
        contractVO.setContractTaxMny(contractTaxMny);
        contractVO.setChangeStatus(contractEntity.getChangeStatus());
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"main_contract_id", (Object)id);
        query.eq((Object)"contract_performance_state", (Object)PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode());
        query.orderByDesc((Object)"create_time");
        List supplementEntities = super.list((Wrapper)query);
        contractVO.setSupplementList(BeanMapper.mapList((Iterable)supplementEntities, PurchaseContractVO.class));
        contractVO.setSupplementNum(Integer.valueOf(supplementEntities.size()));
        BigDecimal allSupplementAmt = BigDecimal.ZERO;
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)supplementEntities)) {
            for (PurchaseContractEntity c : supplementEntities) {
                if (c.getContractTaxMny() == null) continue;
                allSupplementAmt = c.getContractTaxMny().add(allSupplementAmt);
            }
        }
        contractVO.setAllSupplementMny(allSupplementAmt);
        contractVO.setSupplementMnyRate(BigDecimal.ZERO.compareTo(contractTaxMny) != 0 ? allSupplementAmt.divide(contractTaxMny, 8, 4).multiply(new BigDecimal(100)) : BigDecimal.ZERO);
        if (SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode().equals(contractEntity.getSignatureStatus()) && (BillStateEnum.PASSED_STATE.getBillStateCode().equals(contractEntity.getBillState()) || BillStateEnum.COMMITED_STATE.getBillStateCode().equals(contractEntity.getBillState())) && !PerformanceStatusEnum.\u5df2\u89e3\u9664.getCode().equals(contractEntity.getContractPerformanceState()) && !PerformanceStatusEnum.\u5df2\u51bb\u7ed3.getCode().equals(contractEntity.getContractPerformanceState()) && !PerformanceStatusEnum.\u5df2\u5c01\u8d26.getCode().equals(contractEntity.getContractPerformanceState())) {
            contractVO.setEditFlag(this.addSupplementFlag(id));
        }
        return contractVO;
    }

    @Override
    public Boolean addSupplementFlag(Long id) {
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(PurchaseContractEntity::getMainContractId, (Object)id);
        lambda.eq(PurchaseContractEntity::getSupplementFlag, (Object)PurchaseContractVO.CONTRACT_TYPE_SUPPLEMENT);
        lambda.and(l -> (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)l.ne(PurchaseContractEntity::getSignatureStatus, (Object)String.valueOf(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode()))).or(c -> (LambdaQueryWrapper)c.notIn(PurchaseContractEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()}))).or(c -> (LambdaQueryWrapper)c.eq(PurchaseContractEntity::getContractPerformanceState, (Object)String.valueOf(PerformanceStatusEnum.\u5df2\u89e3\u9664.getCode()))));
        List supplementList = super.list((Wrapper)lambda);
        return supplementList.size() == 0;
    }

    @Override
    public PurchaseContractVO saveOrUpdateSupplement(PurchaseContractVO contractVO, Boolean isControl) {
        CommonResponse orgResponse;
        PurchaseContractEntity entity = null;
        if (StringUtils.isEmpty((CharSequence)contractVO.getParentOrgCode()) && contractVO.getParentOrgId() != null && (orgResponse = this.iOrgApi.getOneById(contractVO.getParentOrgId())).isSuccess()) {
            OrgVO orgVO = (OrgVO)orgResponse.getData();
            contractVO.setParentOrgCode(orgVO.getCode());
        }
        if (StringUtils.isNotBlank((CharSequence)contractVO.getBillCode()) && this.checkSameBillCode(contractVO).booleanValue()) {
            throw new BusinessException("\u7f16\u7801\u91cd\u590d\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        if (contractVO.getId() == null) {
            QueryParam param = new QueryParam();
            param.getParams().put("main_contract_id", new Parameter("eq", (Object)contractVO.getMainContractId()));
            List supplementList = this.service.queryList(param, false);
            supplementList.stream().forEach(e -> {
                if (!e.getSignatureStatus().equals(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode()) || !e.getBillState().equals(BillStateEnum.COMMITED_STATE.getBillStateCode()) && !e.getBillState().equals(BillStateEnum.PASSED_STATE.getBillStateCode())) {
                    throw new BusinessException("\u8be5\u5408\u540c\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u8865\u5145\u534f\u8bae!");
                }
            });
            String supplementNum = "";
            supplementNum = supplementList.size() < 9 ? supplementNum + "0" + (supplementList.size() + 1) : supplementNum + (supplementList.size() + 1);
            PurchaseContractEntity mainContract = (PurchaseContractEntity)((Object)this.service.selectById(contractVO.getMainContractId()));
            if (null == mainContract) {
                throw new BusinessException("\u672a\u627e\u5230\u4e3b\u5408\u540c\uff0c\u4e0d\u80fd\u521b\u5efa\u8865\u5145\u534f\u8bae\uff01");
            }
            entity = (PurchaseContractEntity)((Object)BeanMapper.map((Object)((Object)mainContract), PurchaseContractEntity.class));
            this.clearBaseFields(entity);
            entity.setSignatureStatus(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode());
            entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            entity.setBillCode(entity.getBillCode() + "2" + supplementNum);
            entity.setContractName(contractVO.getContractName());
            entity.setSignDate(contractVO.getSignDate());
            entity.setContractPerformanceState(contractVO.getContractPerformanceState());
            entity.setDraftType(contractVO.getDraftType());
            entity.setTaxRate(contractVO.getTaxRate());
            entity.setFirstPartyEmployeeId(contractVO.getFirstPartyEmployeeId());
            entity.setFirstPartyEmployee(contractVO.getFirstPartyEmployee());
            entity.setContractCode(contractVO.getContractCode());
            entity.setContractFilePath(contractVO.getContractFilePath());
            entity.setContractFileId(contractVO.getContractFileId());
            entity.setContractTemplateId(contractVO.getContractTemplateId());
            entity.setContractTemplateName(contractVO.getContractTemplateName());
            entity.setContractFileVersionId(contractVO.getContractFileVersionId());
            entity.setContractFileVersion(contractVO.getContractFileVersion());
            entity.setSupplementDescribe(contractVO.getSupplementDescribe());
            entity.setContractMny(contractVO.getContractMny() == null ? BigDecimal.ZERO : contractVO.getContractMny());
            entity.setContractTaxMny(contractVO.getContractTaxMny() == null ? BigDecimal.ZERO : contractVO.getContractTaxMny());
            entity.setContractTax(contractVO.getContractTax() == null ? BigDecimal.ZERO : contractVO.getContractTax());
            entity.setEquipmentTaxMny(contractVO.getEquipmentTaxMny() == null ? BigDecimal.ZERO : contractVO.getEquipmentTaxMny());
            entity.setEquipmentMny(contractVO.getEquipmentMny() == null ? BigDecimal.ZERO : contractVO.getEquipmentMny());
            entity.setEquipmentTax(contractVO.getEquipmentTax() == null ? BigDecimal.ZERO : contractVO.getEquipmentTax());
            entity.setOtherMny(contractVO.getOtherMny() == null ? BigDecimal.ZERO : contractVO.getOtherMny());
            entity.setOtherTaxMny(contractVO.getOtherTaxMny() == null ? BigDecimal.ZERO : contractVO.getOtherTaxMny());
            entity.setOtherTax(contractVO.getOtherTax() == null ? BigDecimal.ZERO : contractVO.getOtherTax());
            entity.setDetailList(BeanMapper.mapList((Iterable)contractVO.getDetailList(), EquipmentDetailedEntity.class));
            entity.setOtherCostList(BeanMapper.mapList((Iterable)contractVO.getOtherCostList(), OtherDetailedEntity.class));
            entity.setClauseList(BeanMapper.mapList((Iterable)contractVO.getClauseList(), PurchaseContractClauseEntity.class));
            entity.setPaymentList(BeanMapper.mapList((Iterable)contractVO.getPaymentList(), PurchaseContractPaymentClauseEntity.class));
            entity.setChangingMny(null);
            entity.setChangeCode(null);
            entity.setChangeVersion(null);
            entity.setChangeId(null);
            entity.setChangeStatus(ChangeStatusEnum.\u672a\u53d8\u66f4.getCode());
            entity.setSupplementFlag(PurchaseContractVO.CONTRACT_TYPE_SUPPLEMENT);
            entity.setMainContractId(contractVO.getMainContractId());
            entity.setMainContractCode(contractVO.getMainContractCode());
            entity.setMainContractName(contractVO.getMainContractName());
        } else {
            entity = (PurchaseContractEntity)((Object)BeanMapper.map((Object)contractVO, PurchaseContractEntity.class));
        }
        entity.setBaseMny(entity.getContractMny());
        entity.setBaseTaxMny(entity.getContractTaxMny());
        entity.setBeforeChangeMny(entity.getContractMny());
        entity.setBeforeChangeTaxMny(entity.getContractTaxMny());
        entity.setAttachIds(contractVO.getAttachIds());
        if (FilingStatusEnum.\u5df2\u5f52\u6863.getTypeCode().equals(entity.getFilingStatus())) {
            entity.setFilingRef(0);
        }
        this.checkContract(entity.getMainContractId(), entity.getId());
        if (!isControl.booleanValue()) {
            this.service.saveOrUpdate((Object)entity, false);
            ExecutionVO executionVO = this.service.targetCost((PurchaseContractVO)BeanMapper.map((Object)((Object)entity), PurchaseContractVO.class), BILL_TYPE, linkUrl);
            this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO));
            CommonResponse response = this.executionApi.aggPush(executionVO);
            if (!response.isSuccess()) {
                throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
            }
            return this.queryDetail(entity.getId());
        }
        if (entity.getId() == null) {
            entity.setId(IdWorker.getId());
        }
        return (PurchaseContractVO)BeanMapper.map((Object)((Object)entity), PurchaseContractVO.class);
    }

    private void clearBaseFields(PurchaseContractEntity entity) {
        entity.setId(null);
        entity.setCreateTime(null);
        entity.setCreateUserCode(null);
        entity.setUpdateTime(null);
        entity.setUpdateUserCode(null);
        entity.setCommitDate(null);
        entity.setCommitUserCode(null);
        entity.setCommitDate(null);
        entity.setCommitUserName(null);
        entity.setEffectiveDate(null);
    }

    @Override
    public PurchaseContractVO addConvertByConId(Long contractId) {
        PurchaseContractEntity contractVO = (PurchaseContractEntity)((Object)super.selectById((Serializable)contractId));
        PurchaseContractVO supplementVO = new PurchaseContractVO();
        supplementVO.setMainContractName(contractVO.getContractName());
        supplementVO.setMainContractCode(contractVO.getBillCode());
        supplementVO.setMainContractId(contractId);
        supplementVO.setSupplementFlag(PurchaseContractVO.CONTRACT_TYPE_SUPPLEMENT);
        supplementVO.setContractCategoryId(contractVO.getContractCategoryId());
        supplementVO.setProjectName(contractVO.getProjectName());
        supplementVO.setProjectId(contractVO.getProjectId());
        supplementVO.setFirstPartyId(contractVO.getFirstPartyId());
        supplementVO.setFirstPartyName(contractVO.getFirstPartyName());
        supplementVO.setSupplierId(contractVO.getSupplierId());
        supplementVO.setSupplierName(contractVO.getSupplierName());
        supplementVO.setOrgId(contractVO.getOrgId());
        supplementVO.setOrgName(contractVO.getOrgName());
        supplementVO.setParentOrgId(contractVO.getParentOrgId());
        supplementVO.setParentOrgName(contractVO.getParentOrgName());
        supplementVO.setParentOrgCode(contractVO.getParentOrgCode());
        supplementVO.setDraftType(DraftTypeEnum.\u4e0a\u4f20\u5408\u540c.getCode().toString());
        supplementVO.setContractName(contractVO.getContractName() + "\u8865\u5145\u534f\u8bae");
        supplementVO.setFilingStatus(FilingStatusEnum.\u672a\u5f52\u6863.getTypeCode());
        return supplementVO;
    }

    @Override
    public Map<String, Object> countContractAmount(QueryParam param) {
        Map<String, Integer> resp = new HashMap();
        QueryWrapper wrapper = PurchaseContractServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.select(new String[]{"sum(base_tax_mny) as baseTaxMny, sum(contract_tax_mny) as contractTaxMny"});
        resp = super.getMap((Wrapper)wrapper);
        if (null == resp) {
            resp = new HashMap();
            resp.put("baseTaxMny", 0);
            resp.put("contractTaxMny", 0);
        }
        return resp;
    }

    @Override
    public CommonResponse<String> deleteByIds(List<PurchaseContractVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            ArrayList<TotalExecutionVO> totalExecutionVOList = new ArrayList<TotalExecutionVO>();
            for (PurchaseContractVO contractVO2 : vos) {
                PurchaseContractEntity contractEntity = (PurchaseContractEntity)((Object)this.service.selectById(contractVO2.getId()));
                ExecutionVO executionVO = this.service.targetCost((PurchaseContractVO)BeanMapper.map((Object)((Object)contractEntity), PurchaseContractVO.class), BILL_TYPE, linkUrl);
                totalExecutionVOList.add(executionVO.getTotalVO());
                this.logger.info("\u76ee\u6807\u6210\u672c\u5220\u9664\u6570\u636e" + JSON.toJSONString(totalExecutionVOList));
                CommonResponse response = this.executionApi.aggDel(totalExecutionVOList);
                if (response.isSuccess()) continue;
                throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
            }
        }
        vos.forEach(contractVO -> {
            PurchaseContractEntity contractEntity = (PurchaseContractEntity)((Object)((Object)super.getById((Serializable)contractVO.getId())));
            if (null != contractEntity.getTargetResultId()) {
                // empty if block
            }
        });
        this.service.removeByIds(vos.stream().map(PurchaseContractVO::getId).collect(Collectors.toList()), false);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    private Boolean checkSameBillCode(PurchaseContractVO contractVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(PurchaseContractEntity::getBillCode, (Object)contractVO.getBillCode());
        lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
        if (null != contractVO.getId() && contractVO.getId() > 0L) {
            lambda.ne(BaseEntity::getId, (Object)contractVO.getId());
        }
        return super.list((Wrapper)lambda).size() > 0;
    }

    @Override
    public boolean checkContract(Long id, Long otherId) {
        List contractChangeEntityList;
        List<Integer> billStateList = Arrays.asList(BillStateEnum.UNCOMMITED_STATE.getBillStateCode(), BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(), BillStateEnum.UNAPPROVED.getBillStateCode(), BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode());
        QueryParam supplementQueryParam = new QueryParam();
        supplementQueryParam.getParams().put("mainContractId", new Parameter("eq", (Object)id));
        if (otherId != null) {
            supplementQueryParam.getParams().put("id", new Parameter("ne", (Object)otherId));
        }
        supplementQueryParam.getParams().put("signatureStatus", new Parameter("ne", (Object)SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode()));
        List supplementContractList = super.queryList(supplementQueryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)supplementContractList)) {
            throw new BusinessException("\u5b58\u5728\u672a\u751f\u6548\u7684\u8865\u5145\u534f\u8bae\uff01");
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)id));
        queryParam.getParams().put("signatureStatus", new Parameter("ne", (Object)SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode()));
        if (otherId != null) {
            queryParam.getParams().put("id", new Parameter("ne", (Object)otherId));
        }
        if (CollectionUtils.isNotEmpty((Collection)(contractChangeEntityList = this.changeService.queryList(queryParam, false)))) {
            throw new BusinessException("\u5b58\u5728\u672a\u751f\u6548\u7684\u53d8\u66f4\u5408\u540c\uff01");
        }
        List relieveEntityList = this.relieveService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)relieveEntityList)) {
            throw new BusinessException("\u5b58\u5728\u672a\u751f\u6548\u7684\u5408\u540c\u89e3\u9664\u5355\u636e\uff01");
        }
        queryParam.getParams().remove("signatureStatus");
        queryParam.getParams().put("billState", new Parameter("in", billStateList));
        List freezeEntityList = this.freezeService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)freezeEntityList)) {
            throw new BusinessException("\u5b58\u5728\u672a\u751f\u6548\u7684\u5408\u540c\u51bb\u7ed3\u6216\u5408\u540c\u89e3\u51bb\u5355\u636e\uff01");
        }
        return true;
    }

    @Override
    public ParamsCheckVO targetCostCtrl(PurchaseContractVO contractVO, String authority) {
        PurchaseContractVO contractVO1 = contractVO.getSupplementFlag() != null && contractVO.getSupplementFlag() == 1 ? this.saveOrUpdateSupplement(contractVO, true) : this.insertOrUpdate(contractVO, authority, true);
        ExecutionVO executionVO = this.service.targetCost((PurchaseContractVO)BeanMapper.map((Object)contractVO1, PurchaseContractVO.class), BILL_TYPE, linkUrl);
        this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO));
        this.logger.error("ss" + JSONObject.toJSONString((Object)executionVO));
        CommonResponse response = this.executionApi.ctrlCheckVO(executionVO);
        ParamsCheckVO paramsCheckVO = this.checkParams(contractVO, (ParamsCheckVO)response.getData());
        return paramsCheckVO;
    }

    @Override
    public ParamsCheckVO viewTargetCostCtrlInfo(Long id) {
        PurchaseContractVO contractVO = this.queryDetail(id);
        ExecutionVO executionVO = this.service.targetCost((PurchaseContractVO)BeanMapper.map((Object)contractVO, PurchaseContractVO.class), BILL_TYPE, linkUrl);
        this.logger.error("ss" + JSONObject.toJSONString((Object)executionVO));
        CommonResponse response = this.executionApi.ctrlCheckVO(executionVO);
        ParamsCheckVO paramsCheckVO = this.checkParams(contractVO, (ParamsCheckVO)response.getData());
        return paramsCheckVO;
    }

    @Override
    public CommonResponse<String> pushTargetCost(Long id) {
        ExecutionVO executionVO;
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)wrapper.eq((Object)"contract_id", (Object)id)).eq((Object)"dr", (Object)0)).orderByDesc((Object)"create_time");
        List list = this.changeService.list((Wrapper)wrapper);
        if (list.size() > 0) {
            executionVO = this.service.targetCost((PurchaseContractVO)BeanMapper.map(list.get(0), PurchaseContractVO.class), CHANGE_BILL_TYPE, changeLinkUrl);
        } else {
            executionVO = this.service.targetCost(this.service.queryDetail(id), BILL_TYPE, linkUrl);
            this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO));
        }
        CommonResponse response = this.executionApi.aggPush(executionVO);
        if (!response.isSuccess()) {
            throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
        }
        return CommonResponse.success((String)"\u76ee\u6807\u6210\u672c\u63a8\u9001\u6210\u529f");
    }

    @Override
    public boolean delWatermarkContractFile(Long watermarkFileId) {
        Assert.notNull((Object)watermarkFileId, (String)"\u6c34\u5370\u5408\u540c\u9644\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        CommonResponse res = this.attachmentApi.delete(String.valueOf(watermarkFileId));
        if (!res.isSuccess()) {
            this.logger.error("\u5220\u9664\u6587\u4ef6\u4e2d\u5fc3\u6c34\u5370\u6587\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}\uff0c\u6c34\u5370\u6587\u4ef6id\uff1a{}", (Object)res.getMsg(), (Object)watermarkFileId);
            throw new BusinessException("\u5220\u9664\u6587\u4ef6\u4e2d\u5fc3\u6c34\u5370\u6587\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + res.getMsg() + "\uff0c\u6c34\u5370\u6587\u4ef6id\uff1a" + watermarkFileId);
        }
        return true;
    }

    @Override
    public ParamsCheckVO checkParams(PurchaseContractVO vo, ParamsCheckVO paramsCheckVO2) {
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        if (null != this.checkParamsConstruction(vo)) {
            paramsCheckVOS.add(this.checkParamsConstruction(vo));
        }
        if (vo.getSupplementFlag() != null && Objects.equals(vo.getSupplementFlag(), PurchaseContractVO.CONTRACT_TYPE_SUPPLEMENT)) {
            paramsCheckVOS.add(this.checkParamsMnySup(vo));
        }
        if (paramsCheckVO2 != null) {
            paramsCheckVOS.add(paramsCheckVO2);
        }
        HashMap<String, List> map = new HashMap<String, List>();
        String[] paramsArray = new String[]{"alert", "warn", "none"};
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List checkDsVOS = (List)map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                    continue;
                }
                map.put(warnType, checkVO.getDataSource());
            }
        }
        for (String s : paramsArray) {
            if (!map.containsKey(s)) continue;
            paramsCheckVO.setWarnType(s);
            paramsCheckVO.setDataSource((List)map.get(s));
            if (CollectionUtils.isEmpty((Collection)paramsCheckVO.getDataSource())) {
                paramsCheckVO.setWarnType("none");
            }
            return paramsCheckVO;
        }
        return paramsCheckVO;
    }

    @Override
    public ParamsCheckVO checkParamsConstruction(PurchaseContractVO vo) {
        CommonResponse response = this.paramCheckApi.paramsCheck(vo.getProjectId(), vo.getId(), vo.getContractTaxMny());
        return (ParamsCheckVO)response.getData();
    }

    @Override
    public ParamsCheckVO checkParamsMnySup(PurchaseContractVO vo) {
        BigDecimal contractTaxMnySup = vo.getContractTaxMny() == null ? BigDecimal.ZERO : vo.getContractTaxMny();
        PurchaseContractEntity contractEntity = (PurchaseContractEntity)((Object)super.selectById((Serializable)vo.getMainContractId()));
        BigDecimal contractTaxMny = contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny();
        BigDecimal totalSupMoney = contractTaxMnySup;
        QueryParam supplementQueryParam = new QueryParam();
        supplementQueryParam.getParams().put("mainContractId", new Parameter("eq", (Object)vo.getMainContractId()));
        if (vo.getId() != null) {
            supplementQueryParam.getParams().put("id", new Parameter("ne", (Object)vo.getId()));
        }
        supplementQueryParam.getParams().put("mainContractId", new Parameter("eq", (Object)vo.getMainContractId()));
        supplementQueryParam.getParams().put("signatureStatus", new Parameter("eq", (Object)SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode()));
        List supplementContractList = super.queryList(supplementQueryParam, false);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)supplementContractList)) {
            for (PurchaseContractEntity entity : supplementContractList) {
                totalSupMoney = ComputeUtil.safeAdd((BigDecimal)entity.getContractTaxMny(), (BigDecimal)totalSupMoney);
            }
        }
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
        CommonResponse billParamByCode = this.paramConfigApi.getBillParamByCode(CHECK_PARAM_CODE);
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            BillParamVO billParamVO = (BillParamVO)billParamByCode.getData();
            BigDecimal roleValue = billParamVO.getRoleValue();
            BigDecimal comMny = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)contractTaxMny, (BigDecimal)roleValue), (BigDecimal)new BigDecimal("100")).setScale(2, 4);
            paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
            if (totalSupMoney.compareTo(comMny) > 0) {
                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                paramsCheckDsVO.setWarnItem("\u8865\u5145\u534f\u8bae\u8d85\u5408\u540c\u91d1\u989d");
                paramsCheckDsVO.setWarnName("\u7d2f\u8ba1\u8865\u5145\u534f\u8bae\u91d1\u989d\u5927\u4e8e\u5408\u540c\u91d1\u989d");
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("\u672c\u6b21\u8865\u5145\u534f\u8bae\u91d1\u989d\uff1a").append(contractTaxMnySup.setScale(2, 4)).append("\u5143\uff0c\u542b\u672c\u6b21\u8865\u5145\u534f\u8bae\u91d1\u989d\uff1a").append(totalSupMoney.setScale(2, 4)).append("\u5143\uff0c\u5408\u540c\u91d1\u989d*").append(roleValue).append("%:").append(comMny.setScale(2, 4)).append("\u5143\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(ComputeUtil.safeSub((BigDecimal)totalSupMoney, (BigDecimal)comMny).setScale(2, 4)).append("\u5143");
                paramsCheckDsVO.setContent(stringBuffer.toString());
                checkDsVOS.add(paramsCheckDsVO);
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        paramsCheckVO.setDataSource(checkDsVOS);
        return paramsCheckVO;
    }
}

