package com.ejianc.business.asset.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.asset.bean.AmortizeSetEntity;
import com.ejianc.business.asset.mapper.AmortizeSetMapper;
import com.ejianc.business.asset.service.IAmortizeSetService;
import com.ejianc.business.asset.vo.AmortizeSetVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

/**
 * 固定资产摊销设置
 *
 * @author generator
 */
@Service("amortizeSetService")
public class AmortizeSetServiceImpl extends BaseServiceImpl<AmortizeSetMapper, AmortizeSetEntity> implements IAmortizeSetService {


    @Override
    public AmortizeSetVO saveOrUpdate(AmortizeSetVO saveOrUpdateVO) {
        // 校验同一组织下，同一分类或者同一设备唯一
        if (saveOrUpdateVO.getEnabled() == 1) {
            Integer typeFlag = saveOrUpdateVO.getTypeFlag();
            LambdaQueryWrapper<AmortizeSetEntity> lambd = new LambdaQueryWrapper<>();
            lambd.eq(AmortizeSetEntity::getOrgId, saveOrUpdateVO.getOrgId());
            lambd.eq(AmortizeSetEntity::getTypeFlag, typeFlag);
            if (typeFlag == 1) {
                lambd.eq(AmortizeSetEntity::getEquipmentTypeId, saveOrUpdateVO.getEquipmentTypeId());
            } else {
                lambd.eq(AmortizeSetEntity::getEquipmentId, saveOrUpdateVO.getEquipmentId());
            }
            lambd.ne(saveOrUpdateVO.getId() != null && saveOrUpdateVO.getId() > 0, AmortizeSetEntity::getId, saveOrUpdateVO.getId());

            int count = super.count(lambd);
            if (count > 0) {
                if (typeFlag == 1) {
                    throw new BusinessException("设备分类【" + saveOrUpdateVO.getEquipmentTypeName() + "】摊销设置已存在");
                } else {
                    throw new BusinessException("设备【名称：" + saveOrUpdateVO.getEquipmentName() + (StringUtils.isNotEmpty(saveOrUpdateVO.getSpec()) ? "，规格：" + saveOrUpdateVO.getSpec() : "") + "】摊销设置已存在");
                }
            }
        }
        AmortizeSetEntity entity = BeanMapper.map(saveOrUpdateVO, AmortizeSetEntity.class);
        this.saveOrUpdate(entity, false);
        return BeanMapper.map(entity, AmortizeSetVO.class);
    }

    @Override
    public String turnSwitch(AmortizeSetVO vo) {
        LambdaUpdateWrapper<AmortizeSetEntity> lambdUpdate = new LambdaUpdateWrapper<>();
        lambdUpdate.set(AmortizeSetEntity::getEnabled, vo.getEnabled());
        lambdUpdate.eq(AmortizeSetEntity::getId, vo.getId());
        boolean update = super.update(lambdUpdate);
        return update ? "操作成功！" : "操作失败！";

    }

}
