package com.ejianc.business.asset.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.asset.bean.AssetScrapDetailEntity;
/**
 * 固定资产报废表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_proequipment_asset_scrap")
public class AssetScrapEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="scrap_unit_id")
    private Long scrapUnitId; // 报废单位id
    @TableField(value="scrap_unit")
    private String scrapUnit; // 报废单位
    @TableField(value="scrap_date")
    private Date scrapDate; // 报废日期
    @TableField(value="equipment_num")
    private BigDecimal equipmentNum; // 机械设备台数
    @TableField(value="total_original_value")
    private BigDecimal totalOriginalValue; // 设备原值
    @TableField(value="total_original_value_tax")
    private BigDecimal totalOriginalValueTax; // 设备原值(含税)
    @TableField(value="total_net_worth")
    private BigDecimal totalNetWorth; // 设备净值
    @TableField(value="total_net_worth_tax")
    private BigDecimal totalNetWorthTax; // 设备净值(含税)
    @TableField(value="total_residual_value")
    private BigDecimal totalResidualValue; // 设备残值
    @TableField(value="total_residual_value_tax")
    private BigDecimal totalResidualValueTax; // 设备残值(含税)
    @TableField(value="employee_id")
    private Long employeeId; // 经办人id
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="dept_id")
    private Long deptId; // 经办部门
    @TableField(value="dept_name")
    private String deptName; // 经办部门名称
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="scrap_state")
    private Integer scrapState; // 报废状态 0-未报废，1-已报废
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="assetScrapDetailService",pidName ="scrapId")//此处有pid="xxx"，默认值pid="pid"
    private List<AssetScrapDetailEntity> assetScrapDetailList = new ArrayList<>(); // 固定资产报废明细表
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getScrapUnitId() {
        return scrapUnitId;
    }

    public void setScrapUnitId(Long scrapUnitId) {
        this.scrapUnitId = scrapUnitId;
    }
    public String getScrapUnit() {
        return scrapUnit;
    }

    public void setScrapUnit(String scrapUnit) {
        this.scrapUnit = scrapUnit;
    }
    public Date getScrapDate() {
        return scrapDate;
    }

    public void setScrapDate(Date scrapDate) {
        this.scrapDate = scrapDate;
    }
    public BigDecimal getEquipmentNum() {
        return equipmentNum;
    }

    public void setEquipmentNum(BigDecimal equipmentNum) {
        this.equipmentNum = equipmentNum;
    }
    public BigDecimal getTotalOriginalValue() {
        return totalOriginalValue;
    }

    public void setTotalOriginalValue(BigDecimal totalOriginalValue) {
        this.totalOriginalValue = totalOriginalValue;
    }
    public BigDecimal getTotalOriginalValueTax() {
        return totalOriginalValueTax;
    }

    public void setTotalOriginalValueTax(BigDecimal totalOriginalValueTax) {
        this.totalOriginalValueTax = totalOriginalValueTax;
    }
    public BigDecimal getTotalNetWorth() {
        return totalNetWorth;
    }

    public void setTotalNetWorth(BigDecimal totalNetWorth) {
        this.totalNetWorth = totalNetWorth;
    }
    public BigDecimal getTotalNetWorthTax() {
        return totalNetWorthTax;
    }

    public void setTotalNetWorthTax(BigDecimal totalNetWorthTax) {
        this.totalNetWorthTax = totalNetWorthTax;
    }
    public BigDecimal getTotalResidualValue() {
        return totalResidualValue;
    }

    public void setTotalResidualValue(BigDecimal totalResidualValue) {
        this.totalResidualValue = totalResidualValue;
    }
    public BigDecimal getTotalResidualValueTax() {
        return totalResidualValueTax;
    }

    public void setTotalResidualValueTax(BigDecimal totalResidualValueTax) {
        this.totalResidualValueTax = totalResidualValueTax;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDeptId() {
        return deptId;
    }

    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getScrapState() {
        return scrapState;
    }

    public void setScrapState(Integer scrapState) {
        this.scrapState = scrapState;
    }
    
    public List<AssetScrapDetailEntity> getAssetScrapDetailList() {
        return assetScrapDetailList;
    }

    public void setAssetScrapDetailList(List<AssetScrapDetailEntity> assetScrapDetailList) {
        this.assetScrapDetailList = assetScrapDetailList;
    }
}
