/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.asset.service;

import com.ejianc.business.asset.bean.AssetAllotInEntity;
import com.ejianc.business.consts.NoticeEnum;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.ArrayList;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AssetAllotInMessageService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Autowired
    private IPushMessageApi pushMessageApi;

    public CommonResponse<String> sendMsg(AssetAllotInEntity allotinentity, String[] receivers, NoticeEnum notice) {
        if (allotinentity != null) {
            PushMsgParameter parameter = new PushMsgParameter();
            ArrayList<String> channel = new ArrayList<String>();
            channel.add("sys");
            HashMap<String, String> keyMap = new HashMap<String, String>();
            keyMap.put("#BILLCODE#", allotinentity.getBillCode());
            keyMap.put("#ID#", String.valueOf(allotinentity.getId()));
            keyMap.put("#BASEHOST#", this.baseHost);
            parameter.setReceivers(receivers);
            parameter.setChannel(channel.toArray(new String[channel.size()]));
            parameter.setMsgType("notice");
            parameter.setSubject(notice.getSubject());
            this.logger.info("==============================\u7cfb\u7edf\u6d88\u606f===================================================");
            String sysContent = NoticeEnum.getPcContent((NoticeEnum)notice, keyMap);
            this.logger.info("sysContent = " + sysContent);
            parameter.setContent(sysContent);
            parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
            parameter.setSendUserId(InvocationInfoProxy.getUserid());
            try {
                CommonResponse result = this.pushMessageApi.pushMessage(parameter);
                if (result.isSuccess()) {
                    this.logger.error("\u6d88\u606f\u53d1\u9001\u6210\u529f---------------->" + result.getMsg());
                } else {
                    this.logger.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25---------------->" + result.getMsg());
                }
            }
            catch (Exception e) {
                this.logger.error("\u8c03\u7528\u6d88\u606f\u4e2d\u5fc3RPC\u670d\u52a1\u5f02\u5e38--------------" + e);
            }
        }
        return CommonResponse.success();
    }
}

