/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.asset.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.asset.bean.AssetEntity;
import com.ejianc.business.asset.bean.HandleDetailEntity;
import com.ejianc.business.asset.bean.HandleEntity;
import com.ejianc.business.asset.service.IAssetService;
import com.ejianc.business.asset.service.IHandleService;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="handle")
public class HandleBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IHandleService service;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private IAssetService assetService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        LambdaUpdateWrapper updateWrapper;
        HandleEntity handleEntity = (HandleEntity)((Object)this.service.selectById(billId));
        List<HandleDetailEntity> handleDetailList = handleEntity.getHandleDetailList();
        if (CollectionUtils.isNotEmpty(handleDetailList)) {
            for (HandleDetailEntity handleDetailEntity : handleDetailList) {
                updateWrapper = new LambdaUpdateWrapper();
                updateWrapper.eq(BaseEntity::getId, (Object)handleDetailEntity.getAssetId());
                updateWrapper.set(AssetEntity::getHandleMny, (Object)handleDetailEntity.getHandleMny());
                updateWrapper.set(AssetEntity::getHandleTaxMny, (Object)handleDetailEntity.getHandleTaxMny());
                this.assetService.update((Wrapper)updateWrapper);
            }
        }
        BigDecimal sumHandleDiffMny = handleDetailList.stream().map(HandleDetailEntity::getHandleDiffMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sumHandleDiffTaxMny = handleDetailList.stream().map(HandleDetailEntity::getHandleDiffTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)billId);
        updateWrapper.set(HandleEntity::getSumHandleDiffMny, (Object)sumHandleDiffMny);
        updateWrapper.set(HandleEntity::getSumHandleDiffTaxMny, (Object)sumHandleDiffTaxMny);
        this.service.update((Wrapper)updateWrapper);
        handleEntity.setSumHandleDiffMny(sumHandleDiffMny);
        handleEntity.setSumHandleDiffTaxMny(sumHandleDiffTaxMny);
        this.service.costPush(handleEntity);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        HandleEntity handleEntity = (HandleEntity)((Object)this.service.selectById(billId));
        CommonResponse checkCommonResponse = this.billTypeApi.checkQuote(billTypeCode, handleEntity.getId());
        boolean success = checkCommonResponse.isSuccess();
        if (!success) {
            return CommonResponse.error((String)"\u5df2\u7ecf\u88ab\u5f52\u96c6\u5355\u4f7f\u7528,\u4e0d\u80fd\u5f03\u5ba1\u548c\u64a4\u56de");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        HandleEntity handleEntity = (HandleEntity)((Object)this.service.selectById(billId));
        this.logger.info("\u5f03\u5ba1\u63a8\u9001\u6210\u672c---");
        this.logger.info("\u5220\u9664\u6210\u672c\u4e2d\u5fc3\u4e4b\u524d\u7684\u6570\u636e-\u5904\u7f6eId---{}", (Object)handleEntity.getId());
        CommonResponse stringCommonResponse = this.costDetailApi.deleteSubject(handleEntity.getId());
        this.logger.info("\u7ed3\u679c" + JSONObject.toJSONString((Object)stringCommonResponse));
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException(stringCommonResponse.getMsg());
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{handleEntity.getId()});
        updateWrapper.set(HandleEntity::getRelationFlag, (Object)0);
        this.service.update((Wrapper)updateWrapper);
        return CommonResponse.success();
    }
}

