package com.ejianc.business.asset.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 固定资产摊销明细表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_proequipment_asset_amortize_detail")
public class AssetAmortizeDetailEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="equipment_type_id")
    private Long equipmentTypeId; // 设备分类id
    @TableField(value="equipment_type_code")
    private String equipmentTypeCode; // 设备分类编码
    @TableField(value="equipment_type_name")
    private String equipmentTypeName; // 设备分类名称
    @TableField(value="equipment_id")
    private Long equipmentId; // 设备id
    @TableField(value="equipment_code")
    private String equipmentCode; // 设备编码
    @TableField(value="equipment_name")
    private String equipmentName; // 设备名称
    @TableField(value="asset_id")
    private Long assetId; // 资产id
    @TableField(value="asset_code")
    private String assetCode; // 资产编码
    @TableField(value="asset_name")
    private String assetName; // 资产名称
    @TableField(value="finance_type_id")
    private String financeTypeId; // 财务资产分类id
    @TableField(value="finance_asset_id")
    private String financeAssetId; // 财务资产id
    @TableField(value="finance_asset_code")
    private String financeAssetCode; // 财务资产编码
    @TableField(value="spec")
    private String spec; // 规格型号
    @TableField(value="unit_id")
    private Long unitId; // 计量单位id
    @TableField(value="unit")
    private String unit; // 计量单位
    @TableField(value="num")
    private BigDecimal num; // 数量
    @TableField(value="tax_rate")
    private BigDecimal taxRate; // 税率
    @TableField(value="original_value")
    private BigDecimal originalValue; // 原值(无税)
    @TableField(value="original_value_tax")
    private BigDecimal originalValueTax; // 原值(含税)
    @TableField(value="net_worth")
    private BigDecimal netWorth; // 净值(无税)
    @TableField(value="net_worth_tax")
    private BigDecimal netWorthTax; // 净值(含税)
    @TableField(value="original_value_price")
    private BigDecimal originalValuePrice; // 原值单价(无税)
    @TableField(value="original_value_price_tax")
    private BigDecimal originalValuePriceTax; // 原值单价(含税)
    @TableField(value="residual_value_tax")
    private BigDecimal residualValueTax; // 残值(含税)
    @TableField(value="residual_value")
    private BigDecimal residualValue; // 残值(无税)
    @TableField(value="last_amortize_date")
    private Date lastAmortizeDate; // 上次摊销周期
    @TableField(value="amortize_rate")
    private BigDecimal amortizeRate; // 本次摊销比例
    @TableField(value="amortize_mny")
    private BigDecimal amortizeMny; // 本次摊销金额(无税)
    @TableField(value="amortize_mny_tax")
    private BigDecimal amortizeMnyTax; // 本次摊销金额(含税)
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="used_amortize_num")
    private Integer usedAmortizeNum; // 已生效摊销周期数
    @TableField(value="use_period")
    private Integer usePeriod; // 使用年限（月）
    @TableField(value="residual_value_rate")
    private BigDecimal residualValueRate; // 残值率
    
    
    

    public Long getEquipmentTypeId() {
        return equipmentTypeId;
    }

    public void setEquipmentTypeId(Long equipmentTypeId) {
        this.equipmentTypeId = equipmentTypeId;
    }
    public String getEquipmentTypeCode() {
        return equipmentTypeCode;
    }

    public void setEquipmentTypeCode(String equipmentTypeCode) {
        this.equipmentTypeCode = equipmentTypeCode;
    }
    public String getEquipmentTypeName() {
        return equipmentTypeName;
    }

    public void setEquipmentTypeName(String equipmentTypeName) {
        this.equipmentTypeName = equipmentTypeName;
    }
    public Long getEquipmentId() {
        return equipmentId;
    }

    public void setEquipmentId(Long equipmentId) {
        this.equipmentId = equipmentId;
    }
    public String getEquipmentCode() {
        return equipmentCode;
    }

    public void setEquipmentCode(String equipmentCode) {
        this.equipmentCode = equipmentCode;
    }
    public String getEquipmentName() {
        return equipmentName;
    }

    public void setEquipmentName(String equipmentName) {
        this.equipmentName = equipmentName;
    }
    public Long getAssetId() {
        return assetId;
    }

    public void setAssetId(Long assetId) {
        this.assetId = assetId;
    }
    public String getAssetCode() {
        return assetCode;
    }

    public void setAssetCode(String assetCode) {
        this.assetCode = assetCode;
    }
    public String getAssetName() {
        return assetName;
    }

    public void setAssetName(String assetName) {
        this.assetName = assetName;
    }
    public String getFinanceTypeId() {
        return financeTypeId;
    }

    public void setFinanceTypeId(String financeTypeId) {
        this.financeTypeId = financeTypeId;
    }
    public String getFinanceAssetId() {
        return financeAssetId;
    }

    public void setFinanceAssetId(String financeAssetId) {
        this.financeAssetId = financeAssetId;
    }
    public String getFinanceAssetCode() {
        return financeAssetCode;
    }

    public void setFinanceAssetCode(String financeAssetCode) {
        this.financeAssetCode = financeAssetCode;
    }
    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }
    public Long getUnitId() {
        return unitId;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }
    public BigDecimal getNum() {
        return num;
    }

    public void setNum(BigDecimal num) {
        this.num = num;
    }
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    public BigDecimal getOriginalValue() {
        return originalValue;
    }

    public void setOriginalValue(BigDecimal originalValue) {
        this.originalValue = originalValue;
    }
    public BigDecimal getOriginalValueTax() {
        return originalValueTax;
    }

    public void setOriginalValueTax(BigDecimal originalValueTax) {
        this.originalValueTax = originalValueTax;
    }
    public BigDecimal getNetWorth() {
        return netWorth;
    }

    public void setNetWorth(BigDecimal netWorth) {
        this.netWorth = netWorth;
    }
    public BigDecimal getNetWorthTax() {
        return netWorthTax;
    }

    public void setNetWorthTax(BigDecimal netWorthTax) {
        this.netWorthTax = netWorthTax;
    }
    public BigDecimal getOriginalValuePrice() {
        return originalValuePrice;
    }

    public void setOriginalValuePrice(BigDecimal originalValuePrice) {
        this.originalValuePrice = originalValuePrice;
    }
    public BigDecimal getOriginalValuePriceTax() {
        return originalValuePriceTax;
    }

    public void setOriginalValuePriceTax(BigDecimal originalValuePriceTax) {
        this.originalValuePriceTax = originalValuePriceTax;
    }
    public BigDecimal getResidualValueTax() {
        return residualValueTax;
    }

    public void setResidualValueTax(BigDecimal residualValueTax) {
        this.residualValueTax = residualValueTax;
    }
    public BigDecimal getResidualValue() {
        return residualValue;
    }

    public void setResidualValue(BigDecimal residualValue) {
        this.residualValue = residualValue;
    }
    public Date getLastAmortizeDate() {
        return lastAmortizeDate;
    }

    public void setLastAmortizeDate(Date lastAmortizeDate) {
        this.lastAmortizeDate = lastAmortizeDate;
    }
    public BigDecimal getAmortizeRate() {
        return amortizeRate;
    }

    public void setAmortizeRate(BigDecimal amortizeRate) {
        this.amortizeRate = amortizeRate;
    }
    public BigDecimal getAmortizeMny() {
        return amortizeMny;
    }

    public void setAmortizeMny(BigDecimal amortizeMny) {
        this.amortizeMny = amortizeMny;
    }
    public BigDecimal getAmortizeMnyTax() {
        return amortizeMnyTax;
    }

    public void setAmortizeMnyTax(BigDecimal amortizeMnyTax) {
        this.amortizeMnyTax = amortizeMnyTax;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getUsedAmortizeNum() {
        return usedAmortizeNum;
    }

    public void setUsedAmortizeNum(Integer usedAmortizeNum) {
        this.usedAmortizeNum = usedAmortizeNum;
    }
    public Integer getUsePeriod() {
        return usePeriod;
    }

    public void setUsePeriod(Integer usePeriod) {
        this.usePeriod = usePeriod;
    }
    public BigDecimal getResidualValueRate() {
        return residualValueRate;
    }

    public void setResidualValueRate(BigDecimal residualValueRate) {
        this.residualValueRate = residualValueRate;
    }
    
}
