/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.asset.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.asset.bean.AmortizeSetEntity;
import com.ejianc.business.asset.mapper.AmortizeSetMapper;
import com.ejianc.business.asset.service.IAmortizeSetService;
import com.ejianc.business.asset.vo.AmortizeSetVO;
import com.ejianc.business.asset.vo.AssetAmortizeDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="amortizeSetService")
public class AmortizeSetServiceImpl
extends BaseServiceImpl<AmortizeSetMapper, AmortizeSetEntity>
implements IAmortizeSetService {
    @Override
    public AmortizeSetVO saveOrUpdate(AmortizeSetVO saveOrUpdateVO) {
        if (saveOrUpdateVO.getEnabled() == 1) {
            Integer typeFlag = saveOrUpdateVO.getTypeFlag();
            LambdaQueryWrapper lambd = new LambdaQueryWrapper();
            lambd.eq(AmortizeSetEntity::getOrgId, (Object)saveOrUpdateVO.getOrgId());
            lambd.eq(AmortizeSetEntity::getTypeFlag, (Object)typeFlag);
            if (typeFlag == 1) {
                lambd.eq(AmortizeSetEntity::getEquipmentTypeId, (Object)saveOrUpdateVO.getEquipmentTypeId());
            } else {
                lambd.eq(AmortizeSetEntity::getEquipmentId, (Object)saveOrUpdateVO.getEquipmentId());
            }
            lambd.ne(saveOrUpdateVO.getId() != null && saveOrUpdateVO.getId() > 0L, BaseEntity::getId, (Object)saveOrUpdateVO.getId());
            int count = super.count((Wrapper)lambd);
            if (count > 0) {
                if (typeFlag == 1) {
                    throw new BusinessException("\u8bbe\u5907\u5206\u7c7b\u3010" + saveOrUpdateVO.getEquipmentTypeName() + "\u3011\u644a\u9500\u8bbe\u7f6e\u5df2\u5b58\u5728");
                }
                throw new BusinessException("\u8bbe\u5907\u3010\u540d\u79f0\uff1a" + saveOrUpdateVO.getEquipmentName() + (StringUtils.isNotEmpty((CharSequence)saveOrUpdateVO.getSpec()) ? "\uff0c\u89c4\u683c\uff1a" + saveOrUpdateVO.getSpec() : "") + "\u3011\u644a\u9500\u8bbe\u7f6e\u5df2\u5b58\u5728");
            }
        }
        AmortizeSetEntity entity = (AmortizeSetEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, AmortizeSetEntity.class));
        this.saveOrUpdate((Object)entity, false);
        return (AmortizeSetVO)BeanMapper.map((Object)((Object)entity), AmortizeSetVO.class);
    }

    @Override
    public String turnSwitch(AmortizeSetVO vo) {
        LambdaUpdateWrapper lambdUpdate = new LambdaUpdateWrapper();
        lambdUpdate.set(AmortizeSetEntity::getEnabled, (Object)vo.getEnabled());
        lambdUpdate.eq(BaseEntity::getId, (Object)vo.getId());
        boolean update = super.update((Wrapper)lambdUpdate);
        return update ? "\u64cd\u4f5c\u6210\u529f\uff01" : "\u64cd\u4f5c\u5931\u8d25\uff01";
    }

    @Override
    public void getSet(List<AssetAmortizeDetailVO> detailList) {
        LambdaQueryWrapper lambdQuery = new LambdaQueryWrapper();
        lambdQuery.eq(AmortizeSetEntity::getOrgId, (Object)InvocationInfoProxy.getOrgId());
        lambdQuery.eq(AmortizeSetEntity::getEnabled, (Object)1);
        List list = this.list((Wrapper)lambdQuery);
        HashMap<Long, AmortizeSetEntity> amortizeSetMap = new HashMap<Long, AmortizeSetEntity>();
        for (AmortizeSetEntity amortizeSetEntity : list) {
            Long key = amortizeSetEntity.getEquipmentId() != null ? amortizeSetEntity.getEquipmentId() : amortizeSetEntity.getEquipmentTypeId();
            amortizeSetMap.put(key, amortizeSetEntity);
        }
        for (AssetAmortizeDetailVO detailVO : detailList) {
            Long equipmentTypeId = detailVO.getEquipmentTypeId();
            Long equipmentId = detailVO.getEquipmentId();
            AmortizeSetEntity amortizeSetEntity = (AmortizeSetEntity)((Object)amortizeSetMap.get(equipmentId));
            if (amortizeSetEntity == null) continue;
            detailVO.setAmortizeSetId(amortizeSetEntity.getId());
            detailVO.setUsePeriod(amortizeSetEntity.getUsePeriod());
            detailVO.setResidualValueRate(amortizeSetEntity.getResidualValueRate());
        }
    }
}

