/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.asset.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.asset.bean.AmortizeSetEntity;
import com.ejianc.business.asset.mapper.AmortizeSetMapper;
import com.ejianc.business.asset.service.IAmortizeSetService;
import com.ejianc.business.asset.vo.AmortizeSetVO;
import com.ejianc.foundation.share.api.IShareEquipmentApi;
import com.ejianc.foundation.share.vo.EquipmentCategoryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="amortizeSetService")
public class AmortizeSetServiceImpl
extends BaseServiceImpl<AmortizeSetMapper, AmortizeSetEntity>
implements IAmortizeSetService {
    @Autowired
    IShareEquipmentApi shareEquipmentApi;

    @Override
    public AmortizeSetVO saveOrUpdate(AmortizeSetVO saveOrUpdateVO) {
        if (saveOrUpdateVO.getEnabled() == 1) {
            Integer typeFlag = saveOrUpdateVO.getTypeFlag();
            LambdaQueryWrapper lambd = new LambdaQueryWrapper();
            lambd.eq(AmortizeSetEntity::getOrgId, (Object)saveOrUpdateVO.getOrgId());
            lambd.eq(AmortizeSetEntity::getTypeFlag, (Object)typeFlag);
            if (typeFlag == 1) {
                lambd.eq(AmortizeSetEntity::getEquipmentTypeId, (Object)saveOrUpdateVO.getEquipmentTypeId());
            } else {
                lambd.eq(AmortizeSetEntity::getEquipmentId, (Object)saveOrUpdateVO.getEquipmentId());
            }
            lambd.ne(saveOrUpdateVO.getId() != null && saveOrUpdateVO.getId() > 0L, BaseEntity::getId, (Object)saveOrUpdateVO.getId());
            int count = super.count((Wrapper)lambd);
            if (count > 0) {
                if (typeFlag == 1) {
                    throw new BusinessException("\u8bbe\u5907\u5206\u7c7b\u3010" + saveOrUpdateVO.getEquipmentTypeName() + "\u3011\u644a\u9500\u8bbe\u7f6e\u5df2\u5b58\u5728");
                }
                throw new BusinessException("\u8bbe\u5907\u3010\u540d\u79f0\uff1a" + saveOrUpdateVO.getEquipmentName() + (StringUtils.isNotEmpty((CharSequence)saveOrUpdateVO.getSpec()) ? "\uff0c\u89c4\u683c\uff1a" + saveOrUpdateVO.getSpec() : "") + "\u3011\u644a\u9500\u8bbe\u7f6e\u5df2\u5b58\u5728");
            }
        }
        AmortizeSetEntity entity = (AmortizeSetEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, AmortizeSetEntity.class));
        this.saveOrUpdate((Object)entity, false);
        return (AmortizeSetVO)BeanMapper.map((Object)((Object)entity), AmortizeSetVO.class);
    }

    @Override
    public String turnSwitch(AmortizeSetVO vo) {
        LambdaUpdateWrapper lambdUpdate = new LambdaUpdateWrapper();
        lambdUpdate.set(AmortizeSetEntity::getEnabled, (Object)vo.getEnabled());
        lambdUpdate.eq(BaseEntity::getId, (Object)vo.getId());
        boolean update = super.update((Wrapper)lambdUpdate);
        return update ? "\u64cd\u4f5c\u6210\u529f\uff01" : "\u64cd\u4f5c\u5931\u8d25\uff01";
    }

    @Override
    public Map<Long, AmortizeSetEntity> getSet(Map<Long, Long> equipments) {
        List pIds;
        CommonResponse listCommonResponse = this.shareEquipmentApi.queryCategoryListByIds(new ArrayList<Long>(equipments.values()));
        HashMap<Long, List<Long>> equipTypeMap = new HashMap<Long, List<Long>>();
        if (listCommonResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)listCommonResponse.getData()))) {
            List data = (List)listCommonResponse.getData();
            for (EquipmentCategoryVO categoryVO : data) {
                Long categoryVOId = categoryVO.getId();
                String innerCode = categoryVO.getInnerCode();
                String[] innerCodeArr = innerCode.split("|");
                for (int i = innerCodeArr.length - 1; i >= 0; --i) {
                    pIds = (List)equipTypeMap.get(categoryVOId);
                    Long pId = Long.valueOf(innerCodeArr[i]);
                    if (pIds == null) {
                        equipTypeMap.put(categoryVOId, Arrays.asList(pId));
                        continue;
                    }
                    pIds.add(pId);
                }
            }
        }
        LambdaQueryWrapper lambdQuery = new LambdaQueryWrapper();
        lambdQuery.eq(AmortizeSetEntity::getOrgId, (Object)InvocationInfoProxy.getOrgId());
        lambdQuery.eq(AmortizeSetEntity::getEnabled, (Object)1);
        List list = this.list((Wrapper)lambdQuery);
        HashMap<Long, AmortizeSetEntity> amortizeSetMap = new HashMap<Long, AmortizeSetEntity>();
        for (AmortizeSetEntity amortizeSetEntity : list) {
            Long key = amortizeSetEntity.getEquipmentId() != null ? amortizeSetEntity.getEquipmentId() : amortizeSetEntity.getEquipmentTypeId();
            amortizeSetMap.put(key, amortizeSetEntity);
        }
        for (Long equipmentId : equipments.keySet()) {
            Long equipmentTypeId = equipments.get(equipmentId);
            AmortizeSetEntity amortizeSetEntity = (AmortizeSetEntity)((Object)amortizeSetMap.get(equipmentId));
            if (amortizeSetEntity == null && (amortizeSetEntity = (AmortizeSetEntity)((Object)amortizeSetMap.get(equipmentTypeId))) == null) {
                Long pId;
                pIds = (List)equipTypeMap.get(equipmentTypeId);
                Iterator iterator = pIds.iterator();
                while (iterator.hasNext() && (amortizeSetEntity = (AmortizeSetEntity)((Object)amortizeSetMap.get(pId = (Long)iterator.next()))) == null) {
                }
            }
            amortizeSetMap.put(equipmentId, amortizeSetEntity);
        }
        return amortizeSetMap;
    }
}

