package com.ejianc.business.asset.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.asset.bean.AssetEntity;
import com.ejianc.business.asset.bean.HandleDetailEntity;
import com.ejianc.business.asset.bean.HandleEntity;
import com.ejianc.business.asset.service.IAssetRecordService;
import com.ejianc.business.asset.service.IAssetService;
import com.ejianc.business.asset.service.IHandleService;
import com.ejianc.business.asset.vo.AssetVO;
import com.ejianc.business.asset.vo.HandleDetailVO;
import com.ejianc.business.asset.vo.HandleVO;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;

import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;

@Service("handle") 
public class HandleBpmServiceImpl implements ICommonBusinessService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
	@Autowired
	private IHandleService service;
	@Autowired
	private ICostDetailApi costDetailApi;
	@Autowired
	private IAssetService assetService;
	@Autowired
	private IAssetRecordService assetRecordService;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//
		HandleEntity handleEntity = service.selectById(billId);
		List<HandleDetailEntity> handleDetailList = handleEntity.getHandleDetailList();
		//TODO回写固定资产设备处置金额
		if (CollectionUtils.isNotEmpty(handleDetailList)){
			List<Long> assetIds =
					handleDetailList.stream().filter(s -> s.getRowState() != null).map(HandleDetailEntity::getAssetId).collect(Collectors.toList());
			QueryWrapper<AssetEntity> queryWrapper = new QueryWrapper<>();
			queryWrapper.in("id",assetIds);
			queryWrapper.eq("asset_status",2);
			List<AssetEntity> assetEntities = assetService.list(queryWrapper);
			if (assetEntities.size()>0){
				return CommonResponse.error("设备信息中存在设备已经被处置不能再被处置!");
			}
			for (HandleDetailEntity handleDetailEntity : handleDetailList) {
				LambdaUpdateWrapper<AssetEntity> updateWrapper = new LambdaUpdateWrapper<>();
				updateWrapper.eq(AssetEntity::getId,handleDetailEntity.getAssetId());
				updateWrapper.set(AssetEntity::getHandleMny,handleDetailEntity.getHandleMny());
				updateWrapper.set(AssetEntity::getHandleTaxMny,handleDetailEntity.getHandleTaxMny());
				updateWrapper.set(AssetEntity::getAssetStatus,2);
				updateWrapper.set(AssetEntity::getEquipmentStatus,2);
				assetService.update(updateWrapper);
			}
			//生成设备流转记录
			HandleVO vo = BeanMapper.map(handleEntity, HandleVO.class);
			logger.info("设备处置推送设备流转记录的信息:"+JSONObject.toJSONString(vo));
			assetRecordService.saveRecord(vo);
			//TODO 推送实际成本
			BigDecimal sumHandleDiffMny = handleDetailList.stream().map(HandleDetailEntity::getHandleDiffMny).reduce(BigDecimal.ZERO, BigDecimal::add);
			BigDecimal sumHandleDiffTaxMny = handleDetailList.stream().map(HandleDetailEntity::getHandleDiffTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
			LambdaUpdateWrapper<HandleEntity> updateWrapper = new LambdaUpdateWrapper<>();
			updateWrapper.eq(HandleEntity::getId,billId);
			updateWrapper.set(HandleEntity::getSumHandleDiffMny,sumHandleDiffMny);
			updateWrapper.set(HandleEntity::getSumHandleDiffTaxMny,sumHandleDiffTaxMny);
			service.update(updateWrapper);
			handleEntity.setSumHandleDiffMny(sumHandleDiffMny);
			handleEntity.setSumHandleDiffTaxMny(sumHandleDiffTaxMny);
			logger.info("设备处置推送实际成本信息:"+JSONObject.toJSONString(handleEntity));
			service.costPush(handleEntity);
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		//TODO 弃审 校验是否被成本归集引用 引用则不能
		CommonResponse<String> checkCommonResponse = billTypeApi.checkQuote(billTypeCode, billId);
		boolean success = checkCommonResponse.isSuccess();
		if (!success){
			return CommonResponse.error("已经被归集单使用,不能弃审和撤回");
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {

		HandleEntity handleEntity = service.selectById(billId);
		logger.info("弃审推送成本---");
		logger.info("删除成本中心之前的数据-处置Id---{}",handleEntity.getId());
		CommonResponse<String> stringCommonResponse = costDetailApi.deleteSubject(handleEntity.getId());
		logger.info("结果"+ JSONObject.toJSONString(stringCommonResponse));
		if(!stringCommonResponse.isSuccess()){
			throw new BusinessException(stringCommonResponse.getMsg());
		}
		//更新是否关联
		LambdaUpdateWrapper<HandleEntity> updateWrapper = new LambdaUpdateWrapper<>();
		updateWrapper.in(HandleEntity::getId, handleEntity.getId());
		updateWrapper.set(HandleEntity::getRelationFlag, 0);//(1:是，0：否)
		service.update(updateWrapper);

		List<HandleDetailEntity> handleDetailList = handleEntity.getHandleDetailList();
		//TODO弃审回写固定资产设备处置金额设置为null and 会写设备状态和资产状态
		if (CollectionUtils.isNotEmpty(handleDetailList)){
			for (HandleDetailEntity handleDetailEntity : handleDetailList) {
				LambdaUpdateWrapper<AssetEntity> updateAssetWrapper = new LambdaUpdateWrapper<>();
				updateAssetWrapper.eq(AssetEntity::getId,handleDetailEntity.getAssetId());
				updateAssetWrapper.set(AssetEntity::getHandleMny,null);
				updateAssetWrapper.set(AssetEntity::getHandleTaxMny,null);
				updateAssetWrapper.set(AssetEntity::getAssetStatus,1);
				updateAssetWrapper.set(AssetEntity::getEquipmentStatus,1);
				assetService.update(updateAssetWrapper);
			}
			//TODO 弃审删除设备流转记录
			assetRecordService.delRecord(billId);
		}
		return CommonResponse.success();
	}

}
