/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.asset.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.asset.bean.AssetAllotInEntity;
import com.ejianc.business.asset.bean.AssetAllotOutEntity;
import com.ejianc.business.asset.mapper.AssetAllotInMapper;
import com.ejianc.business.asset.service.IAssetAllotInService;
import com.ejianc.business.asset.service.IAssetAllotOutService;
import com.ejianc.business.asset.service.IAssetRecordService;
import com.ejianc.business.asset.vo.AssetAllotInVO;
import com.ejianc.business.consts.AllocatEnum;
import com.ejianc.business.decorator.IAssetRecord;
import com.ejianc.business.store.consts.AllocationState;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="assetAllotInService")
public class AssetAllotInServiceImpl
extends BaseServiceImpl<AssetAllotInMapper, AssetAllotInEntity>
implements IAssetAllotInService {
    @Autowired
    private IAssetAllotInService service;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IAssetAllotOutService assetAllotOutService;
    @Autowired
    private IAssetRecordService assetRecordService;

    @Override
    public void excelExport(QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("storeName");
        fuzzyFields.add("materialNames");
        fuzzyFields.add("outProjectName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("receiverPerson");
        fuzzyFields.add("billCode");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List allotInVos = BeanMapper.mapList((Iterable)list, AssetAllotInVO.class);
        allotInVos.forEach(vo -> {
            vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            if (vo.getReceiveState() != null) {
                if (Integer.valueOf(com.ejianc.business.consts.AllocationState.TO_RECEIVING.getCode()).equals(vo.getReceiveState())) {
                    vo.setReceiveStateName(com.ejianc.business.consts.AllocationState.TO_RECEIVING.getDescription());
                } else if (Integer.valueOf(com.ejianc.business.consts.AllocationState.RECEIVED.getCode()).equals(vo.getReceiveState())) {
                    vo.setReceiveStateName(com.ejianc.business.consts.AllocationState.RECEIVED.getDescription());
                } else if (Integer.valueOf(com.ejianc.business.consts.AllocationState.REJECT.getCode()).equals(vo.getReceiveState())) {
                    vo.setReceiveStateName(com.ejianc.business.consts.AllocationState.REJECT.getDescription());
                }
            }
            if (vo.getAllocatType() != null) {
                if (Integer.valueOf(AllocatEnum.ASSETS.getCode()).equals(vo.getAllocatType())) {
                    vo.setAllocatTypeName(AllocatEnum.ASSETS.getDescription());
                } else {
                    vo.setAllocatTypeName(AllocatEnum.HOMEMADE.getDescription());
                }
            }
        });
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", allotInVos);
        ExcelExport.getInstance().export("AssetAllotIn-export.xlsx", beans, response);
    }

    @Override
    public CommonResponse<String> sureToReceive(AssetAllotInVO vo) {
        AssetAllotInEntity entity = (AssetAllotInEntity)((Object)this.service.selectById(vo.getId()));
        if (entity == null) {
            return CommonResponse.error((String)"\u6ca1\u6709\u627e\u5230\u8be5\u5355\u636e\uff01");
        }
        LambdaUpdateWrapper allotinWrapper = new LambdaUpdateWrapper();
        allotinWrapper.eq(BaseEntity::getId, (Object)vo.getId());
        allotinWrapper.set(AssetAllotInEntity::getReceiveDate, (Object)vo.getReceiveDate());
        allotinWrapper.set(AssetAllotInEntity::getOrgId, (Object)vo.getOrgId());
        allotinWrapper.set(AssetAllotInEntity::getBillState, (Object)BillStateEnum.COMMITED_STATE.getBillStateCode());
        allotinWrapper.set(AssetAllotInEntity::getReceiveState, (Object)Integer.parseInt(com.ejianc.business.consts.AllocationState.RECEIVED.getCode()));
        allotinWrapper.set(AssetAllotInEntity::getPassDate, (Object)vo.getPassDate());
        allotinWrapper.set(AssetAllotInEntity::getReceiverPersonId, (Object)vo.getReceiverPersonId());
        allotinWrapper.set(AssetAllotInEntity::getReceiverPerson, (Object)vo.getReceiverPerson());
        boolean b = this.service.update((Wrapper)allotinWrapper);
        if (b) {
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            wrapper.eq(BaseEntity::getId, (Object)entity.getAllotOutId());
            wrapper.set(AssetAllotOutEntity::getReceiveState, (Object)Integer.parseInt(com.ejianc.business.consts.AllocationState.RECEIVED.getCode()));
            wrapper.set(AssetAllotOutEntity::getReceiverPersonId, (Object)vo.getReceiverPersonId());
            wrapper.set(AssetAllotOutEntity::getReceiverPerson, (Object)vo.getReceiverPerson());
            wrapper.set(AssetAllotOutEntity::getReceiveDate, (Object)vo.getReceiveDate());
            this.assetAllotOutService.update((Wrapper)wrapper);
            AssetAllotInVO allotInVO = (AssetAllotInVO)BeanMapper.map((Object)((Object)entity), AssetAllotInVO.class);
            this.assetRecordService.saveRecord((IAssetRecord)allotInVO);
        }
        return CommonResponse.success((String)"\u786e\u8ba4\u6536\u6599\u6210\u529f\uff01");
    }

    @Override
    public CommonResponse<String> sureToReturn(AssetAllotInVO vo) {
        AssetAllotInEntity entity = (AssetAllotInEntity)((Object)this.service.selectById(vo.getId()));
        if (entity == null) {
            return CommonResponse.error((String)"\u6ca1\u6709\u627e\u5230\u8be5\u5355\u636e\uff01");
        }
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.eq(BaseEntity::getId, (Object)entity.getId());
        wrapper.set(AssetAllotInEntity::getBillState, (Object)BillStateEnum.COMMITED_STATE.getBillStateCode());
        wrapper.set(AssetAllotInEntity::getReceiveState, (Object)Integer.parseInt(com.ejianc.business.consts.AllocationState.REJECT.getCode()));
        wrapper.set(AssetAllotInEntity::getReceiveDate, (Object)vo.getReceiveDate());
        wrapper.set(AssetAllotInEntity::getReceiverPersonId, (Object)vo.getReceiverPersonId());
        wrapper.set(AssetAllotInEntity::getReceiverPerson, (Object)vo.getReceiverPerson());
        wrapper.set(AssetAllotInEntity::getReturnReason, (Object)vo.getReturnReason());
        boolean update = this.service.update((Wrapper)wrapper);
        if (update) {
            LambdaUpdateWrapper allotOutWrapper = new LambdaUpdateWrapper();
            allotOutWrapper.eq(BaseEntity::getId, (Object)entity.getAllotOutId());
            allotOutWrapper.set(AssetAllotOutEntity::getReceiveState, (Object)Integer.parseInt(AllocationState.REJECT.getCode()));
            allotOutWrapper.set(AssetAllotOutEntity::getBillState, (Object)BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            allotOutWrapper.set(AssetAllotOutEntity::getReturnReason, (Object)vo.getReturnReason());
            allotOutWrapper.set(AssetAllotOutEntity::getReceiverPersonId, (Object)vo.getReceiverPersonId());
            allotOutWrapper.set(AssetAllotOutEntity::getReceiverPerson, (Object)vo.getReceiverPerson());
            allotOutWrapper.set(AssetAllotOutEntity::getRelationFlag, (Object)0);
            this.assetAllotOutService.update((Wrapper)allotOutWrapper);
        }
        return CommonResponse.success((String)"\u786e\u8ba4\u6536\u6599\u6210\u529f\uff01");
    }
}

