package com.ejianc.business.asset.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.asset.bean.AmortizeSetEntity;
import com.ejianc.business.asset.bean.AssetRecordEntity;
import com.ejianc.business.asset.service.IAmortizeSetService;
import com.ejianc.business.asset.service.IAssetRecordService;
import com.ejianc.business.asset.vo.AssetRecordVO;
import com.ejianc.business.consts.SourceQueryTypeUrlEnum;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.kit.collection.ListUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import com.ejianc.business.asset.bean.AssetEntity;
import com.ejianc.business.asset.service.IAssetService;
import com.ejianc.business.asset.vo.AssetVO;

/**
 *  固定资产
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("asset")
@Api(value = " 固定资产", tags = {" 固定资产"})
public class AssetController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "ASSET_Bli_CODE";//此处需要根据实际修改

    @Autowired
    private IAssetService service;

    @Autowired
    private IAssetRecordService assetRecordService;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IAmortizeSetService amortizeSetService;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<AssetVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody AssetVO saveOrUpdateVO) {
    	AssetEntity entity = BeanMapper.map(saveOrUpdateVO, AssetEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            QueryWrapper<AssetEntity> queryRepeatCodeWrapper = new QueryWrapper<>();
            queryRepeatCodeWrapper.eq("bill_code",saveOrUpdateVO.getBillCode());
            queryRepeatCodeWrapper.select("COUNT(*) as billCode");
            AssetEntity one = service.getOne(queryRepeatCodeWrapper);
            if (!one.getBillCode().equals("0")){
                throw new BusinessException("资产编码重复!");
            }
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setAssetStatus(0);
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }else {
            AssetEntity assetEntity = service.selectById(entity.getId());
            if (!assetEntity.getBillCode().equals(saveOrUpdateVO.getBillCode())){
                QueryWrapper<AssetEntity> queryRepeatCodeWrapper = new QueryWrapper<>();
                queryRepeatCodeWrapper.eq("bill_code",saveOrUpdateVO.getBillCode());
                queryRepeatCodeWrapper.select("COUNT(*) as billCode");
                AssetEntity one = service.getOne(queryRepeatCodeWrapper);
                if (!one.getBillCode().equals("0")){
                    throw new BusinessException("资产编码重复!");
                }
            }
        }
    	service.saveOrUpdate(entity, false);
    	AssetVO vo = BeanMapper.map(entity, AssetVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<AssetVO> queryDetail(@RequestParam Long id) {
    	AssetEntity entity = service.selectById(id);
        AssetVO vo = BeanMapper.map(entity, AssetVO.class);
        if (entity.getBillState().equals(1) || entity.getBillState().equals(3)){
            QueryWrapper<AssetRecordEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("asset_id",id);
            List<AssetRecordEntity> assetRecordList = assetRecordService.list(queryWrapper);
            List<AssetRecordVO> assetRecordVOS = BeanMapper.mapList(assetRecordList, AssetRecordVO.class);
            if (CollectionUtils.isNotEmpty(assetRecordList)){
                for (AssetRecordVO assetRecordVO : assetRecordVOS) {
                    String sourceUrl = SourceQueryTypeUrlEnum.getUrl(assetRecordVO.getSourceType().toString());
                    assetRecordVO.setSourceUrl(sourceUrl);
                }
            }
            vo.setAssetRecordList(assetRecordVOS);
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<AssetVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (AssetVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(AssetVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<AssetVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("equipmentCode");
        fuzzyFields.add("createUserName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        Long parentOrgId = InvocationInfoProxy.getOrgId();
        if (param.getParams().containsKey("parentOrgId")) {
            Object obj = param.getParams().get("parentOrgId").getValue();
            String parentOrgIdStr = String.valueOf(obj);
            parentOrgId = Long.parseLong(parentOrgIdStr);
        }
        List<Long> orgIs =
                iOrgApi.findChildrenByParentId(parentOrgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, orgIs));
        //管理单位过滤
        param.getParams().put("manageCompanyId", new Parameter(QueryParam.IN, orgIs));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<AssetEntity> page = service.queryPage(param,false);
        IPage<AssetVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), AssetVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("equipmentCode");
        fuzzyFields.add("createUserName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<AssetEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        List<AssetVO> assetVOS = BeanMapper.mapList(list, AssetVO.class);
        for (AssetVO assetVO : assetVOS) {
            if (assetVO.getAssetType().equals(1)){
                assetVO.setAssetTypeName("固定资产");
            }else {
                assetVO.setAssetTypeName("普通资产");
            }
            if (assetVO.getEquipmentStatus().equals(1)){
                assetVO.setEquipmentStatusName("再用");
            }else {
                assetVO.setEquipmentStatusName("处置");
            }
            if (assetVO.getSourceType().equals(1)){
                assetVO.setSourceTypeName("验收");
            }
            else if (assetVO.getSourceType().equals(2)){
                assetVO.setSourceTypeName("期初");
            }
            else if (assetVO.getSourceType().equals(3)){
                assetVO.setSourceTypeName("调拨");
            }
            if (assetVO.getFinancePushFlag().equals(1)){
                assetVO.setFinancePushStateName("已推送");
            }else {
                assetVO.setFinancePushStateName("未推送");
            }
        }
        beans.put("records", assetVOS);
        ExcelExport.getInstance().export("Asset-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refAssetData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<AssetVO>> refAssetData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("equipmentName");
        fuzzyFields.add("equipmentCode");
        fuzzyFields.add("spec");
        fuzzyFields.add("billCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter(QueryParam.IN,
                Arrays.asList(new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()})));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (_con.containsKey("projectId")){
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, _con.get("projectId")));
            }
            if (_con.containsKey("manageCompanyId")){
                param.getParams().put("manageCompanyId", new Parameter(QueryParam.EQ, _con.get("manageCompanyId")));
            }
           // amortizeDate 摊销参照条件：上次摊销在此次摊销周期之前 && 净值>0
            if (_con.containsKey("amortizeDate")){
                param.getParams().put("lastAmortizeDate", new Parameter(QueryParam.LT, _con.get("amortizeDate")));
                param.getParams().put("netWorthTax", new Parameter(QueryParam.GT, BigDecimal.ZERO));
            }
            if (_con.containsKey("assetStatus")){
                param.getParams().put("assetStatus", new Parameter(QueryParam.LT, _con.get("assetStatus")));
            }

        }

        IPage<AssetEntity> page = service.queryPage(param,false);
        IPage<AssetVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<AssetVO> assetVOS = BeanMapper.mapList(page.getRecords(), AssetVO.class);
        if (CollectionUtils.isNotEmpty(assetVOS)){
            for (AssetVO assetVO : assetVOS) {
                if (assetVO.getAssetStatus()==0){
                    assetVO.setAssetStatusName("正常");
                }
                if (assetVO.getAssetStatus()==1){
                    assetVO.setAssetStatusName("报废");
                }
                else if (assetVO.getAssetStatus()==2){
                    assetVO.setAssetStatusName("处置");
                }
            }
        }
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), AssetVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    @ApiOperation("查询残值信息")
    @RequestMapping(value = "/queryResidualValueInfo", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<AssetVO> queryResidualValueInfo(@ApiParam(name="vo", required=true) @RequestBody AssetVO vo) {
        Map<Long, Long> amortizeSetmap = new HashMap<>();
        amortizeSetmap.put(vo.getEquipmentId(),vo.getEquipmentTypeId());
        Map<Long, AmortizeSetEntity> amortizeMap = amortizeSetService.getSet(amortizeSetmap);
        AmortizeSetEntity amortizeSetEntity = amortizeMap.get(vo.getEquipmentId());
        if (amortizeSetEntity!=null){
            BigDecimal residualValueRate = amortizeSetEntity.getResidualValueRate();
            logger.info("调用固定资产摊销设置残值率残值率:"+residualValueRate);
            BigDecimal rate = ComputeUtil.safeDiv(residualValueRate, new BigDecimal(100));
            BigDecimal residualValueTax = ComputeUtil.safeMultiply(rate,
                    vo.getOriginalValueTax());
            BigDecimal residualValue = ComputeUtil.safeMultiply(rate,
                    vo.getOriginalValue());
            vo.setResidualValueRate(residualValueRate);
            vo.setResidualValueTax(residualValueTax);
            vo.setResidualValue(residualValue);
        }
        return CommonResponse.success("保存或修改单据成功！",vo);
    }
}
