package com.ejianc.business.purchase.service;

import com.ejianc.business.promaterial.contract.vo.ContractVO;
import com.ejianc.business.purchase.vo.PurchaseContractVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.tender.common.vo.SignContractVo;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.purchase.bean.PurchaseContractEntity;

import java.util.List;
import java.util.Map;

/**
 * 购置合同表
 * 
 * @author generator
 * 
 */
public interface IPurchaseContractService extends IBaseService<PurchaseContractEntity> {

    PurchaseContractVO insertOrUpdate(PurchaseContractVO saveOrUpdateVO, String authority, Boolean isControl);

    Boolean delContractFile(Long fileId, String authority);

    PurchaseContractVO queryDetail(Long id);

    PurchaseContractVO querySupplementRecord(Long id);

    Boolean addSupplementFlag(Long id);

    PurchaseContractVO saveOrUpdateSupplement(PurchaseContractVO saveOrUpdateVO, Boolean isControl);

    PurchaseContractVO addConvertByConId(Long contractId);

    Map<String, Object> countContractAmount(QueryParam param);

    CommonResponse<String> deleteByIds(List<PurchaseContractVO> vos);

    ExecutionVO targetCost(PurchaseContractVO contractVO,String BillType,String linkUrl);

    void pushContract(PurchaseContractVO contractVO);

    boolean checkContract(Long id, Long otherId);

    ParamsCheckVO targetCostCtrl(PurchaseContractVO contractVO, String authority);

    ParamsCheckVO viewTargetCostCtrlInfo(Long id);

    CommonResponse<String> pushTargetCost(Long id);

    ParamsCheckVO checkParams(PurchaseContractVO vo, ParamsCheckVO paramsCheckVO2);
    ParamsCheckVO checkParamsMnySup(PurchaseContractVO vo);

    boolean delWatermarkContractFile(Long watermarkFileId);
    /*施工合同 控 补充协议,主合同
     *        @param 最新合同vo  或 协议vo

     * */
    ParamsCheckVO checkParamsConstruction(PurchaseContractVO vo);

    void updateTargetResult(PurchaseContractVO vo, Integer type);

    List<SignContractVo> queryContractByTargetResultId(List<String> targetResultIdList);
}
