/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.asset.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.asset.bean.AssetEntity;
import com.ejianc.business.asset.bean.HandleDetailEntity;
import com.ejianc.business.asset.bean.HandleEntity;
import com.ejianc.business.asset.service.IAssetRecordService;
import com.ejianc.business.asset.service.IAssetService;
import com.ejianc.business.asset.service.IHandleService;
import com.ejianc.business.asset.vo.HandleVO;
import com.ejianc.business.decorator.IAssetRecord;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="handle")
public class HandleBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IHandleService service;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private IAssetService assetService;
    @Autowired
    private IAssetRecordService assetRecordService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        HandleEntity handleEntity = (HandleEntity)((Object)this.service.selectById(billId));
        List<HandleDetailEntity> handleDetailList = handleEntity.getHandleDetailList();
        if (CollectionUtils.isNotEmpty(handleDetailList)) {
            List assetIds = handleDetailList.stream().filter(s -> s.getRowState() != null).map(HandleDetailEntity::getAssetId).collect(Collectors.toList());
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.in((Object)"id", assetIds);
            queryWrapper.eq((Object)"asset_status", (Object)2);
            List assetEntities = this.assetService.list((Wrapper)queryWrapper);
            if (assetEntities.size() > 0) {
                return CommonResponse.error((String)"\u8bbe\u5907\u4fe1\u606f\u4e2d\u5b58\u5728\u8bbe\u5907\u5df2\u7ecf\u88ab\u5904\u7f6e\u4e0d\u80fd\u518d\u88ab\u5904\u7f6e!");
            }
            for (HandleDetailEntity handleDetailEntity : handleDetailList) {
                LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                updateWrapper.eq(BaseEntity::getId, (Object)handleDetailEntity.getAssetId());
                updateWrapper.set(AssetEntity::getHandleMny, (Object)handleDetailEntity.getHandleMny());
                updateWrapper.set(AssetEntity::getHandleTaxMny, (Object)handleDetailEntity.getHandleTaxMny());
                updateWrapper.set(AssetEntity::getAssetStatus, (Object)2);
                updateWrapper.set(AssetEntity::getEquipmentStatus, (Object)2);
                this.assetService.update((Wrapper)updateWrapper);
            }
            HandleVO vo = (HandleVO)BeanMapper.map((Object)((Object)handleEntity), HandleVO.class);
            this.logger.info("\u8bbe\u5907\u5904\u7f6e\u63a8\u9001\u8bbe\u5907\u6d41\u8f6c\u8bb0\u5f55\u7684\u4fe1\u606f:" + JSONObject.toJSONString((Object)vo));
            this.assetRecordService.saveRecord((IAssetRecord)vo);
            BigDecimal sumHandleDiffMny = handleDetailList.stream().map(HandleDetailEntity::getHandleDiffMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal sumHandleDiffTaxMny = handleDetailList.stream().map(HandleDetailEntity::getHandleDiffTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)billId);
            updateWrapper.set(HandleEntity::getSumHandleDiffMny, (Object)sumHandleDiffMny);
            updateWrapper.set(HandleEntity::getSumHandleDiffTaxMny, (Object)sumHandleDiffTaxMny);
            this.service.update((Wrapper)updateWrapper);
            handleEntity.setSumHandleDiffMny(sumHandleDiffMny);
            handleEntity.setSumHandleDiffTaxMny(sumHandleDiffTaxMny);
            this.logger.info("\u8bbe\u5907\u5904\u7f6e\u63a8\u9001\u5b9e\u9645\u6210\u672c\u4fe1\u606f:" + JSONObject.toJSONString((Object)((Object)handleEntity)));
            this.service.costPush(handleEntity);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse checkCommonResponse = this.billTypeApi.checkQuote(billTypeCode, billId);
        boolean success = checkCommonResponse.isSuccess();
        if (!success) {
            return CommonResponse.error((String)"\u5df2\u7ecf\u88ab\u5f52\u96c6\u5355\u4f7f\u7528,\u4e0d\u80fd\u5f03\u5ba1\u548c\u64a4\u56de");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        HandleEntity handleEntity = (HandleEntity)((Object)this.service.selectById(billId));
        this.logger.info("\u5f03\u5ba1\u63a8\u9001\u6210\u672c---");
        this.logger.info("\u5220\u9664\u6210\u672c\u4e2d\u5fc3\u4e4b\u524d\u7684\u6570\u636e-\u5904\u7f6eId---{}", (Object)handleEntity.getId());
        CommonResponse stringCommonResponse = this.costDetailApi.deleteSubject(handleEntity.getId());
        this.logger.info("\u7ed3\u679c" + JSONObject.toJSONString((Object)stringCommonResponse));
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException(stringCommonResponse.getMsg());
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{handleEntity.getId()});
        updateWrapper.set(HandleEntity::getRelationFlag, (Object)0);
        this.service.update((Wrapper)updateWrapper);
        List<HandleDetailEntity> handleDetailList = handleEntity.getHandleDetailList();
        if (CollectionUtils.isNotEmpty(handleDetailList)) {
            for (HandleDetailEntity handleDetailEntity : handleDetailList) {
                LambdaUpdateWrapper updateAssetWrapper = new LambdaUpdateWrapper();
                updateAssetWrapper.eq(BaseEntity::getId, (Object)handleDetailEntity.getAssetId());
                updateAssetWrapper.set(AssetEntity::getHandleMny, null);
                updateAssetWrapper.set(AssetEntity::getHandleTaxMny, null);
                updateAssetWrapper.set(AssetEntity::getAssetStatus, (Object)1);
                updateAssetWrapper.set(AssetEntity::getEquipmentStatus, (Object)1);
                this.assetService.update((Wrapper)updateAssetWrapper);
            }
            this.assetRecordService.delRecord(billId);
        }
        return CommonResponse.success();
    }
}

