package com.ejianc.business.asset.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.asset.bean.AssetEntity;
import com.ejianc.business.asset.service.IAssetService;
import com.ejianc.business.asset.service.IHandleDetailService;
import com.ejianc.business.asset.vo.AssetVO;
import com.ejianc.business.asset.vo.HandleDetailVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.kit.collection.ListUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import com.ejianc.business.asset.bean.HandleEntity;
import com.ejianc.business.asset.service.IHandleService;
import com.ejianc.business.asset.vo.HandleVO;

/**
 *  设备处置
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("handle")
@Api(value = " 设备处置", tags = {" 设备处置"})
public class HandleController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "HANDLE_CODE";//此处需要根据实际修改

    @Autowired
    private IHandleService service;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IHandleDetailService handleDetailService;

    @Autowired
    private IAssetService assetService;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<HandleVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody HandleVO saveOrUpdateVO) {
    	HandleEntity entity = BeanMapper.map(saveOrUpdateVO, HandleEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                entity.setProportionFlag("0"); // 初始化标识
                entity.setRelationFlag("0"); // 初始化标识
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	HandleVO vo = BeanMapper.map(entity, HandleVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<HandleVO> queryDetail(@RequestParam Long id) {
    	HandleEntity entity = service.selectById(id);
    	HandleVO vo = BeanMapper.map(entity, HandleVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<HandleVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (HandleVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(HandleVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<HandleVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("handlePersonName");
        fuzzyFields.add("orgName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<HandleEntity> page = service.queryPage(param,false);
        IPage<HandleVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), HandleVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("handlePersonName");
        fuzzyFields.add("orgName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<HandleEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        List<HandleVO> handleVOS = BeanMapper.mapList(list, HandleVO.class);
        for (HandleVO handleVO : handleVOS) {
          if (handleVO.getSource().equals(1)){
              handleVO.setSourceName("自制");
          }else {
              handleVO.setSourceName("财务推送");
          }
          if(handleVO.getHandleType().equals(1)){
              handleVO.setHandleTypeName("正常处置");
          }else {
              handleVO.setHandleTypeName("非正常处置");
          }
            handleVO.setBillStateName(BillStateEnum.getEnumByStateCode(handleVO.getBillState()).getDescription());
        }
        beans.put("records", handleVOS);
        ExcelExport.getInstance().export("Handle-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refHandleData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<HandleVO>> refHandleData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<HandleEntity> page = service.queryPage(param,false);
        IPage<HandleVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), HandleVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
    /**
     * 成本改造
     * 关联保存接口
     * @param
     * @return
     */
    @RequestMapping(value = "/pushCost", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<HandleVO> pushCost(@RequestBody HandleVO HandleVO) {
        return service.pushCost(HandleVO);
    }

    /**
     * 固定资产是否已经被处置了
     * @param handleDetailList
     * @return
     */
    @ApiOperation("固定资产是否已经被处置了")
    @RequestMapping(value = "/checkAssetHandle", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<AssetVO>> checkAssetHandle(@RequestBody List<HandleDetailVO> handleDetailList) {
        List<AssetVO> assetVOS=new ArrayList<>();
        List<Long> assetIds =
                handleDetailList.stream().filter(s -> s.getRowState() != "del").map(HandleDetailVO::getAssetId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(assetIds)){
            QueryWrapper<AssetEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.in("id",assetIds);
            queryWrapper.eq("asset_status",2);
            List<AssetEntity> assetEntities = assetService.list(queryWrapper);
            assetVOS = BeanMapper.mapList(assetEntities, AssetVO.class);
        }
        return CommonResponse.success("查询详情数据成功！",assetVOS);
    }
}
