/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.asset.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.asset.bean.AmortizeSetEntity;
import com.ejianc.business.asset.bean.AssetEntity;
import com.ejianc.business.asset.service.IAmortizeSetService;
import com.ejianc.business.asset.service.IAssetRecordService;
import com.ejianc.business.asset.service.IAssetService;
import com.ejianc.business.asset.vo.AssetRecordVO;
import com.ejianc.business.asset.vo.AssetVO;
import com.ejianc.business.consts.SourceQueryTypeUrlEnum;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"asset"})
@Api(value=" \u56fa\u5b9a\u8d44\u4ea7", tags={" \u56fa\u5b9a\u8d44\u4ea7"})
public class AssetController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "ASSET_Bli_CODE";
    @Autowired
    private IAssetService service;
    @Autowired
    private IAssetRecordService assetRecordService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IAmortizeSetService amortizeSetService;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<AssetVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody AssetVO saveOrUpdateVO) {
        AssetEntity entity = (AssetEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, AssetEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            QueryWrapper queryRepeatCodeWrapper = new QueryWrapper();
            queryRepeatCodeWrapper.eq((Object)"bill_code", (Object)saveOrUpdateVO.getBillCode());
            queryRepeatCodeWrapper.select(new String[]{"COUNT(*) as billCode"});
            AssetEntity one = (AssetEntity)((Object)this.service.getOne((Wrapper)queryRepeatCodeWrapper));
            if (!one.getBillCode().equals("0")) {
                throw new BusinessException("\u8d44\u4ea7\u7f16\u7801\u91cd\u590d!");
            }
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            entity.setAssetStatus(0);
            entity.setBillCode((String)billCode.getData());
        } else {
            AssetEntity assetEntity = (AssetEntity)((Object)this.service.selectById(entity.getId()));
            if (!assetEntity.getBillCode().equals(saveOrUpdateVO.getBillCode())) {
                QueryWrapper queryRepeatCodeWrapper = new QueryWrapper();
                queryRepeatCodeWrapper.eq((Object)"bill_code", (Object)saveOrUpdateVO.getBillCode());
                queryRepeatCodeWrapper.select(new String[]{"COUNT(*) as billCode"});
                AssetEntity one = (AssetEntity)((Object)this.service.getOne((Wrapper)queryRepeatCodeWrapper));
                if (!one.getBillCode().equals("0")) {
                    throw new BusinessException("\u8d44\u4ea7\u7f16\u7801\u91cd\u590d!");
                }
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        AssetVO vo = (AssetVO)BeanMapper.map((Object)((Object)entity), AssetVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<AssetVO> queryDetail(@RequestParam Long id) {
        AssetEntity entity = (AssetEntity)((Object)this.service.selectById(id));
        AssetVO vo = (AssetVO)BeanMapper.map((Object)((Object)entity), AssetVO.class);
        if (entity.getBillState().equals(1) || entity.getBillState().equals(3)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"asset_id", (Object)id);
            List assetRecordList = this.assetRecordService.list((Wrapper)queryWrapper);
            List assetRecordVOS = BeanMapper.mapList((Iterable)assetRecordList, AssetRecordVO.class);
            if (CollectionUtils.isNotEmpty((Collection)assetRecordList)) {
                for (AssetRecordVO assetRecordVO : assetRecordVOS) {
                    String sourceUrl = SourceQueryTypeUrlEnum.getUrl((String)assetRecordVO.getSourceType().toString());
                    assetRecordVO.setSourceUrl(sourceUrl);
                }
            }
            vo.setAssetRecordList(assetRecordVOS);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<AssetVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (AssetVO assetVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<AssetVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("equipmentCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long parentOrgId = InvocationInfoProxy.getOrgId();
        if (param.getParams().containsKey("parentOrgId")) {
            Object obj = ((Parameter)param.getParams().get("parentOrgId")).getValue();
            String parentOrgIdStr = String.valueOf(obj);
            parentOrgId = Long.parseLong(parentOrgIdStr);
        }
        List orgIs = ((List)this.iOrgApi.findChildrenByParentId(parentOrgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        param.getParams().put("parentOrgId", new Parameter("in", orgIs));
        param.getParams().put("manageCompanyId", new Parameter("in", orgIs));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), AssetVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("equipmentCode");
        fuzzyFields.add("createUserName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        List assetVOS = BeanMapper.mapList((Iterable)list, AssetVO.class);
        for (AssetVO assetVO : assetVOS) {
            if (assetVO.getAssetType().equals(1)) {
                assetVO.setAssetTypeName("\u56fa\u5b9a\u8d44\u4ea7");
            } else {
                assetVO.setAssetTypeName("\u666e\u901a\u8d44\u4ea7");
            }
            if (assetVO.getEquipmentStatus().equals(1)) {
                assetVO.setEquipmentStatusName("\u518d\u7528");
            } else {
                assetVO.setEquipmentStatusName("\u5904\u7f6e");
            }
            if (assetVO.getSourceType().equals(1)) {
                assetVO.setSourceTypeName("\u9a8c\u6536");
            } else if (assetVO.getSourceType().equals(2)) {
                assetVO.setSourceTypeName("\u671f\u521d");
            } else if (assetVO.getSourceType().equals(3)) {
                assetVO.setSourceTypeName("\u8c03\u62e8");
            }
            if (assetVO.getFinancePushFlag().equals(1)) {
                assetVO.setFinancePushStateName("\u5df2\u63a8\u9001");
                continue;
            }
            assetVO.setFinancePushStateName("\u672a\u63a8\u9001");
        }
        beans.put("records", assetVOS);
        ExcelExport.getInstance().export("Asset-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u53c2\u7167")
    @RequestMapping(value={"/refAssetData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<AssetVO>> refAssetData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("equipmentName");
        fuzzyFields.add("equipmentCode");
        fuzzyFields.add("spec");
        fuzzyFields.add("billCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (_con.containsKey((Object)"projectId")) {
                param.getParams().put("projectId", new Parameter("eq", _con.get((Object)"projectId")));
            }
            if (_con.containsKey((Object)"manageCompanyId")) {
                param.getParams().put("manageCompanyId", new Parameter("eq", _con.get((Object)"manageCompanyId")));
            }
            if (_con.containsKey((Object)"amortizeDate")) {
                param.getParams().put("lastAmortizeDate", new Parameter("lt", _con.get((Object)"amortizeDate")));
                param.getParams().put("netWorthTax", new Parameter("gt", (Object)BigDecimal.ZERO));
            }
            if (_con.containsKey((Object)"assetStatus")) {
                param.getParams().put("assetStatus", new Parameter("eq", _con.get((Object)"assetStatus")));
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List assetVOS = BeanMapper.mapList((Iterable)page.getRecords(), AssetVO.class);
        if (CollectionUtils.isNotEmpty((Collection)assetVOS)) {
            for (AssetVO assetVO : assetVOS) {
                if (assetVO.getAssetStatus() == 0) {
                    assetVO.setAssetStatusName("\u6b63\u5e38");
                }
                if (assetVO.getAssetStatus() == 1) {
                    assetVO.setAssetStatusName("\u62a5\u5e9f");
                    continue;
                }
                if (assetVO.getAssetStatus() != 2) continue;
                assetVO.setAssetStatusName("\u5904\u7f6e");
            }
        }
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), AssetVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ApiOperation(value="\u67e5\u8be2\u6b8b\u503c\u4fe1\u606f")
    @RequestMapping(value={"/queryResidualValueInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<AssetVO> queryResidualValueInfo(@ApiParam(name="vo", required=true) @RequestBody AssetVO vo) {
        HashMap<Long, Long> amortizeSetmap = new HashMap<Long, Long>();
        amortizeSetmap.put(vo.getEquipmentId(), vo.getEquipmentTypeId());
        Map<Long, AmortizeSetEntity> amortizeMap = this.amortizeSetService.getSet(amortizeSetmap);
        AmortizeSetEntity amortizeSetEntity = amortizeMap.get(vo.getEquipmentId());
        if (amortizeSetEntity != null) {
            BigDecimal residualValueRate = amortizeSetEntity.getResidualValueRate();
            this.logger.info("\u8c03\u7528\u56fa\u5b9a\u8d44\u4ea7\u644a\u9500\u8bbe\u7f6e\u6b8b\u503c\u7387\u6b8b\u503c\u7387:" + residualValueRate);
            BigDecimal rate = ComputeUtil.safeDiv((BigDecimal)residualValueRate, (BigDecimal)new BigDecimal(100));
            BigDecimal residualValueTax = ComputeUtil.safeMultiply((BigDecimal)rate, (BigDecimal)vo.getOriginalValueTax());
            BigDecimal residualValue = ComputeUtil.safeMultiply((BigDecimal)rate, (BigDecimal)vo.getOriginalValue());
            vo.setResidualValueRate(residualValueRate);
            vo.setResidualValueTax(residualValueTax);
            vo.setResidualValue(residualValue);
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }
}

